#ifndef GUARD_clock_val_set_h
#define GUARD_clock_val_set_h
/***************************************************************************
                          clock_val_set.h  -  description
                             -------------------
    begin                : Thu Nov 21 2002
    copyright            : (C) 2002 by Goran Frehse
    email                : goran@s.cs.auc.dk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <iostream>
#include <vector>
#include <list>
#include <set>
#include <map>
#include <algorithm>
//#include <stdexcept>

#include <ppl.hh>
//#include "parameters.h"
#include "stopwatch.h"
#include "convex_clock_val_set.h"

extern unsigned int DEBUG_OUTPUT;
extern int MEMORY_MODE;
extern bool INTERSECT_MINIMIZED;
extern bool ADD_CONSTRAINT_MINIMIZED;
// Reachability
extern bool CHEAP_CONTAIN_RETURN_OTHERS;
extern bool USE_CONSTRAINT_HULL;  // use constraint hull instead of convex hull

using namespace Parma_Polyhedra_Library;
using namespace Parma_Polyhedra_Library::IO_Operators;
using namespace std;


// -------------------------------------------------------------------------------
// clock_val_set: disjunction of convex_clock_val_set

class clock_val_set
{
  public:
  clock_val_set();// :dim((size_t) 1)

  clock_val_set(size_t d); //:dim(d) // Constructor: create a single, universe, convex_clock_val_set of dimension dim

  clock_val_set(size_t d, Degenerate_Element kind); //:dim(d) // Constructor: create a single, universe, convex_clock_val_set of dimension dim

  clock_val_set(const convex_clock_val_set &ccvs); //:dim(ccvs.space_dimension()) // Constructor: create a single, universe, convex_clock_val_set of dimension dim

  virtual ~clock_val_set(); // {};  // Destructor: default

  // other methods
  int get_memory() const;
  bool is_empty() const;

	size_t get_real_dimension() const;
	
	unsigned int size() const;
  
  void get_and_add_generators(Generator_List& l) const;  

  // ----------------------------------------
  // Methods for modifying dimensions

  void map_space_dimensions(const PFunction& pfunc);

  void dimension_swap_assign(const dimension_type& x1, const dimension_type& x2, const dimension_type& y);

  void dimension_move_assign(const dimension_type& x1, const dimension_type& x2, const dimension_type& y);

  void add_space_dimensions_and_embed(dimension_type m );

  void add_space_dimensions_and_embed_double(dimension_type m );
  
	void add_space_dimensions_and_embed_before(dimension_type m );

  void add_space_dimensions_and_project(dimension_type m );

  //void remove_space_dimensions( const Variables_Set& to_be_removed);

  void remove_space_dimensions( const clock_ref_set& to_be_removed);

  void remove_space_dimensions(const dimension_type& x1, const dimension_type& x2);

  void concatenate_assign(const clock_val_set& cvs);

  // --------------------------------------
	
	void swap(clock_val_set& cvs);

  void add_constraint(const Constraint& cs);

  void add_constraint(const Constraint_List& CL);
  
  void union_assign(const convex_clock_val_set& ccvs);

  void union_assign(const clock_val_set& cvs);

  void intersection_assign_from(const clock_val_set& cvs, const clock_val_set& cvs2);

  void intersection_assign(const clock_val_set& cvs, bool adapt_dimensions = false);

  convex_clock_val_set get_convex_hull() const;

  void convex_hull_assign();

  void convex_hull_assign(const clock_val_set& cvs);
  
  void constraint_hull_assign(const clock_val_set& cvs);
  
	void remove_redundant();
  
  void remove_redundant(list<convex_clock_val_set>::iterator i, list<convex_clock_val_set>::iterator iend);
  
  void remove_empty_ccvs(list<convex_clock_val_set>::iterator i, list<convex_clock_val_set>::iterator iend);

  void remove_empty_ccvs();
  
  void join_convex_ccvs();
  
  void minimize_constraints();
  
  void minimize_memory();
  
  void simplify();

  void difference_assign(const convex_clock_val_set& ccvs);

  void difference_assign(const clock_val_set& cvs);

  bool difference_is_empty(const convex_clock_val_set& ccvs);

  void negate();

  bool is_disjoint() const;

  bool is_disjoint_from(const clock_val_set& cvs) const;
  
	bool splits(const Constraint& con) const;
	  
	bool contains(clock_val_set cvs) const;
  
  bool contains_return_others(clock_val_set& cvs) const;
  
  bool contains_simple(clock_val_set cvs) const;

  void clock_free(const clock_ref_set& r);
  
  void clock_reset(const clock_ref_set& r);
  
  void time_elapse_assign(const convex_clock_val_set &tp);

  void time_elapse_assign(const convex_clock_val_set &tp, const clock_val_set& inv);
  
  void topological_closure_assign();
  void topological_interior_assign();
  
  convex_clock_val_set append(const convex_clock_val_set& ccvs);

  clock_val_set append(const clock_val_set &cvs);
  
  clock_val_set disj_union_assign(const convex_clock_val_set &ccvs);

  clock_val_set disj_union_assign(const clock_val_set &cvs);

  bool operator==(const clock_val_set& cvs) const;

	// for bounding box
	void set_empty();
	void raise_lower_bound(dimension_type k, bool closed, const Integer& n, const Integer& d);
	void lower_upper_bound(dimension_type k, bool closed, const Integer& n, const Integer& d);

	// linear programming
	bool maximize(const Linear_Expression &expr, Integer &sup_n, Integer &sup_d, bool &maximum) const;
	bool minimize(const Linear_Expression &expr, Integer &inf_n, Integer &inf_d, bool &minimum) const;

	bool limit_significant_bits(int bits);
	int max_bit_size() const;
	
	int max_constraint_size() const;
	int constraint_size() const;
	bool limit_constraints(int n, int bits=0);
	bool limit_constraints_or_bits(int n, int bits=0);
		  
	void ccvs_shrink_bounding_box(clock_val_set& cvs);
	Rational get_diameter();
	
	void print() const;
  void print(const variable_id_map& vnvec) const;
  void print_phaver(ostream& s, const variable_id_map& vnvec) const;
  void print_gen_fp_raw(ostream& s) const;
  void print_con_fp_raw(ostream& s) const;

  // ---------------------------------
  // Properties
  list<convex_clock_val_set> ccvs_list;  // list of convex clock valuation sets
  size_t dim; // dimension of the clock valuation space
};

std::ostream& operator<<( std::ostream& os, const clock_val_set &c );

clock_val_set zero_cvs(const clock_dim_type& dim);

void print_constraints(const clock_val_set& cvs);

// -------------------------


clock_val_set clock_val_set_complement(size_t dim, const Constraint& cs);

clock_val_set complement(const convex_clock_val_set& ccvs);

clock_val_set complement(const clock_val_set& cvs);

// -------------------------

clock_val_set clock_ref_set_to_clock_val_set(const clock_ref_set& crs,const size_t& dim, const clock_ref_set& vars);

clock_val_set identity_trans_clock_val_set(const size_t& dim);

convex_clock_val_set cvs_to_ccvs(const clock_val_set& cvs);


void add_cvs_to_double_point_list(const clock_val_set& cvs,double_point_list& pl);

// -------------------------

bool is_time_relevant(const Constraint& cs, const convex_clock_val_set& tp);

clock_val_set time_relevant_faces(clock_val_set cvs, convex_clock_val_set& tp);

clock_val_set closed_faces(clock_val_set cvs);

clock_val_set cvs_adj_faces(const convex_clock_val_set& cI, clock_val_set& E, clock_val_set Efaces, convex_clock_val_set& tp);

clock_val_set cvs_adj_faces(const convex_clock_val_set& cI, clock_val_set& E);

bool limit_bitsize(Constraint& c, clock_val_set& cvs, bool pos, int bits);

bool minimize_constraint(Constraint& c, clock_val_set& cvs,dimension_type start_dim = 0);

//bool minimize_constraint_from_dim(Constraint& c, const clock_val_set& cvs, dimension_type start_dim);
bool minimize_constraint_from_dim(Constraint& c, const clock_val_set& cvs, dimension_type start_dim, Constraint& c2, bool& c2_active);

#endif
