#ifndef GUARD_convex_clock_val_set_h
#define GUARD_convex_clock_val_set_h
/***************************************************************************
                          convex_clock_val_set.h  -  description
                             -------------------
    begin                : Thu Nov 21 2002
    copyright            : (C) 2002 by Goran Frehse
    email                : goran@s.cs.auc.dk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <iostream>
#include <vector>
#include <list>
#include <set>
#include <map>
#include <algorithm>
#include <stdexcept>


#include <ppl.hh>
#include "general.h"
#include "myPFunction.h"
#include "extended_ppl.h"
#include "rat_linexpression.h"
#include "fp_interface.h"
#include "stopwatch.h"
#include "tnt_array2d.h"
#include "continuous_set.h"

extern int BOUND_BOX_BITSIZE;
extern int LIMIT_CONSTRAINTS_METHOD;
// Reachability
extern bool CHEAP_CONTAIN_RETURN_OTHERS; // analysis parameter defined in parameters.h

using namespace Parma_Polyhedra_Library;
using namespace Parma_Polyhedra_Library::IO_Operators;
using namespace std;

//const unsigned int MAX_UNSIGNED_INT=(unsigned int)(4294967295); //65535;           // WARNING: the number 4294967295 leads to wrong results!!!
const unsigned int MAX_UNSIGNED_INT=65535;
const unsigned int LOCATION_REF_UNREACHABLE=MAX_UNSIGNED_INT-1;
const unsigned int UNUSED_LABEL=65535;
//const Integer infinity=Integer(1000000);


typedef vector<Integer> int_vector_type;

typedef unsigned int vector_index; // type of index for vectors
typedef vector_index location_ref, transition_ref, label_ref, clock_ref, distribution_ref; // reference to locations, here: index into vector
typedef set<location_ref> loc_ref_set;

std::ostream& operator<<( std::ostream& os, const loc_ref_set &c );

//typedef set<dimension_type> variable_ref_set;

class trans_ref_set : public set<transition_ref>
{
  friend std::ostream& operator<<( std::ostream& os, const trans_ref_set &c );

  public:
  bool contains(const transition_ref& tr) const;	
	
  bool contains(const trans_ref_set& set) const;

  transition_ref non_contained_element(const trans_ref_set& set) const;

//  void erase(transition_ref tr);
  
  void decrease_refs(transition_ref tr);
	
  void union_assign(const trans_ref_set& cset);	
};

class label_ref_set : public set<label_ref>
{
  friend ostream&
    operator<<( ostream& os, const label_ref_set &labs );
    
  public:
  bool contains(const label_ref& lab) const;
  
  bool contains(const label_ref_set& set) const;
  
  void difference_assign(const label_ref_set& lab);
  
  void difference_assign(const label_ref& lab);
  
  void union_assign(const label_ref_set& lab);
  
  void union_assign(const label_ref& lab);

  void intersection_assign(const label_ref_set& lab);

};

label_ref_set empty_label_ref_set(); // only because KDevelop displayed classes wrong when label_ref_set() was specified in function header

typedef size_t clock_dim_type;


// -------------------------------------------------------------------------------

typedef list<double> double_criterion;


struct double_criterion_constraint_comp
{
  bool operator()(const pair<double_criterion,Constraint> s1, const pair<double_criterion,Constraint> s2) const
  {
    return (s1.first < s2.first);
  }
};

//   bool operator<(const pair<double_criterion,Constraint> s1, const pair<double_criterion,Constraint> s2) 
//   {
//     return (s1.first < s2.first);
//   };


class convex_clock_val_set : public NNC_Polyhedron
{
  public:
  convex_clock_val_set();
  
  convex_clock_val_set(size_t d); // : NNC_Polyhedron(d) {};
  convex_clock_val_set(size_t d, Degenerate_Element kind); // : NNC_Polyhedron(d,kind) {};
  convex_clock_val_set(const Constraint& con); // : NNC_Polyhedron(con) {};
  convex_clock_val_set(const Constraint_System& con); // : NNC_Polyhedron(con) {};
  convex_clock_val_set(const Generator_System& gen);
	convex_clock_val_set(const Constraint_List& cl, size_t d);

   int get_memory() const;
   
	size_t get_real_dimension() const;
	
	void swap(convex_clock_val_set& ccvs);
  
	void constraint_hull_assign(const convex_clock_val_set& ccvs);
	
	// ----------------------------------------
  // Methods for Generator_List
  
  void get_and_add_generators(Generator_List& l) const;
  
  // ----------------------------------------
  // Methods for modifying dimensions
  void remove_space_dimensions(const clock_ref_set& to_be_removed);
  
  void dimension_swap_assign(dimension_type x1, dimension_type x2, dimension_type y);
  
  void dimension_move_assign(dimension_type x1, dimension_type x2, dimension_type y);

  // ----------------------------------------
  //
  void clock_free(const clock_ref_set& r);
  
  void clock_reset(const clock_ref_set& r);
  
  // ----------------------------------------
  // Methods for time_elapse_poly applications
  void pointmirror_assign();

  void clock_interval_assign(const Variable& var, const Integer& lower, const Integer& upper);

	// for bounding box
	void set_empty();
//	void raise_lower_bound(dimension_type k, bool closed, const Integer& n, const Integer& d);
//	void lower_upper_bound(dimension_type k, bool closed, const Integer& n, const Integer& d);
	void raise_lower_bound(dimension_type k, bool closed, Integer n, Integer d);
	void lower_upper_bound(dimension_type k, bool closed, Integer n, Integer d);

	void shrink_bounding_box(convex_clock_val_set&) {assert(false);};
  
	Rational get_diameter();

	bool limit_significant_bits(int bits);

	int max_bit_size() const;
	int constraint_size() const;
	
	double_criterion limit_constraints_criterion(const Generator_List& gl, const Constraint& c) const;
	
	bool limit_constraints_angle(int n, int bits=0);
	bool limit_constraints_maxdelta(int n, int bits=0);
	bool limit_constraints(int n, int bits=0);

   void minimize_memory();
   
  void print() const;
  void print(const variable_id_map& vnvec) const;
  void print_phaver(ostream& s, const variable_id_map& vnvec) const;
  void print_gen_fp_raw(ostream& s) const;
  void print_con_fp_raw(ostream& s) const;
  
};

void print_constraints(const convex_clock_val_set& ccvs);

void add_ccvs_to_double_point_list(const convex_clock_val_set& ccvs,double_point_list& pl);

void double_point_list_to_ccvs(double_point_list& pl, convex_clock_val_set& ccvs, uint dim);

void add_ccvs_consys_to_double_point_list(const convex_clock_val_set& ccvs,double_point_list& pl);

int trim_to_bits(Integer& d, int bits, bool pos);
void add_bits(Integer& d, int bits);
void limit_bitsize(Integer& n, Integer& d, bool pos, int bits);
void limit_bitsize(Integer& n, int bits);
void limit_bitsize(Linear_Expression& q, int bits);
void limit_bitsize(Constraint& c, int bits);
bool limit_bitsize(Constraint& c, convex_clock_val_set& ccvs, bool pos, int bits);

bool is_generator_on_constraint(const Generator& gl, const Constraint& c);

Constraint bounding_constraint(const Constraint& c, const convex_clock_val_set& ccvs);

Constraint_List convex_clock_val_set_to_Constraint_List(const convex_clock_val_set& ccvs);

// Cone construction and Time Elapse according to
// Sankaranarayanan, Sipma, Manna: "Fixed Point Iteration for Computing the Time Elapse Operator", HSCC'06

convex_clock_val_set get_cone(convex_clock_val_set& p);
convex_clock_val_set map_cone(convex_clock_val_set& p, TNT::Array2D<Integer>& A, TNT::Array1D<Integer>& b, TNT::Array1D<Integer>& den, Rational& lambda);
convex_clock_val_set get_poly_from_cone(convex_clock_val_set& c);

#endif
