/***************************************************************************
 *   Copyright (C) 2004 by Goran Frehse                                    *
 *   gfrehse@localhost                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "optimal_split.h"

bool get_optimal_split_plane(automaton& aut,location_ref loc,clock_val_set inv,const clock_val_set& reached, Constraint& con, bool& failure)
{
	// Restrictions:
	// - convex invariant
	// - 2 dimensional
	
	if (REFINE_LOCATION_PLANE==1)
	{
		// return value, true if successfully found plane
		bool flag_result(false);
		// Initialize parameters
		DHR_THRESHOLD_num=DHR_THRESHOLD_PHAVER.get_num();
		DHR_THRESHOLD_den=DHR_THRESHOLD_PHAVER.get_den();
		DHR_THRESHOLD = new Integer[2];
		DHR_THRESHOLD[0] = DHR_THRESHOLD_num; DHR_THRESHOLD[1] = DHR_THRESHOLD_den;
		dimension_type dim=aut.dim;
	
	//cout << "Threshold " << DHR_THRESHOLD[0] << "/" << DHR_THRESHOLD[1] << endl << flush;
		// Get the indices of the variables to be optimized
		if (REFINE_DHR_VARS.size()!=2)
			throw_error("get_optimal_split_plane: must specify two variables in REFINE_DHR_VARS");
		if (REFINE_DHR_FCTS.size()!=2)
			throw_error("get_optimal_split_plane: must specify two functions in REFINE_DHR_FCTS");
		//uint var1 = 2; 
		//uint var2 = 3;
		uint var1=*REFINE_DHR_VARS.begin();
		uint var2=*(++REFINE_DHR_VARS.begin());
		uint fct1=*REFINE_DHR_FCTS.begin();
		uint fct2=*(++REFINE_DHR_FCTS.begin());
	//cout << "vars " << var1 <<","<< var2 << endl << flush;
	
		// Check for convex invariant
		if (inv.ccvs_list.size()>1)
			throw_error("get_optimal_split_plane: only convex invariants are allowed");
	
		// 1. Compute dynamic matrices
		// Convert the Constraint_List to Constraint_System to get equalities
		DHR_Rational** A;
		DHR_Rational* B;
		A=new DHR_Rational* [2]; // 
		B=new DHR_Rational [2]; // 
	
		int found_vars=0;
	
		const Constraint_List& cl(aut.locations[loc].get_mylinvtef_tp());
	//cout << cl << endl << flush;
		// Go through the coefficients of cl to get the coefficients of A and B matrices
		dimension_type row_index(0);
		Integer den(0);
		for (Constraint_List::const_iterator i=cl.begin();i!=cl.end();++i)
		{
			den=Integer(0);
	//cout << "constraint " << *i << endl << flush;
			// Note: constraints define dynamics as in C dx/dt + A x + B = 0
			// for each constraint, go through the coefficients
			dimension_type i_nonzero(0);
			// get C
			for (dimension_type j=0;j<i->space_dimension()/2;++j)
			{
				if (den==Integer(0)) // the first nonzero variable
				{
					den = i->coefficient(Variable(j));
					i_nonzero=j;
				}
				else if (i->coefficient(Variable(j)) != Integer(0))
					throw_error("optimal_split: more than one dotted variable");
			};
	//cout << "l1 " << row_index << endl << flush;
		
			// if this is the right row, then get the elements of A and B
			if (i_nonzero==fct1 || i_nonzero==fct2)
			{
	++found_vars;
					if (i_nonzero==fct1) row_index=0;
					else row_index=1;
					// get A
					A[row_index] = new DHR_Rational [2];
					// var1
					A[row_index][0] = new Integer [2];
					A[row_index][0][0]=-i->coefficient(Variable(dim+var1));
					A[row_index][0][1]=den;
					A[row_index][1] = new Integer [2];
					A[row_index][1][0]=-i->coefficient(Variable(dim+var2));
					A[row_index][1][1]=den;
	//		cout << "l2 " << row_index << endl << flush;
					// get B
					B[row_index] = new Integer [2];
					B[row_index][0] = -i->inhomogeneous_term();
					B[row_index][1] = den;
	//		cout << "l3 " << row_index << endl << flush;
			};
		};
	/*				// get A
					A[row_index] = new DHR_Rational [2];
					for (dimension_type j=i->space_dimension()/2;j<i->space_dimension();++j)
					{
						A[row_index][j-(i->space_dimension()/2)] = new Integer [2];
						A[row_index][j-(i->space_dimension()/2)][0]=i->coefficient(Variable(j));
						A[row_index][j-(i->space_dimension()/2)][1]=den;
					};
			cout << "l2 " << row_index << endl << flush;
					// get B
					B[(int)row_index] = new Integer [2];
					B[(int)row_index][0] = i->inhomogeneous_term();
					B[(int)row_index][1] = den;
			cout << "l3 " << row_index << endl << flush;
			
					++row_index;
			};
		};
	
	/*
	cout << "l4 " << row_index << endl << flush;
		displayMatrix(A,cs.space_dimension()/2,row_index);
	cout << "l5 " << row_index << endl << flush;
	*/
		// 1. (temporary) assign constant values to matrix A and vector B
	// 	A[0] = new DHR_Rational [2]; A[0][0] = new Integer [2]; A[0][1] = new Integer [2];
	// 	A[1] = new DHR_Rational [2]; A[1][0] = new Integer [2]; A[1][1] = new Integer [2];
	// 
	// 	A[0][0][0] = -6; A[0][0][1] = 5;
	// 	A[0][1][0] = 1;  A[0][1][1] = 10;
	// 	A[1][0][0] = 1;  A[1][0][1] = 10;
	// 	A[1][1][0] = -6; A[1][1][1] = 5;
	
	/*	B[0] = new Integer [2]; B[1] = new Integer [2];
		B[0][0] = 0; B[0][1] = 1;
		B[1][0] = 0; B[1][1] = 1;*/
	
	if (found_vars==2)
	{
	//displayMatrix(A,2,2);
		// 2. Compute range of dynamics
		// get derivatives as polyhedron	
		
		clock_ref_set my_vars;
		my_vars.insert(var1);
		my_vars.insert(var2);
		clock_ref_set crs = aut.variables;
		crs.difference_assign(my_vars);
		inv.remove_space_dimensions(crs);
	
		// 3. Convert clock_val_set to PolyhedronSet
		DHR_PolyhedronSet* polyhedronSet=new DHR_PolyhedronSet();
		for (list<convex_clock_val_set>::const_iterator i = inv.ccvs_list.begin(); i != inv.ccvs_list.end(); ++i)
		{
			C_Polyhedron* tmp = new C_Polyhedron(*i);
	//cout <<"Invariant Polyhedron:" << endl;
	//cout << *tmp << endl;
	//cout <<"-------------------------------------" << endl << flush;
			polyhedronSet->add(tmp,A,B);
		};
	
	
		DHR_Rational* lineCut = getOptimalCut(polyhedronSet->polyhedron, polyhedronSet->sizeRange, A, B);
	if (DHR_output_level >= 1)
	{
	cout << "Optimal line Cut: ";
	displayRat(lineCut[0]); cout << "x + "; 
	displayRat(lineCut[1]); cout << "y = "; 
	displayRat(lineCut[2]); cout << endl << flush;
	};
	
		if ((lineCut[0][0] != 0) || (lineCut[1][0] != 0) || (lineCut[2][0] != 0))
		{
			flag_result = true;
			Linear_Expression e;
						e += lineCut[0][0]*lineCut[1][1]*lineCut[2][1] * Variable(var1);
			e += lineCut[0][1]*lineCut[1][0]*lineCut[2][1] * Variable(var2);
			con=(e==lineCut[0][1]*lineCut[1][1]*lineCut[2][0]+0*Variable(inv.dim-1));
		}
		else
		{
			flag_result = false;
		};
	
		// Limit the number of bits in con
	//	if (Constraint_max_bit_size(con)>REACH_BITSIZE_TRIGGER)
		if (Constraint_max_bit_size(con)>CONSTRAINT_BITSIZE)
			limit_bitsize(con,CONSTRAINT_BITSIZE);
	
	//cout << "Freeing memory\n" << flush;
		delete polyhedronSet;
		delete[] A[0][0]; delete[] A[0][1]; 
		delete[] A[1][0]; delete[] A[1][1]; 
		delete[] A[0]; delete[] A[1]; delete[] A;
		delete[] B[0]; delete[] B[1]; delete[] B;
		delete[] lineCut;
	}
	else
	{
	//cout << "Didn't find two variables" << endl << flush;
	};
		delete[] DHR_THRESHOLD;
	//cout << "Leaving get_optimal_split_plane\n" << flush;
		return flag_result;
	}
	else if (REFINE_LOCATION_PLANE==2)
	{
 		// compute the angle spanned by the derivative in the vertices 
		double_point_list pl,dl;
		if (REFINE_USE_FP)
		{
			add_cvs_to_double_point_list(aut.locations[loc].invariant(),pl);
//cout << "g";
			get_loc_deriv(aut,loc,pl,dl);
		}
		else
		{
//			get_loc_deriv_nonfp(aut,loc,aut.locations[loc].invariant(),dl);
	add_ccvs_to_double_point_list(aut.locations[loc].time_post_poly(),dl);
		};

		double_point g1,g2;
		double angle = get_double_point_list_angle_vecs(dl,g1,g2);
//cout << dl;
		g1/=sqrt(norm2(g1));
		g2/=sqrt(norm2(g2));
//cout << aut.locations[loc].invariant();
//cout << "angle " << angle << ":" << g1 << "," << g2 << endl << flush;
		// compute the cutting plane
 if (angle<-1+0.0001)
   {
     failure=true;
     return false;
   }; 
		if (angle<1 && angle<DHR_THRESHOLD_PHAVER.get_double())
		{
			g1-=g2;
			g1/=sqrt(norm2(g1));
			//cout << "norm:" << sqrt(norm2(g1)) << endl;
			Linear_Expression lin;
			Integer d;
			double_point_to_Linear_Expression(g1,lin,d);
			con=(lin==0);
limit_bitsize(con,CONSTRAINT_BITSIZE);
//cout << con << endl;
			return true;
		};
		return false;
	};

	return false;
}


void set_REFINE_DHR_VARS(clock_ref_set& crs, clock_ref_set& crs2)
{
	REFINE_DHR_VARS=crs;
	REFINE_DHR_FCTS=crs2;
}

void set_DHR_THRESHOLD_PHAVER(Rational r)
{
	DHR_THRESHOLD_PHAVER=r;
}

bool is_reachable_DHR(automaton& aut,const symb_states_type& orig_target,Rational split_ratio,symb_states_type& reach_set)
{
	// start with initial states
	aut.ini_states.loc_names_assign(aut.get_loc_names_map());
	symb_states_type source_states(aut.ini_states);
	symb_states_type target_states(orig_target);
	//symb_states_type reach_set;
	symb_states_type temp_target; //gf
	bool failure;
	
	// memorize original constraints
	list <ConstraintRatPair> orig_constraints(REFINE_CONSTRAINTRATPAIRLIST);
	double orig_angle=REFINE_DERIV_MINANGLE;
	
	REFINE_CONSTRAINTRATPAIRLIST.clear();
	bool refinement_possible=true;
	
	int count=0;
	string movie_filename("out_mov");
	bool is_reachable=true;
	symb_states_type rs2;
	clock_ref_set crs;
   
   symb_states_type dummystates;
   bool dummybool;

	while (refinement_possible && is_reachable) 
	{
		reach_set=aut.get_reach_set(source_states,dummystates,dummybool);	
		
		// output the reachable states
		if (aut.dim>2)
		{
		  for (uint i1=0;i1+1<aut.dim;++i1)
		    {
		      for (uint i2=i1+1;i2<aut.dim;++i2)
			{
			  // make clock set
			  crs.clear();
			  for (uint i=0;i<aut.dim;++i)
			    if (i!=i1 && i!=i2) crs.insert(i);

			  rs2=reach_set;
			  rs2.remove_space_dimensions(crs);
			  rs2.save_gen_fp_raw(movie_filename+"_x"+int2string(i1)+"x"+int2string(i2)+"_"+int2string(1000000+count));		
			};
		    };

		}
		else
			reach_set.save_gen_fp_raw(movie_filename+"_r_"+int2string(1000000+count));		
		
		aut.invariant_assign(reach_set,false);// false : no need to map locations
		//		reach_set.intersection_assign(target_states,true); 
		temp_target=target_states;
		temp_target.intersection_assign(reach_set,true);
		//		cout << "temp_target.ccvs_size " << temp_target.ccvs_size();
		temp_target.simplify();
		//		cout << "temp_target.ccvs_size after simplify " << temp_target.ccvs_size();
		if (temp_target.is_empty())
		{
			is_reachable=false;
		}
		else
		{
			target_states=source_states;
			source_states=temp_target;
			clock_val_set inv1,inv2;
			bool splits_reached;
			
			// partition locations
			bool found_plane=true;
			Rational split_count=0;
			location_ref max_loc;
			Rational max_dia(0),d;
			Constraint con(Variable(0)*0==0); // dummy initialization
			loc_ref_list new_locs; // contains the newly created locs
			while (found_plane && split_count<split_ratio)
			{	
				split_count=split_count+Rational(1);
				
				// Find the location in reach_set with the largest diameter
				found_plane=false;
				for (symb_states_type::const_iterator i=reach_set.begin();i!=reach_set.end();++i)
				{	
					d=aut.locations[(i->first)].time_post_poly().get_diameter();
					if (d>max_dia)
					{
						max_dia=d;
						max_loc=i->first;
						found_plane=true;
					};
				};
				
				// Find a splitting plane for this location
				//				found_plane = found_plane && get_optimal_split_plane(aut,max_loc,aut.locations[max_loc].invariant(),reach_set[max_loc],con,failure);
				if (REFINE_LOCATION_PLANE<=1)
					found_plane = found_plane && get_refinement_constraint(aut,max_loc,aut.locations[max_loc].invariant(),reach_set[max_loc],con,splits_reached);
				else
					found_plane = found_plane && get_refinement_invariants(aut,max_loc,aut.locations[max_loc].invariant(),reach_set[max_loc],inv1,inv2,splits_reached);			
				if (found_plane && !failure)
				{
					// split the location in the automaton
				  if (REFINE_LOCATION_PLANE<=1)
					split_location(aut,REFINEMENT_LABEL,max_loc,con,new_locs); // comment: new_locs only ever gets one element here
				  else
					split_location(aut,REFINEMENT_LABEL,max_loc,inv1,inv2,new_locs); // comment: new_locs only ever gets one element here
					// split the location in the reach_set
					reach_set.split(max_loc,*new_locs.begin(),con);
				};
			};

			aut.reverse();
			
			// reduce the threshold
			if (REFINE_LOCATION_PLANE != 2)
			  DHR_THRESHOLD_PHAVER = DHR_THRESHOLD_PHAVER/Rational(2);
			else
			  DHR_THRESHOLD_PHAVER = Rational(1,2)+DHR_THRESHOLD_PHAVER/Rational(2); // converges to 1
		};
	};
	
	REFINE_CONSTRAINTRATPAIRLIST=orig_constraints;
	REFINE_DERIV_MINANGLE=orig_angle;

return is_reachable;

}
