/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Wed Nov 20 21:44:14 CET 2002
    copyright            : (C) 2002 by Goran Frehse
    email                : goran@s.cs.auc.dk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Note: compile parser with yl_make parser

#include "phaver.h"
#include <stdio.h>
#include <fstream>

#define CPLUSPLUS

#define c_plusplus
// already define: #define __cplusplus

#define YY_SKIP_YYWRAP

int yywrap(void) { 
  return 1; 
}

#include "parser.tab.c"
#include "lex.yy.c"


//FILE * yyin;
using namespace std;
using namespace Parma_Polyhedra_Library;

#define DEBUG 1

#include "globals.h"

int main(int argc, char *argv[])
{

  #include "test.h"
	FP_PRECISION=24;
	yydebug=0;

  stopwatch sw(1000,"PHAVer");
//	cout.precision(FP_PRECISION); // set significant digits in floating point output
  
//  welcome_message();

  process_flags(argc,argv);
  // terminate if only display options, no arguments, i.e. no filename
  if (argc==1) {
//    help_message();
    exit(1);
  }

  //cout << endl;
  //cout << endl;

  message(10,"Finished. Exiting.");

  return EXIT_SUCCESS;
}


void welcome_message()
{
  cout << "PHAVer v0.38, last modified Jan. 9, 2007, compiled " << __DATE__ << ", " << __TIME__ << endl << endl;
}

void help_message()
{
  cout << "Usage: phaver [OPTIONS] <filename> [ [OPTIONS] <filename> ... ]" << endl;      
  cout << endl;
  cout << "Command line options:" << endl;   
  cout << " -h  more information:" << endl;   
  cout << " -v  detailed output and timers, e.g. -v32011:" << endl;   
  cout << "     -vXXXXXX : A higher number XXX yields more information, in exponential scale." << endl;   
  cout << "                Default is 8000, 32000 is detailed, 256000 is for debugging." << endl;   
  cout << "     -vXXXXX1 : Shows timers" << endl;   
  cout << "     -vXXXX1X : Shows progress-dots (.....)  " << endl;   
  cout << " -y  : debug parser" << endl;
  cout << endl;
  cout << "For further information visit: http://www.cs.ru.nl/~goranf/" << endl;
  cout << "or contact gfrehse@ece.cmu.edu" << endl;
  cout << endl;
  cout << "Copyright Goran Frehse, 2004, 2005, 2006" << endl;
}

void info_message()
{
  cout << "The following options are available, and can be declared True or False (default):" << endl;
  cout << "  " << endl;
  cout << "Reachability:" << endl;
  cout << "- CHEAP_CONTAIN_RETURN_OTHERS (true)"  << endl;
  cout << "  Under-approximating containment test for new states." << endl;
  cout << "- REACH_USE_CONVEX_HULL (false)"  << endl;
  cout << "  Compute convex hull of reachable states." << endl;
  //"REACH_STOP_AT_FORB"
  cout << "  " << endl;
  cout << "Simulation:" << endl;
  cout << "- SIM_PRIME_WITH_REACH (true)"  << endl;
  cout << "  Initialize the simulation relation with the set of reachable states." << endl;
  cout << "- SIM_USE_CONVEX_HULL_FOR_PRIMING  (true)"  << endl;
  cout << "  Use convex-hull of reachable states in initialization." << endl;
  cout << "- SHOW_BAD_STATES (false)"  << endl;
  cout << "  Output bad states as they are encountered" << endl;
  cout << "  " << endl;
  cout << "Minimization:" << endl;
  cout << "- MINIM_PRIME_R_WITH_REACH (false)"  << endl;
  cout << "  Initialize the simulation relation used in minimzation with the set of reachable states." << endl;
  cout << "- MINIM_USE_CONVEX_HULL_FOR_PRIMING (false)" << endl;
  cout << "  Use convex-hull of reachable states in initialization." << endl;
  cout << "  " << endl;
  cout << "Composition:" << endl;
  cout << "- COMPOSE_WITH_REACH_MIN (false)"  << endl;
  cout << "  Compose only reachable states. If false, a discrete over-approximation is used." << endl;
  cout << "- COMPOSE_USE_CONVEX_HULL_FOR_REACH (true)"  << endl;
  cout << "  Use convex-hull of reachable states in composition." << endl;
  cout << "  " << endl;
  cout << "  " << endl;
  cout << "Analysis Commands:  " << endl;
  cout << "  " << endl;
  cout << "<ident> = reachable (<aut>);  " << endl;
  cout << "  - Assign to <ident> the set of reachable states in <aut>." << endl;
  cout << "  " << endl;
  cout << "<ident1> = <ident2>;  " << endl;
  cout << "  - Assign to <ident1> a copy of <ident2>." << endl;
  cout << "  " << endl;
  cout << "<ident> = <aut>.{<state_list>};  " << endl;
  cout << "  - Assign to <ident> the states in <aut> listed in <state_list>." << endl;
  cout << "  " << endl;
  cout << "<ident> = {<state_list>};  " << endl;
  cout << "  - Assign to <ident> the states of the last occured automaton listed in <state_list>." << endl;
  cout << "  " << endl;
  cout << "check(<aut1> <= <aut2>);  " << endl;
  cout << "  - Check if <aut2> simulates <aut1>." << endl;
  cout << "  " << endl;
  cout << "<ident> = get_sim(<aut1>,<aut2>);  " << endl;
  cout << "  - Assign to <ident> the simulation relation between <aut1> and <aut2>" << endl;
  cout << "  " << endl;
  cout << "print(<aut>); " << endl;
  cout << "  - Output the automaton." << endl;
  cout << "  " << endl;
  cout << "reachable(<aut>);  " << endl;
  cout << "  - Output the reachable states of <aut>" << endl;
  cout << "  " << endl;
  cout << "<ident> = reachable(<aut>,{<state_list>});  " << endl;
  cout << "  - Assign to <ident> the states in <state_list> that are reachable in <aut>." << endl;
  cout << "  " << endl;
  cout << "reachable_stop(<aut>,{<state_list});  " << endl;
  cout << "  - Check if states in <state_list> are reachable in <aut>." << endl;
  cout << "    Stop as soon as any are found, and output states." << endl;
  cout << "  " << endl;
  cout << "ag_sim(<aut1>,<aut2>,<aut3>,<aut4>);  " << endl;
  cout << "  - Check for AG-simulation (no shared variables)." << endl;
  cout << "  " << endl;
  cout << "agc_sim(<aut1>,<aut2>,<aut3>,<aut4>);  " << endl;
  cout << "  - Check for AG-simulation with right side composed (shared variables)." << endl;
  cout << "  " << endl;
  cout << "get_parameters(<ident>,<bool>);  " << endl;
  cout << "  - <bool>=true: return parameters that occur in any of the states in <ident>" << endl;
  cout << "  - <bool>=false: return parameters that occur in all of the states in <ident>" << endl;
  cout << "  " << endl;
  cout << "<ident>.print;  " << endl;
  cout << "  - Output states or relation." << endl;
  cout << "  " << endl;
  cout << "<ident>.remove(<var_list>);  " << endl;
  cout << "  - Perform existential quantification over <var_list>." << endl;
  cout << "  " << endl;
  cout << "<ident>.loc_union;  " << endl;
  cout << "  - Output continuous states in any of the locations." << endl;
  cout << "  " << endl;
  cout << "<ident>.loc_intersection;  " << endl;
  cout << "  - Output continuous states in any of the locations." << endl;
  cout << "  " << endl;
  cout << "<ident1>.intersection_assign(<ident2>);  " << endl;
  cout << "  - Intersect states." << endl;
  cout << "  " << endl;
  cout << "<ident>.is_empty;  " << endl;
  cout << "  - Check for emptyness of set of states." << endl;
  cout << "  " << endl;
  cout << "echo \"<text>\";  " << endl;
  cout << "  - Output <text>." << endl;
  cout << "  " << endl;
  cout << "  " << endl;
  cout << "  " << endl;
  cout << "<ident> : Identifier for a set of states or a relation." << endl;
  cout << "<aut>   : A sequence <a1>&<a2>&... where the <ai> are previously defined automata." << endl;
  cout << "<state_list> : A sequence <loc1>&<formula1>,<loc2)&<formula2>,... of location names and formulas. For a composed automaton, the location names are attached with *, i.e., <loc1>*<loc2> etc." << endl;
  cout << "  " << endl;
  cout << flush;  
}

void
process_flag(char *flagstr) {
  switch (flagstr[0]) {
  case 'h':
    // output more info, then quit
	  welcome_message();
    info_message();
    exit(1);
    break;
  case 'v' :
    // verbose level, higher is more
    if ((strlen(flagstr) < 2) )
    {
      throw_warning("Illegal flag: -v<integer> required");
    }
    else {
      VERBOSE_LEVEL = atoi(flagstr+1);
      message(256000,"Setting output level to " + int2string(VERBOSE_LEVEL) + ".");
    };
    break;
  case 'd' :
    // debug output, extremely verbose
    if ((strlen(flagstr) < 2) )
    {
      DEBUG_OUTPUT = 1;
    }
    else {
      DEBUG_OUTPUT = atoi(flagstr+1);
      message(256000,"Setting debug output level to " + int2string(DEBUG_OUTPUT) + ".");
    };
    break;
  case 'y' :
    yydebug = 1;

  default:
     cerr << "Warning: illegal flag (" << flagstr << ") ignored\n";
     break;
  }
}


void
process_flags(int agc, char *agv[]) {
// assume agv[0] is name of program.
// agv[agc] is input file name if it isn't a flag.
//
  int i;
  char* infilename;
  
  // set defaults

  if (agc==1) {
	  welcome_message();
    help_message();
  }
  else {
    for(i=1;i<agc;i++) {
      if (agv[i][0] == '-') {
        // then process a flag
        process_flag(agv[i]+1);
      }
      else {
        // parse as input file
        infilename = agv[i];
        message(2000,"Parsing file " + (string)infilename + ".");
        yyin = fopen( infilename, "r" );	/* doesn't deal with recursive loads */
        if (yyin==NULL)
        {
          fprintf( stderr, "*** Error opening `%s' ***\n", agv[i] );
          fflush(stderr);
          yyin=stdin;
        }/*  else printf( "--Taking input from %s...\n", argv[argc-1] ); */
        else
        {
          line_number=1;
          yyparse();
          fclose(yyin);
        };
      }
    }
  }
}

