/***************************************************************************
 *   Copyright (C) 2004 by Goran Frehse                                    *
 *   gfrehse@localhost                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "rat_linexpression.h"

Rational::Rational(const string& str)
{
	string flt(""),expon(""),numstr(""),denstr("");
	
	// if there's an exponent, find it and put the rest in flt
	int e=0;	
	if (str.find("e")!=string::npos)
	{
		flt=string_before(str,"e");
		expon=string_after(str,"e");
		e=atoi(expon.c_str());
	}
	else if (str.find("E")!=string::npos)
	{
		flt=string_before(str,"E");
		expon=string_after(str,"E");
		e=atoi(expon.c_str());
	}
	else
		flt=str;
	
	numstr=string_before(flt,".");
	denstr=string_after(flt,".");
	
	// Conversion is simple: 
	// Count the number of decimal places
	// and subtract them from the exponent
	e-=denstr.size();	
	mpq_class q(numstr+denstr,10); // 10 is the base
	
//cout << endl << numstr+denstr << "->" << q << endl << flush;

//cout << "Net Exponent: " << e << endl;	

	mpz_class den(1);
	// for a positive exponent, multiply the numerator
	while (e>0)
	{
		--e;
		q.get_num()*=mpz_class(10);
	};
	// for a negative exponent, multiply the denominator
	while (e<0)
	{
		++e;
		den*=mpz_class(10);
	};
		
	q.get_den()*=den;
		
//cout << endl << str << "-e>" << q << endl << flush;	
	
	this->mpq_class::operator=( q );
	
//cout << endl << str << "==>" << *this << endl << flush;	
}

// bool operator<(const Rational& r1, const Rational& r2)
// {
// 	// Note: only true if denominator is always greater than zero
// 	if (((r2.get_den() > 0) && (r1.get_den() > 0)) || ((r2.get_den() < 0) && (r1.get_den() < 0)))
// 		return (r2.get_den())*(r1.get_num())<(r1.get_den())*(r2.get_num());
// 	else if (((r2.get_den() < 0) && (r1.get_den() > 0)) || ((r2.get_den() > 0) && (r1.get_den() < 0)))
// 		return (r2.get_den())*(r1.get_num())>(r1.get_den())*(r2.get_num());
// 	else
// 	{
// 		throw_error("Rational operator<(const Rational& r1, const Rational& r2): denominator == 0!");
// 		return false;
// 	};
// }
// 
// bool operator<=(const Rational& r1, const Rational& r2)
// {
// 	// Note: only true if denominator is always greater than zero
// 	if (((r2.get_den() > 0) && (r1.get_den() > 0)) || ((r2.get_den() < 0) && (r1.get_den() < 0)))
// 		return (r2.get_den())*(r1.get_num())<=(r1.get_den())*(r2.get_num());
// 	else if (((r2.get_den() < 0) && (r1.get_den() > 0)) || ((r2.get_den() > 0) && (r1.get_den() < 0)))
// 		return (r2.get_den())*(r1.get_num())>=(r1.get_den())*(r2.get_num());
// 	else
// 	{
// 		throw_error("Rational operator<(const Rational& r1, const Rational& r2): denominator == 0!");
// 		return false;
// 	};
// }
// 
// bool operator>(const Rational& r1, const Rational& r2)
// {
// 	// Note: only true if denominator is always greater than zero
// 	if (((r2.get_den() > 0) && (r1.get_den() > 0)) || ((r2.get_den() < 0) && (r1.get_den() < 0)))
// 		return (r2.get_den())*(r1.get_num())>(r1.get_den())*(r2.get_num());
// 	else if (((r2.get_den() < 0) && (r1.get_den() > 0)) || ((r2.get_den() > 0) && (r1.get_den() < 0)))
// 		return (r2.get_den())*(r1.get_num())<(r1.get_den())*(r2.get_num());
// 	else
// 	{
// 		throw_error("Rational operator<(const Rational& r1, const Rational& r2): denominator == 0!");
// 		return false;
// 	};
// }
// 
// bool operator>=(const Rational& r1, const Rational& r2)
// {
// 	// Note: only true if denominator is always greater than zero
// 	if (((r2.get_den() > 0) && (r1.get_den() > 0)) || ((r2.get_den() < 0) && (r1.get_den() < 0)))
// 		return (r2.get_den())*(r1.get_num())>=(r1.get_den())*(r2.get_num());
// 	else if (((r2.get_den() < 0) && (r1.get_den() > 0)) || ((r2.get_den() > 0) && (r1.get_den() < 0)))
// 		return (r2.get_den())*(r1.get_num())<=(r1.get_den())*(r2.get_num());
// 	else
// 	{
// 		throw_error("Rational operator<(const Rational& r1, const Rational& r2): denominator == 0!");
// 		return false;
// 	};
// }

Rational operator-(const Rational& r)
{
	return Rational(-r.get_num(),r.get_den());
}

Rational operator/(const Rational& r1, const Rational& r2) 
{ 
	if ( r2.get_num() == Integer(0) )
		throw_error("Division of rational by zero!");
	return Rational(r1.get_num()*r2.get_den(),r2.get_num()*r1.get_den());  
}

Rational operator*(const Rational& r1, const Rational& r2) 
{ 
	return Rational(r1.get_num()*r2.get_num(),r2.get_den()*r1.get_den());  
}

Rational operator-(const Rational& r1, const Rational& r2) 
{ 
	return Rational(r1.get_num()*r2.get_den()-r1.get_den()*r2.get_num(),r2.get_den()*r1.get_den());  
}


Rational operator+(const Rational& r1, const Rational& r2) 
{ 
	return Rational(r1.get_num()*r2.get_den()+r1.get_den()*r2.get_num(),r2.get_den()*r1.get_den());  
}
 
Rational_Linear_Expression::Rational_Linear_Expression(const string& str):Linear_Expression(0),denominator(1)
{
//	mpf_class f(str);
//	Rational r(f);
	Rational r(str);
//	cout << str << "r: " << r << endl;
//	cout << r.get_num() << flush << endl;
//	cout << r.get_d() << endl;
	this->Linear_Expression::operator=( Linear_Expression(r.get_num()) );
	denominator=r.get_den();
}

Rational_Linear_Expression operator+(const Rational_Linear_Expression& l1, const Rational_Linear_Expression& l2)
{
	Rational_Linear_Expression r;
   if (l2.denominator != l1.denominator)
   {
	  r.Linear_Expression::operator=( l2.denominator*(Linear_Expression)l1+l1.denominator*(Linear_Expression)l2 );
	  r.denominator=l1.denominator*l2.denominator;
   }
   else
   {
	  r.Linear_Expression::operator=( (Linear_Expression)l1+(Linear_Expression)l2 );
	  r.denominator=l1.denominator;
   }   
	
	return r;
}

Rational_Linear_Expression operator-(const Rational_Linear_Expression& l1, const Rational_Linear_Expression& l2)
{
	Rational_Linear_Expression r;
   if (l2.denominator != l1.denominator)
   {
	  r.Linear_Expression::operator=( l2.denominator*(Linear_Expression)l1-l1.denominator*(Linear_Expression)l2 );
	  r.denominator=l1.denominator*l2.denominator;
   }
   else
   {
	  r.Linear_Expression::operator=( (Linear_Expression)l1-(Linear_Expression)l2 );
	  r.denominator=l1.denominator;
   }   
	
	return r;
}

Rational_Linear_Expression& operator+=(Rational_Linear_Expression& l1, const Rational_Linear_Expression& l2)
{
   if (l2.denominator != l1.denominator)
   {
	  l1.Linear_Expression::operator=( l2.denominator*(Linear_Expression)l1+l1.denominator*(Linear_Expression)l2 );
	  l1.denominator*=l2.denominator;
   }
   else
   {
	  l1.Linear_Expression::operator=( (Linear_Expression)l1+(Linear_Expression)l2 );
   }   
	
	return l1;
}

Rational_Linear_Expression& operator-=(Rational_Linear_Expression& l1, const Rational_Linear_Expression& l2)
{
   if (l2.denominator != l1.denominator)
   {
	  l1.Linear_Expression::operator=( l2.denominator*(Linear_Expression)l1-l1.denominator*(Linear_Expression)l2 );
	  l1.denominator*=l2.denominator;
   }
   else
   {
	  l1.Linear_Expression::operator=( (Linear_Expression)l1-(Linear_Expression)l2 );
   }   
	
	return l1;
}

Rational_Linear_Expression operator*(const Rational& c, const Rational_Linear_Expression& l)
{
	Rational_Linear_Expression r;
   r.Linear_Expression::operator=( c.get_num()*(Linear_Expression)l );
	r.denominator=l.denominator*c.get_den();
	
   return r;
}

std::ostream&
operator<<( std::ostream& os, const Rational_Linear_Expression &r )
  {
    os << "(" << (Linear_Expression)r << ")/" << r.denominator;
    return os;
  }
	
bool attempt_multiply(Rational_Linear_Expression& l1, Rational_Linear_Expression& l2)
{ // multiply if l1 or l2 is a scalar and put the result in l1. Return true if successful.
  
	if (get_true_dimension(l1)==0) // l1 is a scalar
  {
    l1.Linear_Expression::operator=(l1.Linear_Expression::inhomogeneous_term()*(Linear_Expression)l2);
		l1.denominator*=l2.denominator;
    return true;
  }
  else if (get_true_dimension(l2)==0)
  {
    l1.Linear_Expression::operator=(l2.Linear_Expression::inhomogeneous_term()*(Linear_Expression)l1);
		l1.denominator*=l2.denominator;
		return true;
  }
  else
    return false;
}

bool attempt_division(Rational_Linear_Expression& l1, Rational_Linear_Expression& l2)
{ // divide if l2 is a scalar and put the result in l1. Return true if successful.
  
  if (l2.Linear_Expression::inhomogeneous_term() == Integer(0))
		throw_error("Division of rational by zero!");
		
  if (get_true_dimension(l2)==0)
  {
    l1.Linear_Expression::operator=(l2.denominator*(Linear_Expression)l1);
		l1.denominator*=l2.Linear_Expression::inhomogeneous_term();
		return true;
  }
  else
    return false;
}
