#ifndef GUARD_symb_states_type_h
#define GUARD_symb_states_type_h
/***************************************************************************
                          symb_states.h  -  description
                             -------------------
    begin                : Thu Feb 5 2004
    copyright            : (C) 2004 by Goran Frehse
    email                : goran.frehse@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <iostream>
#include <fstream>
#include <vector>
#include <list>
#include <set>
#include <algorithm>
#include <stdexcept>

#include "clock_val_set.h"

//using namespace Parma_Polyhedra_Library;
//using namespace Parma_Polyhedra_Library::IO_Operators;
//using namespace std;

extern int REACH_CONSTRAINT_LIMIT;
extern int CONSTRAINT_BITSIZE;
 
string lication_name_unrefined(const string& l1);
bool location_name_compare_wildcard(const string& l1, const string& l2);
bool location_name_contains(const string& l1, const string& l2);
string location_name_intersection(const string& l1, const string& l2);

typedef map <location_ref,string> loc_names_map;

class symb_states_type : public map<location_ref, clock_val_set> // states of several locations
{
  public:
  symb_states_type();
  symb_states_type(const variable_id_map& v);
	symb_states_type& operator=(const symb_states_type& s);
  int get_memory() const;

	
	const string& get_loc_name(const location_ref& loc) const;
	location_ref get_or_add_location_ref(const string& s);
	
  void var_names_assign(const variable_id_map& vn_vec);
  //void var_names_assign(const variable_id_map vn_vec);
  void loc_names_assign(const loc_names_map& l_names);
	
  void map_locations(const loc_names_map& l_names);
  void map_variables(const variable_id_map& v_names);
  
  clock_val_set add(const location_ref& loc, const clock_val_set& cvs); // assumes the location_ref already exists
  clock_val_set add(const string& loc_name, const location_ref& loc, const clock_val_set& cvs); // checks whether loc_name and loc are consistent, adds otherwise
  clock_val_set add(const string& loc_name, const clock_val_set& cvs); // creates a new location_ref

  void remove_empty();

  void intersection_assign(const clock_val_set& cvs);

  void difference_assign(const symb_states_type& s, bool use_names=false);

	bool contains(const symb_states_type& s, bool use_names=false) const;
   
   bool is_intersecting(const string& loc_name, const clock_val_set& cvs) const; 
  
	void intersection_assign(const symb_states_type& s, bool use_names=false);

  bool is_empty() const;

  void add_space_dimensions_and_embed(dimension_type ndims);

  void remove_space_dimensions(const clock_ref_set& crs);

  void remove_space_dimensions(const dimension_type& x1, const dimension_type& x2);
	
	void project_to_vars(const clock_ref_set& crs);
	
	void rename_variable(const string& var1, const string& var2);

//  template<typename PartialFunction> void map_space_dimensions(const PartialFunction& pfunc);
  template<typename PartialFunction> void
  map_space_dimensions(const PartialFunction& pfunc)
  {
    for (symb_states_type::iterator i=begin();i != end(); ++i)
    {
      i->second.map_space_dimensions(pfunc);
    };
  }

	uint ccvs_size() const
  {
		uint count=0;
    for (symb_states_type::const_iterator i=begin();i != end(); ++i)
    {
      count+=i->second.size();
    };
		return count;
  }

	
  clock_val_set union_over_locations();

  clock_val_set intersection_over_locations();
  symb_states_type merge_splitted();

  void simplify();
  bool limit_constraints_or_bits(int n, int bits);
  
  void split(location_ref& loc,location_ref& new_loc,Constraint con);
  void split(location_ref& loc,location_ref& new_loc,clock_val_set& inv1, clock_val_set& inv2);

  void print_phaver(ostream& s) const;
  void print() const;
  void print(vector <string> loc_names) const;
  void print_gen_fp_raw(ostream& s) const;
  void save_gen_fp_raw(string filename) const;
  void print_con_fp_raw(ostream& s) const;

  bool var_names_uptodate;
  variable_id_map var_names;
	loc_names_map loc_names; 
};



#endif
