/***************************************************************************
 *   Copyright (C) 2004 by Goran Frehse                                    *
 *   gfrehse@localhost                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

 
#ifndef GUARD_transition_h
#define GUARD_transition_h

#include <stdio.h>
#include <iostream>
#include <vector>
#include <list>
#include <set>
#include <map>
#include <algorithm>
#include <stdexcept>

//#include "parameters.h"
#include "general.h"
#include "clock_val_set.h"
#include "symb_states.h"
#include "stopwatch.h"

#include "probabilistic_alternative.h"


using namespace Parma_Polyhedra_Library;
using namespace Parma_Polyhedra_Library::IO_Operators;
using namespace std;

extern int MEMORY_MODE;



class transition
{
  public:
  transition() : exit_set_uptodate(false), entry_set_uptodate(false), mu_uptodate(false), mu_source_uptodate(false), mu_target_uptodate(false), is_separable(false), myis_ident(false), myis_urgent(false) {};

  transition(const location_ref& sl, const label_ref& a, const clock_val_set& mu, const location_ref& tl) : exit_set_uptodate(false), entry_set_uptodate(false), mu_uptodate(false), mu_source_uptodate(false), mu_target_uptodate(false), is_separable(false), myis_ident(false), myis_urgent(false),mymu(mu),mysource_loc(sl),mytarget_loc(tl),label(a) {};

  int get_memory() const;
    
	clock_val_set exit_set(const clock_val_set& s_inv, const clock_val_set& t_inv) const;
  clock_val_set entry_set(const clock_val_set& s_inv, const clock_val_set& t_inv) const;
  const clock_val_set& unrestricted_mu() const; 
	clock_val_set mu(const clock_val_set& s_inv, const clock_val_set& t_inv) const;
	void mu_update_source(const clock_val_set& s_inv) const;
	void mu_update_target(const clock_val_set& t_inv) const;
	location_ref source_loc() const { return mysource_loc; };
	location_ref target_loc() const { return mytarget_loc; };
	void check_ident();
  
  void mu_assign(const clock_val_set& m)
  { mymu = m; assume_mu_modification();};
  
  void mu_intersection_assign(const clock_val_set& m)
  { mymu.intersection_assign(m); assume_mu_modification();};
  
  void mu_simplify()
  { mymu.simplify(); };
  
  void source_assign(location_ref loc)
  { mysource_loc=loc; 
    assume_source_modification(); };
  
  void target_assign(location_ref loc)
  { mytarget_loc=loc; 
    assume_target_modification(); };
  
  // Manipulation Methods
  void assume_source_modification()
  { exit_set_uptodate=false; mu_source_uptodate=false; mu_uptodate=false;};  
  
  void assume_target_modification()
  { entry_set_uptodate=false; mu_target_uptodate=false; mu_uptodate=false;}; 
  
  void assume_mu_modification()
  { exit_set_uptodate=false; entry_set_uptodate=false; mu_uptodate=false; mu_source_uptodate=false; mu_target_uptodate=false; check_ident(); };     
  
  void add_space_dimensions_and_embed(dimension_type ndims);
  void map_space_dimensions(PFunction pfunc);
  void reverse();
	
	bool is_ident() const {return myis_ident;};
   
   bool is_urgent() const { return myis_urgent; };
   void set_urgent(bool nv=true) { myis_urgent=nv; };
   void set_pre_post_string(const string& pre,const string& post) {pre_string=pre; post_string=post;};
   const string& get_pre_string() {return pre_string;};
   const string& get_post_string() {return pre_string;};
	
	void clear();

  
	
  // Properties
	label_ref label;
	distribution_ref distribution;
	unsigned int distribution_entry;

  private:
  // for analysis
  clock_val_set mymu;
  clock_val_set myexit_set;
  clock_val_set myentry_set;
  location_ref mysource_loc;
  location_ref mytarget_loc;
  bool exit_set_uptodate;
  bool entry_set_uptodate;
	bool mu_uptodate;
	bool mu_source_uptodate;
	bool mu_target_uptodate;
	bool is_separable;
	bool myis_ident;
   bool myis_urgent;
   string pre_string,post_string;
};


#endif
