/***************************************************************************
 *   Copyright (C) 2004 by Goran Frehse                                    *
 *   gfrehse@localhost                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef GUARD_variable_time_elapse_func_h
#define GUARD_variable_time_elapse_func_h

#include <stdio.h>
#include <iostream>
#include <vector>
#include <list>
#include <set>
#include <map>
#include <algorithm>
#include <stdexcept>

//#include "parameters.h"
#include "general.h"
#include "clock_val_set.h"
#include "stopwatch.h"
#include "tnt.h"

extern int  REFINE_DERIVATIVE_METHOD;
extern int CONSTRAINT_BITSIZE;

class variable_time_elapse_func
{
	public:
	virtual ~variable_time_elapse_func() {};
	
	virtual convex_clock_val_set time_post(const clock_val_set& inv) 
	{ return static_tp; };
	
	virtual void static_time_post_poly_assign(const convex_clock_val_set& tp)
	{
		static_tp=tp;
	};	
	
	virtual void static_time_post_poly_intersection_assign(const convex_clock_val_set& tp)
	{
		static_tp.intersection_assign(tp);
	};
	
  virtual void add_space_dimensions_and_embed(dimension_type ndims)
	{
		static_tp.add_space_dimensions_and_embed(ndims);
	};

/*	template<typename PartialFunction> void map_space_dimensions(const PartialFunction& pfunc)
	{
		static_tp.map_space_dimensions(pfunc);
	};*/
	
	convex_clock_val_set static_tp;
};


class linear_vtef : public variable_time_elapse_func
{
	public:
	linear_vtef() {};
//	linear_vtef(const convex_clock_val_set& tp, dimension_type dim);
	linear_vtef(const Constraint_List& tp, dimension_type dim);

	//virtual ~linear_vtef() {};
		
	void intersection_assign(const linear_vtef& lv);
	
// 	convex_clock_val_set vtef_at_generator(const Generator g);
	
	convex_clock_val_set time_post(const clock_val_set& inv) const;
	
	void static_time_post_poly_assign(const convex_clock_val_set& tp)
	{
		static_tp=tp;
	};	
	
	void static_time_post_poly_intersection_assign(const convex_clock_val_set& tp)
	{
		static_tp.intersection_assign(tp);
	};
	
  	void add_space_dimensions_and_embed(dimension_type ndims);

	void map_space_dimensions(PFunction pfunc);
	
	void reverse()
	{
		// reverse time
		static_tp.pointmirror_assign();
		mytp.reverse_first_half();
	}
	
	void print() const;

	Constraint_List get_mytp() const
	{
		return mytp;
	}	
	
	void get_linear_system_matrices(TNT::Array2D<Integer>& A, TNT::Array1D<Integer>& b, TNT::Array1D<Integer>& den) const;

   int get_memory() const;
   
	private:
	dimension_type mydim;
	clock_ref_set vars;
	Constraint_List mytp; // consists of [ vars , quantifiable-vars ], i.e., is of dimension 2*mydim
};

void variable_time_elapse_func_dummfunc();

#endif


