#include "automaton.h"

void automaton::add_transitions_from_distribution(string source_name, string label_name, clock_val_set guard, const list<prob_alt> &palist)
{
	unsigned int dist_index = distributions.size();
	unsigned int entry = 0;
	distribution distr(palist.size());
	
	weight_t weights_sum(0);
	for(list<prob_alt>::const_iterator i = palist.begin(); i != palist.end(); ++i)
	{
		weights_sum += i->weight;
	}
	
	for(list<prob_alt>::const_iterator i = palist.begin(); i != palist.end(); ++i)
	{
		distr[entry] = i->weight/(double)weights_sum;
		add_transition(source_name, label_name, guard, i->mudest, i->target, dist_index, entry);
		entry++;
	}
	
	distributions.push_back(distr);
}

void automaton::add_distribution(const distribution& distr)
{
	distributions.push_back(distr);
}

bool operator==(const distribution_info& di1, const distribution_info& di2)
{
	return di1.distribution == di2.distribution && di1.distribution_entry == di2.distribution_entry;
}
