/***************************************************************************
                          convex_clock_val_set.cpp  -  description
                             -------------------
    begin                : Thu Nov 21 2002
    copyright            : (C) 2002 by Goran Frehse
    email                : goran@s.cs.auc.dk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//#include <stdio.h>
//#include <iostream>
//#include <vector>
//#include <list>
//#include <set>
//#include <algorithm>
//#include <stdexcept>
//
//
//#include <ppl.hh>
#include "convex_clock_val_set.h"

namespace PPL = Parma_Polyhedra_Library;
using namespace Parma_Polyhedra_Library;
using namespace std;
using namespace Parma_Polyhedra_Library::IO_Operators;

std::ostream&
operator<<( std::ostream& os, const loc_ref_set &c )
    {
      os << "[";
      for (loc_ref_set::const_iterator j=c.begin();j!=c.end();++j)
      {
        if (j!=c.begin())
          os << "," << *j;
        else
          os << *j;
      };
      os << "]";
      return os;
    }

std::ostream&
operator<<( std::ostream& os, const trans_ref_set &c )
    {
      os << "[";
      for (trans_ref_set::const_iterator j=c.begin();j!=c.end();++j)
      {
        if (j!=c.begin())
          os << "," << *j;
        else
          os << *j;
      };
      os << "]";
      return os;
    }
    
  int 
  convex_clock_val_set::get_memory() const
  {
    int res=0;
      res+=total_memory_in_bytes();
    return res;
  }    

Rational convex_clock_val_set::get_diameter()
	{
		convex_clock_val_set ccvs(space_dimension(),UNIVERSE);
		shrink_bounding_box(ccvs);
		
		// for each variable, find max and min
		Integer v_max_n,v_max_d,v_min_n,v_min_d;
		Rational v_max,v_min;		
		Rational v;
		Rational d_max(0);

		bool first;
    list<convex_clock_val_set>::iterator it;
		Constraint_System cs;

		for (dimension_type i=0;i<space_dimension();++i)
		{
			// Find min and max for variable i
			first=true;
				cs=constraints();
				for (Constraint_System::const_iterator j=cs.begin();j!=cs.end();++j)
				{
					// assume they are rectangulaer constraints
					// (which they should be, since these are bounding boxes)
					if (j->coefficient(Variable(i))!=0)
					{
						v=Rational(-j->inhomogeneous_term(),j->coefficient(Variable(i)));
						if (first || v<v_min)
							v_min=v;
						if (first || v>v_max)
							v_max=v;
						if (first)
							first=false;
					};
				};
			v=v_max-v_min;
			if (v>d_max)
				d_max=v;
		};
		return d_max;
	};

  bool
  trans_ref_set::contains(const transition_ref& tr) const
  {
		return find(tr)!=end();
  }

	
  bool
  trans_ref_set::contains(const trans_ref_set& set) const
  {
    trans_ref_set::const_iterator i;
    for (i=set.begin();i!=set.end();++i)
    {
      if (!contains(*i)) return false;
    };
    return true;
  }
	
  transition_ref
  trans_ref_set::non_contained_element(const trans_ref_set& set) const
  {
    trans_ref_set::const_iterator i;
    for (i=set.begin();i!=set.end();++i)
    {
      if (!contains(*i)) return (*i);
    };
		throw_error("in non_contained_element, there was no such element");
    return transition_ref();
  }
		
	  
// 	void
//   trans_ref_set::erase(transition_ref tr)
//   {
// //cout << "Erasing " << tr << " out of " << *this << endl << flush;
// 
//     trans_ref_set::iterator i;
//     i=begin();
//     while (i!=end())
//     {
//       if (*i==tr)
//       {
//         set<transition_ref>::erase(i);
//         i=begin();
//       }
//       else
//         ++i;
//     };
// 		
// //cout << "Result:" << *this << endl << flush;
//   };

  void
  trans_ref_set::decrease_refs(transition_ref tr)
  {
    // decrease those refs >tr
    // Note: If both tr and tr+1 are in *this, only tr remains
    trans_ref_set s;
    for (trans_ref_set::iterator i=this->set<transition_ref>::begin(); i!=this->set<transition_ref>::end(); ++i)
    {
//cout << (*i) << " vs " << tr << " bef :" << s << endl;
      if ((*i)>tr)
        s.insert(((int)(*i))-1);
      else
        s.insert(((int)(*i)));
//cout << (*i) << " vs " << tr << " aft :" << s << endl;
    };
    *this=s;
  }

  void
  trans_ref_set::union_assign(const trans_ref_set& cset)
  {
    insert(cset.begin(),cset.end());
  }

	



  ostream&
operator<<( ostream& os, const label_ref_set &labs )
    {
      os << "[";
      for (clock_ref_set::const_iterator j=labs.begin();j!=labs.end();++j)
      {
        if (j!=labs.begin())
          os << "," << *j;
        else
          os << *j;
      };      
      os << "]";
      return os;
    }

  bool
  label_ref_set::contains(const label_ref& lab) const
  {
    bool cont=false;

    label_ref_set::const_iterator i;
    for (i=begin();i!=end();++i)
    {
      if ((*i)==lab) cont=true;
    };
    return cont;
  }
  
  bool
  label_ref_set::contains(const label_ref_set& set) const
  {
    bool cont=true;

    label_ref_set::const_iterator i;
    for (i=set.begin();i!=set.end();++i)
    {
      if (!contains(*i)) cont=false;
    };
    return cont;
  }
  
  void
  label_ref_set::difference_assign(const label_ref_set& lab)
  {
    label_ref_set::iterator i=begin();
    while (i!=end())
    {
      if (lab.contains(*i))
//        i=erase(i);
      {
        erase(i);
        i=begin();
      }
      else
         ++i;
    };
  }
  
  void
  label_ref_set::difference_assign(const label_ref& lab)
  {
    label_ref_set::iterator i=begin();
    while (i!=end())
    {
      if (lab==(*i))
//        i=erase(i);
      {
        erase(i);
        i=begin();
      }
      else
         ++i;
    };
  }
  
  void
  label_ref_set::union_assign(const label_ref_set& lab)
  {
    insert(lab.begin(),lab.end());
  }
  
  void
  label_ref_set::union_assign(const label_ref& lab)
  {
    insert(lab);
  }

  void
  label_ref_set::intersection_assign(const label_ref_set& lab)
  {
    label_ref_set::iterator i=begin();
    while (i!=end())
    {
      if (!lab.contains(*i))
//        i=erase(i);
      {
        erase(i);
        i=begin();
      }
      else
         ++i;
    };
  }


label_ref_set empty_label_ref_set()
 {
   label_ref_set iamempty;
   return iamempty;
 }






  convex_clock_val_set::convex_clock_val_set() {}
  convex_clock_val_set::convex_clock_val_set(size_t d) : NNC_Polyhedron(d) {}
  convex_clock_val_set::convex_clock_val_set(size_t d, Degenerate_Element kind) : NNC_Polyhedron(d,kind) {}
  convex_clock_val_set::convex_clock_val_set(const Constraint& con) : NNC_Polyhedron(con.space_dimension()) 
	{
		add_constraint(con);
	}
		
  convex_clock_val_set::convex_clock_val_set(const Constraint_System& con) : NNC_Polyhedron(con) {}
  convex_clock_val_set::convex_clock_val_set(const Generator_System& gen) : NNC_Polyhedron(gen) {}
  
	convex_clock_val_set::convex_clock_val_set(const Constraint_List& cl, size_t d) : NNC_Polyhedron(d)
	{
		for (Constraint_List::const_iterator i=cl.begin();i!=cl.end();++i)
		{
			add_constraint(*i);
		};
	}
	
	size_t
	convex_clock_val_set::get_real_dimension() const
	{
		// The real dimension is equal to dim - # of equality constraints
		// Note: This assumes that the Constraint_System is in canonic form, i.e.,
		// no linearly dependendent equalities, no implicit equalities.
		// This is (supposed to be) the case for minimzed_constraints()
		int count=space_dimension();

//cout << *this << ":";				
		Constraint_System cs=minimized_constraints();
		for (Constraint_System::const_iterator i=cs.begin();i!=cs.end();++i)
		{
			if (i->is_equality())
				--count;
		};
		
//cout << count << endl;

		if (count>0)
			return count;
		else
			return 0;
	}
	
	void
	convex_clock_val_set::swap(convex_clock_val_set& ccvs) 
	{
		NNC_Polyhedron::swap(ccvs); 
	}
  
	void 
  convex_clock_val_set::get_and_add_generators(Generator_List& l) const
  {
    Generator_System gs;
    gs=minimized_generators();
//    for (Generator_System::const_iterator i=generators().begin();i!=generators().end();++i)
    for (Generator_System::const_iterator i=gs.begin();i!=gs.end();++i)
    {
      l.push_back(*i);
    };
  }

  // ----------------------------------------
  // Methods for modifying dimensions
  
  void
  convex_clock_val_set::remove_space_dimensions( const clock_ref_set& to_be_removed)
  {
    Variables_Set vs;
    for (clock_ref_set::const_iterator i=to_be_removed.begin(); i!= to_be_removed.end(); ++i)
    {
      vs.insert(Variable(*i));
    };
    NNC_Polyhedron::remove_space_dimensions(vs);
  }

  void
  convex_clock_val_set::dimension_swap_assign(dimension_type x1, dimension_type x2, dimension_type y)
  {
    PFunction pfunc;
    pfunc.swap_assign(x1,x2,y,space_dimension());
    map_space_dimensions(pfunc);
  }

  void
  convex_clock_val_set::dimension_move_assign(dimension_type x1, dimension_type x2, dimension_type y)
  {
    PFunction pfunc;
    pfunc.move_assign(x1,x2,y,space_dimension());
    map_space_dimensions(pfunc);
  }

  // ----------------------------------------
  //
  void
  convex_clock_val_set::clock_free(const clock_ref_set& r)
  {
    if (!r.empty())
    {
//cout << "Before free: ";
//print_constraints(*this);
//    cout << " reset vars:";
    // to do: make sure at initialization that all cost functions always have full space dimensions
    //        until then: fix this "on the fly"
    //
    for (clock_ref_set::const_iterator i=r.begin(); i!=r.end();i++)
      {
        affine_preimage(Variable(*i),Linear_Expression(0));
      };
//cout << "After free: ";
//print_constraints(*this);
    };
  }
  
  void
  convex_clock_val_set::clock_reset(const clock_ref_set& r)
  {
    for (clock_ref_set::const_iterator i=r.begin(); i!=r.end();i++)
      {
        affine_image(Variable(*i),Linear_Expression(0));
      };
  }

  void
  convex_clock_val_set::pointmirror_assign()
  {
    Linear_Expression lexp;
    // maps all points componentwise by x'=-x
    for (unsigned int i=0; i<space_dimension(); ++i)
    {
      lexp=-Variable(i);
      affine_image(Variable(i),lexp);
    };
  }

  void
  convex_clock_val_set::clock_interval_assign(const Variable& var, const Integer& lower, const Integer& upper)
  {
    add_constraint(var >= lower);
    add_constraint(var <= upper);
  }
	
	void 
	convex_clock_val_set::set_empty()
	{
    convex_clock_val_set newcvs(space_dimension(),EMPTY); // create an empty cvs
		*this=newcvs;
	}
	
	void
//	convex_clock_val_set::raise_lower_bound(dimension_type k, bool closed, const Integer& n, const Integer& d)
	convex_clock_val_set::raise_lower_bound(dimension_type k, bool closed, Integer n, Integer d)
	{
		limit_bitsize(n,d,false,BOUND_BOX_BITSIZE);
		
		if (closed)
			add_constraint(0*Variable(space_dimension()-1)+d*Variable(k) >= n);
		else
			add_constraint(0*Variable(space_dimension()-1)+d*Variable(k) > n);
	}
			
	void									
//  convex_clock_val_set::lower_upper_bound(dimension_type k, bool closed, const Integer& n, const Integer& d)
  convex_clock_val_set::lower_upper_bound(dimension_type k, bool closed, Integer n, Integer d)
	{
		limit_bitsize(n,d,true,BOUND_BOX_BITSIZE);
		
		if (closed)
			add_constraint(0*Variable(space_dimension()-1)+d*Variable(k) <= n);
		else
			add_constraint(0*Variable(space_dimension()-1)+d*Variable(k) < n);
	}
	
	bool
	convex_clock_val_set::limit_significant_bits(int bits)
	{
		// limit the number of significant bits in the constraints
		// making up *this, while ensuring that the new ccvs contains *this,
		// i.e., it is a conservative over-approximation
		
		bool changed=false;
		int maxb=max_bit_size();
		
//cout << " max_bit_size() before " << max_bit_size() << endl;		
		if (!is_empty() && bits>0 && maxb>bits)
		{
		
//cout << " changing " << endl;		
			changed=true;
			convex_clock_val_set ccvs(space_dimension());
			// minimize constraints
			minimized_constraints();
			
			// Constraint_List CL=Constraint_System_convert_equalities(minimized_constraints()); 
			// don't change equalitites
//cout << "before: "<< *this << endl;			
			Constraint c(Constraint::zero_dim_false()); // dummy initialization
//			for (Constraint_List::const_iterator i=CL.begin();i!=CL.end();++i)
			for (Constraint_System::const_iterator i=constraints().begin(); i!=constraints().end(); ++i)
			{
				if (i->is_inequality())
				{
					c=*i;
//cout << "before: "<< c << endl;			
					limit_bitsize(c,*this,true,bits);
					ccvs.add_constraint(c);
//cout << "after: " <<c << endl;
				}
				else
				{
					ccvs.add_constraint(*i);
				};
			};
//cout << " ch max_bit_size() " << ccvs.max_bit_size() << endl;		
//cout << "after: ccvs " << ccvs << endl;			
			swap(ccvs);
//			*this=ccvs;
//cout << " new max_bit_size() " << max_bit_size() << endl;		
//			message(400000,"Reduced bits from " + int2string(maxb) + " to " + int2string(max_bit_size()));
		
		};
		
		return changed;
	}
	
	int
	convex_clock_val_set::max_bit_size() const
	{
		int m=0;
		int dum=0;
minimized_constraints();		
		for (Constraint_System::const_iterator i=constraints().begin();i!=constraints().end();++i)
		{
			dum=Constraint_max_bit_size(*i);
			if (dum>m)
				m=dum;
		};
			
		return m;
	}
	
	double_criterion 
	convex_clock_val_set::limit_constraints_criterion(const Generator_List& gl, const Constraint& c) const
	{
		double_criterion crit;
		convex_clock_val_set ccvs(*this);
		
		// Get Generators on the constraint
		//Generator_List cgl;
		double_point_list pl;
		double_point p(space_dimension(),0.0);
		
		for (Generator_List::const_iterator i=gl.begin(); i!=gl.end(); ++i)
		{
			if (is_generator_on_constraint(*i,c))
			{
				generator_to_double_point(*i,p);
				pl.push_back(p);
			};
		};
		
		crit.push_back(-get_double_point_list_variance(pl)); // minus so large variance is sorted first

		return crit;
	}
	
	bool 
	convex_clock_val_set::limit_constraints_angle(int n, int bits)
	{
		// Parameter for angle comparison:
		const double angeps=0; //1e-6; // limit within which two angles are considered equal
	
    int old_size=constraint_size();	
		if (n>0 && constraint_size()>n)
		{
			stopwatch sw(710100,"limit_constraints");
		
			//Constraint_List cl; //=Constraint_System_no_equalities(constraints());
//			set<pair<double_criterion,Constraint>,double_criterion_constraint_comp >  constraint_cand;
//			list <pair<double_criterion,Constraint> > constraint_cand;
			multiset<pair<double_criterion,Constraint>,double_criterion_constraint_comp > constraint_cand;
			double_criterion crit;
			
			// just take the first n and add others until it is bounded
			convex_clock_val_set p(space_dimension(),UNIVERSE);
			
int old_bit_size=max_bit_size();			
	// for extent
	Integer min_n,min_d,max_n,max_d;
	double_point pnt(space_dimension(),0.0);
	double_point pnt2(space_dimension(),0.0);
	Rational rat(0);
	double ang=0;
	double dum=0;
	double max_ang=0;
	double all_ang=0;
			double_point_list dl,this_dl;
			
			int dumint=0;
			int all_ang_bit_size=0;
	
				
			int count=0;
			Generator_List gl;
			get_and_add_generators(gl);
			minimized_constraints();
			
			const int na=constraint_size();
			//double ang_array[na][na];
			//(double[])* pang_array=new double[na][na];
			TNT::Array2D<double> ang_array(na,na);
			//vector < vector <int> > ang_array;
			
			// the candidate list is now simply a list of integers that are used to index into the constraints and the double_point_list
			// add all the equalities
			
			set <int> chosen;
			set <int> candidates;
			int ni=0;
			int nj=0;
			Constraint_System::const_iterator con_it=constraints().begin();
						
			// turn this into a double_point_list
			ni=0;
			for (Constraint_System::const_iterator i=constraints().begin();i!=constraints().end();++i)
			{
//cout << "###"<<ni<<":" << *i << endl;
				constraint_to_double_point(*i,pnt,dum); // note: pnt is used later also
				this_dl.push_back(pnt.copy());
				
				// preserve equalities and octagonal constraints
				if (i->is_equality() || Constraint_is_carthesian(*i) || Constraint_is_octagonal(*i))
				{
					++count;
					p.add_constraint(*i);
					chosen.insert(ni);
				}
				else
				{
					candidates.insert(ni);
				};
				++ni;
			};
//cout << ":" << count << ",";
						
			// Get ang_array
			// Attention: it is of triangular form, i.e. if j<i use ang_array[j][i] instead of [i][j]
			ni=0;
			for (double_point_list::const_iterator i=this_dl.begin();i!=this_dl.end();++i)
			{
				dl.clear();
				dl.push_back(i->copy());
				nj=ni;
				for (double_point_list::const_iterator j=i;j!=this_dl.end();++j)
				{
					if (i!=j)
					{
						dl.push_front(j->copy());
						ang=get_double_point_list_angle(dl);
						ang_array[ni][nj]=ang;
						//(*pang_array)[ni][nj]=ang;
//cout << ang << ",";							
						dl.pop_front();
					}
					else
						ang_array[ni][nj]=0.0;
						//(*pang_array)[ni][nj]=0.0;
					++nj;
				};
				++ni;
			};
			
			set<int>::iterator i=candidates.begin();
			set<int>::iterator min_it=candidates.begin();
			while ((!candidates.empty()) && (count<n || (!p.is_bounded())))
			{
				min_it=candidates.begin();
				all_ang=1;
				for (i=candidates.begin();i!=candidates.end();++i)
				{
//cout << *i << ":";				
					max_ang=-1;
					for (set<int>::const_iterator j=chosen.begin();j!=chosen.end();++j)
					{
//cout << *j << ",";				
						if (*j>*i)
							ang=ang_array[*i][*j];
							//ang=(*pang_array)[*i][*j];
						else if (*i>*j)
							ang=ang_array[*j][*i];
							//ang=(*pang_array)[*j][*i];
						else
							throw_error("bug in limit_constraints_angle");
							
						if (ang>max_ang)
						{
							max_ang=ang;
//cout << ang << ",";			
						};
					};
					if (max_ang <= all_ang + angeps) // min of *i against any of p
					{
						if (max_ang >= all_ang -angeps) // in close cases, chose the one with less bits
						{
							con_it=constraints().begin();
							for (int ii=0; ii<*i; ++ii)
								++con_it;						
							dumint=Constraint_max_bit_size(*con_it);
							if (all_ang_bit_size==0) // not calculated yet
							{
								con_it=constraints().begin();
								for (int ii=0; ii<*min_it; ++ii)
									++con_it;						
								all_ang_bit_size=Constraint_max_bit_size(*con_it);
							};
							if (dumint<all_ang_bit_size)
							{
								min_it=i;
								all_ang=max_ang;
								all_ang_bit_size=dumint;
							};
						}
						else
						{
							min_it=i;
							all_ang=max_ang;
							all_ang_bit_size=0;
						};
//cout << all_ang << endl;					
					};
//cout << ":" << max_ang << endl;					
				};
//cout << *min_it << " all:" << all_ang << endl;					
				
				// now add min_it to p and erase it from cl;
				// get the iterator in the constraints from the int reference
				
				con_it=constraints().begin();
				for (int ii=0; ii<*min_it; ++ii)
					++con_it;
//cout << "==="<< *min_it <<":" << *con_it << endl;
				
				++count;
				if (bits>0)
				{
					Constraint c(*con_it); // dummy initialization
					limit_bitsize(c,*this,true,bits);
					p.add_constraint(c);
				}
				else
				{
					p.add_constraint(*con_it);
				};
//cout << count << "!" << p.is_bounded() << flush << endl;				

				chosen.insert(*min_it);
//				candidates.erase(min_it);
				candidates.erase(*min_it);
			};
			
			swap(p);
//			message(256000,"Reduced constraints from " + int2string(old_size) + " to " + int2string(count));
			message(300000,"Reduced from " + int2string(old_size) + " constraints, " + int2string(old_bit_size) + " bits to " + int2string(constraint_size()) + "(" + int2string(count) + ") and " + int2string(max_bit_size()) +" bits");
//cout << "Reduced constraints from " << old_size << " to " << count << " /" << n << endl;	
			
			return true;
		}
		else
			return limit_significant_bits(bits);
	}
	
/*	bool 
	convex_clock_val_set::limit_constraints_angle_old(int n, int bits)
	{
    int old_size=constraint_size();	
		if (n>0 && constraint_size()>n)
		{
			stopwatch sw(128100,"limit_constraints");
		
			//Constraint_List cl; //=Constraint_System_no_equalities(constraints());
//			set<pair<double_criterion,Constraint>,double_criterion_constraint_comp >  constraint_cand;
//			list <pair<double_criterion,Constraint> > constraint_cand;
			multiset<pair<double_criterion,Constraint>,double_criterion_constraint_comp > constraint_cand;
			double_criterion crit;
			
			// just take the first n and add others until it is bounded
			convex_clock_val_set p(space_dimension(),UNIVERSE);
			convex_clock_val_set q(space_dimension(),UNIVERSE);
			
	// for extent
	Integer min_n,min_d,max_n,max_d;
	double_point pnt(space_dimension(),0.0);
	double_point pnt2(space_dimension(),0.0);
  Rational rat(0);
	double ang=0;
	double dum=0;
	double min_ang=0;
	double all_ang=0;
					double_point_list dl;
	
				
			int count=0;
			Generator_List gl;
			get_and_add_generators(gl);
			minimized_constraints();
			
			// add all the equalities
			
			Constraint_List cl;
			
			for (Constraint_System::const_iterator i=constraints().begin();i!=constraints().end();++i)
			{
				if (i->is_equality())
				{
					++count;
					p.add_constraint(*i);
				}
				else
				{
					cl.push_back(*i);
				};
			};
			
			// todo: this could be done much faster with a matrix, in which all the angles are stored
			Constraint_List::iterator i=cl.begin();
			Constraint_List::iterator min_it=cl.begin();
			while (!cl.empty() && (count<n || !p.is_bounded()))
			{
				Constraint_List::iterator min_it=cl.begin();
				all_ang=1;
				for (i=cl.begin();i!=cl.end();++i)
				{
					// use the normed max extent of the polyhedron with the oposite of the constraint
					// get the polyhedron with complement(*i)
					dl.clear();
					constraint_to_double_point(*i,pnt,dum); // note: pnt is used later also
					dl.push_back(pnt);
					min_ang=-1;
					for (Constraint_System::const_iterator j=p.constraints().begin();j!=p.constraints().end();++j)
					{
						// get angle, must be >0
						constraint_to_double_point(*j,pnt2,dum); // note: pnt is used later also
						dl.push_front(pnt2);
						ang=get_double_point_list_angle(dl);
//cout << ang << ",";							
						dl.pop_front();
						if (ang>min_ang)
						{
							min_ang=ang;
//cout << ang << ",";			
						};
					};
					if (min_ang < all_ang) // min of *i against any of p
					{
						all_ang=min_ang;
						min_it=i;
//cout << all_ang << endl;					
					};
				};
//cout << all_ang << endl;					
				
				// now add min_it to p and erase it from cl;
				++count;
				if (bits>0)
				{
					Constraint c(*min_it); // dummy initialization
					limit_bitsize(c,*this,true,bits);
					p.add_constraint(c);
				}
				else
				{
					p.add_constraint(*min_it);
				};
//cout << count << "!" << p.is_bounded() << flush << endl;				
				
				cl.erase(min_it);
			};
			
			swap(p);
//			message(256000,"Reduced constraints from " + int2string(old_size) + " to " + int2string(count));
			message(256000,"Reduced constraints from " + int2string(old_size) + " to " + int2string(constraint_size()) + "(" + int2string(count) + ")");
//cout << "Reduced constraints from " << old_size << " to " << count << " /" << n << endl;	
			
			return true;
		}
		else
			return false;
	};
*/	
	bool 
	convex_clock_val_set::limit_constraints_maxdelta(int n, int bits)
	{
		// chose constraints based on largest delta if the constraint wasn't there.
		// very accurate, but very slow
		
    int old_size=constraint_size();	
		if (n>0 && constraint_size()>n)
		{
			stopwatch sw(801000,"limit_constraints");
		
			//Constraint_List cl; //=Constraint_System_no_equalities(constraints());
//			set<pair<double_criterion,Constraint>,double_criterion_constraint_comp >  constraint_cand;
//			list <pair<double_criterion,Constraint> > constraint_cand;
			multiset<pair<double_criterion,Constraint>,double_criterion_constraint_comp > constraint_cand;
			double_criterion crit;
			
			// just take the first n and add others until it is bounded
			convex_clock_val_set p(space_dimension(),UNIVERSE);
			convex_clock_val_set q(space_dimension(),UNIVERSE);
			
	// for extent
	Integer min_n,min_d,max_n,max_d;
	bool min_exists,max_exists,dummybool;
	Linear_Expression linexp;
	double delta;
	double_point pnt(space_dimension(),0.0);
	double_point pnt2(space_dimension(),0.0);
	Rational rat(0);
	double ang=0;
	double dum=0;
	double max_ang=0;
	
				
			int count=0;
			Generator_List gl;
			get_and_add_generators(gl);
			minimized_constraints();
			
			// add all the equalities
			for (Constraint_System::const_iterator i=constraints().begin();i!=constraints().end();++i)
			{
				if (i->is_equality())
				{
					++count;
					p.add_constraint(*i);
				}
				else
				{
//cout << "$";				
					crit.clear();
					//crit=limit_constraints_criterion(gl,*i);
					
					if (true)
{					
					// use the normed max extent of the polyhedron with the oposite of the constraint
					// get the polyhedron with complement(*i)
					q=convex_clock_val_set(space_dimension(),UNIVERSE);
					double_point_list dl;
					dl.clear();
					constraint_to_double_point(*i,pnt,dum); // note: pnt is used later also
					dl.push_back(pnt);
					max_ang=-1;
					for (Constraint_System::const_iterator j=constraints().begin();j!=constraints().end();++j)
					{
						if (i!=j)
						{
							// get angle, must be >0
							constraint_to_double_point(*j,pnt2,dum); // note: pnt is used later also
							dl.push_front(pnt2);
							ang=get_double_point_list_angle(dl);
//cout << ang << ",";							
							dl.pop_front();
							if (ang>0)
								q.add_constraint(*j);
						};
					};
					
					q.add_constraint(closed_inequality_complement(*i));
					
					// now get the extent of *i in q
					linexp=ConstraintHom2Linear_Expression(&(*i));
		// cout << "linexp = " << linexp << endl << flush;	
					delta=1.0e32; // default: extremely important, so large number
					min_exists=q.minimize(linexp,min_n,min_d,dummybool);
					if (min_exists)
					{
//						max_exists=q.maximize(linexp,max_n,max_d,dummybool);
					max_exists=true;
					max_n=-(i->inhomogeneous_term());
					max_d=1;
			//   - if both exist
						if (max_exists)
						{
			//     - delta=max-min (no abs needed?) 
							rat=Rational((max_n*min_d-min_n*max_d),(min_d*max_d));
							delta=rat.get_d();
							// norm delta
							hom_linexpression_to_double_point(linexp,pnt);
							delta=delta/sqrt(norm2(pnt));
//cout << delta << ";" << endl;							
							crit.push_back(-delta);
						};
					};
					
};
//					constraint_cand.push_back(make_pair(crit,*i));
					constraint_cand.insert(make_pair(crit,*i));
				};
			};
//			constraint_cand.sort();
			
			multiset<pair<double_criterion,Constraint>,double_criterion_constraint_comp >::const_iterator i=constraint_cand.begin();
//			set<pair<double_criterion,Constraint>,double_criterion_constraint_comp >::const_iterator i=constraint_cand.begin();
//			list<pair<double_criterion,Constraint>  >::const_iterator i=constraint_cand.begin();
//cout << "size " << constraint_cand.size() << endl;
			while (i!=constraint_cand.end() && (count<n || !p.is_bounded()))
//			while (i!=constraint_cand.end() && (p.constraint_size()<n || !p.is_bounded()))
			{
//cout << "." << flush;				
//pause_key();
//cout << "B1a " << *(i->first.begin()) << ":" << i->second.space_dimension() << flush << "###" << i->second << endl << flush; // << *i << endl << flush;				
				++count;
				if (bits>0)
				{
					Constraint c(i->second); // dummy initialization
					limit_bitsize(c,*this,true,bits);
					p.add_constraint(c);
				}
				else
				{
					p.add_constraint(i->second);
				};
//cout << count << "!" << p.is_bounded() << flush << endl;				
				++i;
			};
			
			swap(p);
//			message(256000,"Reduced constraints from " + int2string(old_size) + " to " + int2string(count));
			message(801000,"Reduced constraints from " + int2string(old_size) + " to " + int2string(constraint_size()) + "(" + int2string(count) + ")");
//cout << "Reduced constraints from " << old_size << " to " << count << " /" << n << endl;	
			
			return true;
		}
		else
			return false;
	}
	
Constraint bounding_constraint(const Constraint& c, const convex_clock_val_set& ccvs)
{
	// return c'= c moved so that ccvs is contained in the points that fulfill c'
	
	if (c.space_dimension()>0)
	{
		Integer n(0);
		Integer d(1);
		bool dummy(false);
		Linear_Expression e(ConstraintHom2Linear_Expression(&c));
		bool notemptyandbounded=ccvs.minimize(e, n, d, dummy);
					
		if (notemptyandbounded)				
		{
			if (c.is_strict_inequality())
				return (d*e>n);
			else if (c.is_inequality())
				return (d*e>=n);
			else
				return (d*e==n);
			return c;
		};
		return (0*Variable(c.space_dimension()-1)==0); // return universe in proper dimension
	}
	else
		return (Linear_Expression(0)==0);
}

	void 
	convex_clock_val_set::constraint_hull_assign(const convex_clock_val_set& ccvs)
	{
		// join *this and ccvs by keeping the constraints that contain both, i.e.,
		// the constraints of *this that contain ccvs and the constraints of ccvs that contain *this
				
		convex_clock_val_set r(space_dimension()); // create a universe of same dimension
		
// cout << *this << endl;
// cout << ccvs << endl;

		// convert equalities to inequalities
		Constraint_List cl=Constraint_System_convert_equalities(minimized_constraints());
		
		// add the constraints of *this that contain ccvs
		for (Constraint_List::const_iterator i=cl.begin();i!=cl.end();++i)
		{
//			if (ccvs.relation_with(*i)==Poly_Con_Relation::is_included() || ccvs.relation_with(*i)==Poly_Con_Relation::saturates() )
			if (convex_clock_val_set(*i).contains(ccvs))
				r.add_constraint_and_minimize(*i);
			else
				r.add_constraint_and_minimize(bounding_constraint(*i,ccvs));
		};
		
		cl=Constraint_System_convert_equalities(ccvs.minimized_constraints());
		// add the constraints of ccvs that contain *this
		for (Constraint_List::const_iterator i=cl.begin();i!=cl.end();++i)
		{
//			if (relation_with(*i)==Poly_Con_Relation::is_included() || relation_with(*i)==Poly_Con_Relation::saturates() )
			if (convex_clock_val_set(*i).contains(*this))
				r.add_constraint_and_minimize(*i);
			else
				r.add_constraint_and_minimize(bounding_constraint(*i,*this));
		};
		
/*cout << "---------------------------------" << endl;
cout << r << endl << endl;		*/
	
/*	if (!r.is_bounded())
	{
		// if it didn't work out, use the convex hull instead
		poly_hull_assign_and_minimize(ccvs);
	}
	else*/
		swap(r); // replace *this with r
 	}	

	bool 
	convex_clock_val_set::limit_constraints(int n, int bits)
	{
		if (LIMIT_CONSTRAINTS_METHOD==0)
			return limit_constraints_maxdelta(n,bits);
		else
			return limit_constraints_angle(n,bits);

// 	  bool changed=false;
// 	  bool changed_now=false;
// 		
// 		changed_now = limit_constraints_angle((int)(1.5*(double)n),0);
// 		changed = changed || changed_now;
// 		changed_now = limit_constraints_maxdelta(n,bits);
// 		changed = changed || changed_now;

// 		return changed;
	}
			
	int
	convex_clock_val_set::constraint_size() const
	{
minimized_constraints();	
		int m=0;
		for (Constraint_System::const_iterator i=constraints().begin();i!=constraints().end();++i)
			++m;
			
		//return constraints().size();
		return m;
	}
   
void    
convex_clock_val_set::minimize_memory()
{
   NNC_Polyhedron p(minimized_constraints());
   NNC_Polyhedron::swap(p);
//   *this=convex_clock_val_set(minimized_constraints());
}
  
  void
  convex_clock_val_set::print() const
  {
//    print_constraints(*this);
    cout << *this;
    cout << endl;
  }

void print_constraints(const convex_clock_val_set& ccvs)
{
  cout << ccvs << endl;
}

void
convex_clock_val_set::print(const variable_id_map& vnvec) const
{
  Constraint_System cs;
  cs=minimized_constraints();
  Constraint_System::const_iterator i;
  for (i = cs.begin(); i != cs.end(); i++)
  {
    if (i != cs.begin())
      cout << ", ";
    print_constraint(cout,*i,vnvec);
  };
}

void
convex_clock_val_set::print_phaver(ostream& s, const variable_id_map& vnvec) const
{
//   if (this->is_universe())
//     s << "true";
//     
// /*  if (this->is_empty())
//     s << "false";*/
//   
//   Constraint_System cs;
//   cs=minimized_constraints();
//   Constraint_System::const_iterator i;
//   for (i = cs.begin(); i != cs.end(); i++)
//   {
//     if (i != cs.begin())
//       s << " & ";
//     print_constraint(s,*i,vnvec);
//   };
  convex_clock_val_set_to_Constraint_List(*this).print_phaver(s,vnvec);
}

void
convex_clock_val_set::print_gen_fp_raw(ostream& s) const
{
	double_point_list pl;
	add_ccvs_to_double_point_list(*this,pl);
	print_fp_raw(s,pl);
  s << endl;  // blank line after ccvs  
}

void
convex_clock_val_set::print_con_fp_raw(ostream& s) const
{
	double_point_list pl;
	add_ccvs_consys_to_double_point_list(*this,pl);
	print_fp_raw(s,pl);
  s << endl;  // blank line after ccvs  
}

void add_ccvs_to_double_point_list(const convex_clock_val_set& ccvs,double_point_list& pl)
{
  // add the vertices of ccvs to pl
  // ATTENTION: pl is not cleared, points will be added!
  
 Generator_List gen_list;
 ccvs.get_and_add_generators(gen_list);
//for (Generator_List::const_iterator i=gen_list.begin();i!=gen_list.end();++i) cout << *i <<";"; 
 add_Generator_List_to_double_point_list(gen_list,pl);
}

void double_point_list_to_ccvs(double_point_list& pl, convex_clock_val_set& ccvs, uint dim)
{
  // set ccvs to the convex hull of the points in pl
  
  ccvs=convex_clock_val_set(dim,EMPTY);
  Generator g=point(0*Variable(0),1); // dummy
  double_point p(dim);
  
  for (double_point_list::iterator i=pl.begin();i!=pl.end();++i)
  {
    double_point_to_generator(*i,g);
    ccvs.add_generator(g);
  };
}

void add_ccvs_consys_to_double_point_list(const convex_clock_val_set& ccvs,double_point_list& pl)
{
  // add the Constraints of ccvs to pl
  // ATTENTION: pl is not cleared, points will be added!
  // the points are of the form [a_1 ... a_n b]
  double_point dx_zero(ccvs.space_dimension()+1,0.0);	

	Constraint_System cs=ccvs.minimized_constraints();
	double_point dx(ccvs.space_dimension()+1);
	
	for (Constraint_System::const_iterator i=cs.begin();i!=cs.end();++i)
	{
		constraint_to_double_point(*i, dx);
		pl.push_back(dx.copy());
	  if (i->is_equality())
	    {
	      // also add complement
	      pl.push_back((dx_zero-dx).copy());
	    };
	};
}

int trim_to_bits(Integer& d, int bits, bool pos)
{
//cout << "Trimming " << d << " to " << bits << "bits pos(" << pos << "):" << flush;
//cout << d.get_mpz_t() << "," << mpz_sizeinbase(d.get_mpz_t(),2) << endl;
	int ed=0;
	if (bits>=2)
	{
		while ((int)mpz_sizeinbase(d.get_mpz_t(),2)>bits)
		{
			if ((d%2)!=0)
				if (pos)
					d+=1;
				else
					d-=1;
			d/=2;
			ed+=1;
//cout << d.get_mpz_t() << "," << mpz_sizeinbase(d.get_mpz_t(),2) << endl;
		};
	};
//cout << d << "*2^" << ed << "." << endl;	
	return ed;
}

void add_bits(Integer& d, int bits)
{
//cout << "Adding " << bits << " bits to " << d << ":" << flush;
	if (bits>0)
		mpz_mul_2exp(d.get_mpz_t(),d.get_mpz_t(),bits);
//cout << d << endl << flush;
}

void limit_bitsize(Integer& n, Integer& d, bool pos, int bits)
{
//BOUND_BOX_BITSIZE=16;
	// limit d to bits number of bits.
	// This is conservative in that n'/d' >= n/d if pos==true
	if (bits>0) // 
	{
		int en=0;
		int ed=0;
		
		Integer oldn(n);
		Integer oldd(d);
		
		bool neg=false;
		
		if (d<0)
		{
			d=-d;
			n=-n;
			neg=true;
		};
		bool ispos=(n>=0);
		
		en=trim_to_bits(n,bits,pos);
		ed=trim_to_bits(d,bits,(ispos && !pos) || (!ispos && pos));
		
		// cancel numerator and denominator
		if (en>ed)
		{
			en=en-ed;
			ed=0;
		}
		else
		{
			ed=ed-en;
			en=0;
		};
		
		// add the remaining bits again
		add_bits(n,en);
		add_bits(d,ed);
	
		if (neg)
		{
			d=-d;
			n=-n;
		};
		
		// Test
		if ((pos && (Rational(n,d) < Rational(oldn,oldd))) || (!pos && (Rational(n,d) > Rational(oldn,oldd))))
		{
			cout << oldn << "/"	<< oldd << " not " << pos << " cons. " << n << "/"	<< d << endl << flush;
			cout << Rational(oldn,oldd).get_d() << " vs. " << Rational(n,d).get_d() << endl << flush;
			pause_key();
		};
	};
}

void limit_bitsize(Integer& n, int bits)
{
	// Limit the bitsize of n, round towards zero
	bool pos=(n<0);
	Integer d=1;
	limit_bitsize(n,d,pos,bits);
}


void limit_bitsize(Linear_Expression& q, int bits)
{
	// Comment:
	// There's no direct access to the coefficients of c, therefore we'll have to rebuild it.
  Linear_Expression e;
	Integer a;
  for (int i = q.space_dimension() - 1; i >= 0; i--)
	{
		a=q.coefficient(Variable(i));
		limit_bitsize(a,bits);
    e += a * Variable(i);
	};
	
  a=q.inhomogeneous_term();
	limit_bitsize(a,bits);
  e += a;
	swap(e,q);
}

void limit_bitsize(Constraint& c, int bits)
{
	// Limit the significant bits in c to bits

	if (bits>0)
	{
	Linear_Expression e=Constraint2Linear_Expression(&c);
	limit_bitsize(e,bits);

	if (c.is_strict_inequality())
		c=(e>0);
	else if (c.is_inequality())
		c=(e>=0);
	else
		c=(e==0);
	};
}


bool limit_bitsize(Constraint& c, convex_clock_val_set& ccvs, bool pos, int bits)
{
	// Limit the bits in c such that cvs is inside c!
	// returns true if changed
	// (right now pos has no meaning)
	
 	if (bits>0 && !ccvs.is_empty() && c.space_dimension()>=1)
 	{
	  // get the initial scale
		Integer m(1); // m=2^(bits+1)-2
		mpz_mul_2exp(m.get_mpz_t(),m.get_mpz_t(),bits);  // note: we use bits instead of bits+1 because otherwise the result is bits+1. Why??? to do!!!
		m-=2;
		// get max. coeff
		Integer c_max(0);
		get_max_coeff(c,c_max);
		
		if (mpz_sizeinbase(c_max.get_mpz_t(),2)>(uint)bits)
		{
			// 1/f=g=c_max/m + 1;
			// Integer g(c_max/m+1);
			Integer g(1);
			mpz_cdiv_q(g.get_mpz_t(),c_max.get_mpz_t(),m.get_mpz_t()); // divide and round towards +infty
			
			Linear_Expression e(0);
			Integer n(0);
			Integer d(0);
			Integer new_coeff(0);
			bool found_nonzero(false);
			bool dummy; // is not used
			bool notemptyandbounded=false;
			
			bool trying(true);
			while (trying)
			{
				// get new homogeneous coefficients by scaling
				e=Linear_Expression(0*Variable(c.space_dimension()-1));
				found_nonzero=false;
				for (int i=0;i<(int)c.space_dimension();++i)
				{
	//cout << "@" <<(c.coefficient(Variable(i))) << ":" << (m) << "=" << (c.coefficient(Variable(i))/m) << endl;
					new_coeff=(c.coefficient(Variable(i))/g);
					if (new_coeff != Integer(0))
						found_nonzero=true;
					e+=new_coeff*Variable(i);
				};
				if (!found_nonzero) // if all coefficients are zero, abort and keep the original constraint
					return false;
				// get new inhomogeneous coefficient by linear programming
				// minimize e to get a lower bound inside cvs
				notemptyandbounded=ccvs.minimize(e, n, d, dummy);
				
				if (notemptyandbounded)				
				{
					// get new inhom. coefficient by decreasing n/d
					// some security checks:
					if (d<=0) throw_error("limit_bitsize: denominator <= 0");
					// division with rounding towards -infty (fdiv)
					mpz_fdiv_q(n.get_mpz_t(),n.get_mpz_t(),d.get_mpz_t());
					
					// check if size is within the bounds
					if (abs(n)<=m)
					{
//	cout << "before :" << Constraint_max_bit_size(c) << ":" << c << endl;
						if (c.is_strict_inequality())
							c=(e>n);
						else if (c.is_inequality())
							c=(e>=n);
						else
							c=(e==n);
//	cout << "after :" << Constraint_max_bit_size(c) << ":" << c << endl;
						return true;
					}
					else // otherwise decrease the scaling factor f, i.e., increase g
					{
						g*=Integer(2);
//	cout << "increasing scaling divisor g to " << g << endl;				
					};
				}
				else
            {
					trying=false;
//cout << endl << "not bounded" << endl;               
            }
			};
			
			return false;
		};
	};
	
	return false;
}

// bool limit_bitsize(Constraint& c, convex_clock_val_set& ccvs, bool pos, int bits)
// {
// 	// Limit the bits in c such that cvs is inside c!
// 	// returns true if changed
// 	// (right now pos has no meaning)
// 
// 	if (!ccvs.is_empty())
// 	{
// 		// find bits that have to be cut
// 		int bitsize=0;
// 		int maxsize=0;
// 		int nowsize=0;
// 		for (int i=0;i<(int)c.space_dimension();++i)
// 		{
// 			bitsize=mpz_sizeinbase(c.coefficient(Variable(i)).get_mpz_t(),2);
// 			if (bitsize>maxsize)
// 			{
// 				maxsize = bitsize;
// 			};
// 		};
// 		
// 		int b_size=mpz_sizeinbase(c.inhomogeneous_term().get_mpz_t(),2);
// 		if (maxsize>bits || b_size>bits)
// 		{
// 			Integer n(0);
// 			Integer d(0);
// 			bool dummy; // is not used
// 			bool notemptyandbounded=false;
// 			Linear_Expression e;
// 			int coeff_size=bits-2; // start out with the whole bit range
// 			Integer m(1);
// 			nowsize=maxsize;
// 			Integer n_final(0);
// 			int add_bits=0;
// 		
// 			while (nowsize>coeff_size) // || b_size>bits)
// 			{
// //cout << coeff_size << "," << flush;			
// 				// decrease the bits of e
// 				if (nowsize>coeff_size)
// 				{
// 					// cut maxsize-bits by dividing by 2^delta
// 					// e.g. 4 bit number 1011 into 2 bit by 1011=11 / 2^2=4=100 = 2 = 10
// 					m=Integer(1);
// 					mpz_mul_2exp(m.get_mpz_t(),m.get_mpz_t(),maxsize-coeff_size);
// 				  e=Linear_Expression(0);
// 					for (int i=0;i<(int)c.space_dimension();++i)
// 					{
// //cout << "@" <<(c.coefficient(Variable(i))) << ":" << (m) << "=" << (c.coefficient(Variable(i))/m) << endl;
// 						e+=(c.coefficient(Variable(i))/m)*Variable(i);
// 					};
// 					nowsize=coeff_size;
// 				}
// //cout << e << endl << flush;
// 								
// 				// minimize e to get a lower bound inside cvs
// 				notemptyandbounded=ccvs.minimize(e, n, d, dummy);
// 				
// 				if (notemptyandbounded)				
// 				{
// //cout << ":" << n << "(" << mpz_sizeinbase(n.get_mpz_t(),2) << ")"<< "/" << d << "(" << mpz_sizeinbase(d.get_mpz_t(),2) << ")" << endl << flush;				
// 					if (d>Integer(1))
// 					{
// 						// try to increase the bitsize of the coefficients
// 						if (n>0)
// 							n_final=n/d;
// 						else
// 							n_final=n/d-1;
// 						add_bits=0;
// 						m=Integer(1);
// 						while (n_final*d<n && (int)mpz_sizeinbase(n_final.get_mpz_t(),2)<bits && nowsize+add_bits<coeff_size)
// 						{
// 							++add_bits;
// 							m=Integer(1);
// 							mpz_mul_2exp(m.get_mpz_t(),m.get_mpz_t(),add_bits);
// 							n_final=(m*n)/d;
// //cout << "!!!" << nowsize << "#" << add_bits << ":" << mpz_sizeinbase(n_final.get_mpz_t(),2);
// 						};
// if (n_final*d>n)
//  throw_error("Bug in limit_bitsize");
// 						n=n_final; // the next lowest integer is the solution
// 						if (add_bits>0)
// 							e=m*e;
// 						nowsize+=add_bits;
// 					};
// 					
// 					if ((int)mpz_sizeinbase(n.get_mpz_t(),2)>bits)
// 						--coeff_size;
// 					else
// 					{
// 						if (c.is_strict_inequality())
// 							c=(e>n);
// 						else if (c.is_inequality())
// 							c=(e>=n);
// 						else
// 							c=(e==n);
// 			//cout << "after :" << c << endl;
// 						return true;
// 					};
// 				} // if (notemptyandbounded)
// 				else
// 					return false;
// 			}; // while
// 		}; // if (maxsize>bits || ...
// 		return false;
// 	}
// 	else
// 		return false; // it's empty, so forget it
// }

/*
bool limit_bitsize(Constraint& c, convex_clock_val_set& ccvs, bool pos, int bits)
{
	// Limit the significant bits in c such that cvs is inside c!
	// (right now pos has no meaning)

	if (!ccvs.is_empty())
	{
		Linear_Expression e=ConstraintHom2Linear_Expression(&c);
		limit_bitsize(e,bits);
		
		// minimize e to get a lower bound inside cvs
		Integer n(0);
		Integer d(0);
		bool dummy; // is not used
		bool notemptyandbounded=false;
		notemptyandbounded=ccvs.minimize(e, n, d, dummy);
    //notemptyandbounded=ccvs.maximize(e, n, d, dummy);		
		
		if (notemptyandbounded)
		{
			// Bring to form
			//   a_i x_i + b >= 0
			// For now it's given as:
			//   a_i' x_i >= n/d
			// so the new form must be:
			//   d*a_i' x_i - n >= 0 if d>=0
			//   d*a_i' x_i - n <= 0 if d<0
			
			// Therefore: round bits of n/d to negative!
			limit_bitsize(n,d,false,bits);
	
	//cout << "before :" << c << endl;
			if (d>=Integer(0))
			{
				if (c.is_strict_inequality())
					c=(d*e>n);
				else if (c.is_inequality())
					c=(d*e>=n);
				else
					c=(d*e==n);
			}
			else
			{
				if (c.is_strict_inequality())
					c=(d*e<n);
				else if (c.is_inequality())
					c=(d*e<=n);
				else
					c=(d*e==n);
			};
	//cout << "after :" << c << endl;
		}; // otherwise just leave c alone
	
		return notemptyandbounded;
	}
	else
		return false; // it's empty, so forget it
};
*/

bool is_generator_on_constraint(const Generator& g, const Constraint& c)
{
  if (g.space_dimension()>0)
  {
	 Integer z(0);
   for (int i=0;i<(int)g.space_dimension();++i)
   {
     z+=g.coefficient(Variable(i))*c.coefficient(Variable(i));
   };
	 z+=g.divisor()*c.inhomogeneous_term();
	 return (z==0);
  }
	else
		return true;
}

Constraint_List convex_clock_val_set_to_Constraint_List(const convex_clock_val_set& ccvs) 
{
	Constraint_List cl; //(ccvs.space_dimension());
	Constraint_System c(ccvs.minimized_constraints());
	for (Constraint_System::const_iterator it=c.begin();it!=c.end();++it)
	{
		cl.push_back(*it);
	};
	return cl;
};


// ---------------------------------------------------------------

convex_clock_val_set get_cone(convex_clock_val_set& p)
{
   // Interpret constraints as rays in n+1 space
   // and return the result
   dimension_type dim=p.space_dimension();
   convex_clock_val_set ccvs(dim+1,Parma_Polyhedra_Library::EMPTY);   
   if (!p.is_bounded())
      throw_error("get_cone called with unbounded poly");
      
   if (dim>0)
   {
      // Add origin as point
      ccvs.add_generator(point(0*Variable(0)));
      
      Linear_Expression e;
      Constraint_System cs(p.minimized_constraints());
      for (Constraint_System::const_iterator it=cs.begin();it!=cs.end();++it)
      {
         e=0*Variable(dim);
         // for each constraint, add a ray 
         for (dimension_type i=0;i<dim;++i)
         {
            e+=it->coefficient(Variable(i))*Variable(i+1);
         }
         // add the inhomogeneous term as Variable(0)
         e+=it->inhomogeneous_term()*Variable(0);
         ccvs.add_generator(ray(e));
         // if it's an equality, add it twice
         if (it->is_equality())
            ccvs.add_generator(ray(-e));
      }
   }
   return ccvs;
}

convex_clock_val_set map_cone(convex_clock_val_set& p, TNT::Array2D<Integer>& A, TNT::Array1D<Integer>& b, TNT::Array1D<Integer>& den, Rational& lambda)
{
   // Map cone by replacing each constraint (c,c0) with (A^T*c+lambda*c, lambda*c0+b^T*c)
   
   dimension_type dim=p.space_dimension();
   convex_clock_val_set ccvs(dim);   
   
   if (!(dim==A.dim1()+1 && dim==A.dim2()+1 && dim==b.dim1()+1 && dim==den.dim1()+1))
      throw_error("map_cone: wrong dimensions");
   
   if (dim>0)
   {
      Linear_Expression e;
      Rational_Linear_Expression r,r0;
      // Get the mapped linear expressions
      vector< Rational_Linear_Expression > vle(dim);
      
      r0=0*Variable(dim-1)+lambda*Variable(0); // lambda*c0
      
      // Note: need to shift the variables up by one, since
      // the coefficients of A are over c1,...,cn, which correspond
      // to elements a[0],...,a[n-1], respectively
      // to variables v(1),...,v(n)
      for (dimension_type i=0;i+1<dim;++i)
      {
         r=Rational_Linear_Expression(0*Variable(dim-1))+Rational(lambda)*Rational_Linear_Expression(Variable(i+1));
         // get the ith column of A
         for (dimension_type j=0; j+1<dim;++j)
         {
            r+=(Rational(A[j][i],den[j]))*Rational_Linear_Expression(Variable(j+1));
         }
         vle[i+1]=r;
//cout << r << endl;
         // get new c0
         r0+=Rational(b[i],den[i])*Rational_Linear_Expression(Variable(i+1));
      }
//cout << r0 << endl;      
      
      // Rebuild constraints, substituting coefficients with vle
      Constraint_System cs(p.minimized_constraints());
      for (Constraint_System::const_iterator it=cs.begin();it!=cs.end();++it)
      {
         r=0*Variable(dim-1)+it->inhomogeneous_term(); // inhomogeneous term remains unchanged
         // reconstruct each constraint, replacing each original coefficient with the map 
         for (dimension_type i=1;i<dim;++i)
         {
            r+=((Rational)it->coefficient(Variable(i)))*vle[i];
         }
         // add Variable(0)
         r+=((Rational)it->coefficient(Variable(0)))*r0;
//cout << r << endl;         
         assert(r.denominator>0);
         ccvs.add_constraint((Linear_Expression)r>=0);
      }
   }
   return ccvs;   
}

convex_clock_val_set get_poly_from_cone(convex_clock_val_set& c)
{
   // Given cone constraints in n+1 space, return the n-space constraints derived from the generators of the cone
   dimension_type dim=c.space_dimension()-1;
   convex_clock_val_set ccvs(dim);   
      
   if (dim>0)
   {
      Linear_Expression e;
      Generator_System gs(c.minimized_generators());
      for (Generator_System::const_iterator it=gs.begin();it!=gs.end();++it)
      {
         if (!(it->is_line() || it->is_ray()))
         if (!it->is_equivalent_to(point(0*Variable(dim))))
         {
            cout << *it << endl;
            throw_error("get_poly_from_cone can't deal with points");
         }
            
         // inhomogeneous term is the first variable
         e=0*Variable(dim-1)+it->coefficient(Variable(0));
         // for each constraint, add a ray 
         for (dimension_type i=0;i<dim;++i)
         {
            e+=it->coefficient(Variable(i+1))*Variable(i);
         }
         ccvs.add_constraint(e>=0);
         // if it's a line, add it twice
         if (it->is_line())
            ccvs.add_constraint(-e>=0);
      }
   }
   return ccvs;   
}
