/***************************************************************************
                          general.cpp  -  description
                             -------------------
    begin                : Wed Feb 11 2004
    copyright            : (C) 2004 by Goran Frehse
    email                : goran.frehse@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "general.h"

// --------------------------------------------------------------

void pause_key()
{
  cout << "waiting for key:" << endl;
  char c;
  cin >> c;
}          

void throw_error(string s)
{
  cout << "ERROR: " << s << endl << flush;
  cout << "       (while parsing line " << line_number << ")." << endl << flush;
  //cout << "ERROR: " << s << flush << endl;
  //cerr << "ERROR: " << s << flush << endl;
  abort();
//  pause_key();
}

void throw_warning(string s)
{
  cout << "WARNING: " << s << flush << endl;
  cout << "Press a key and then press Enter to continue:"<< flush << endl;
  pause_key();
}

unsigned int PROGRESS_DOT_COUNT = 0;

void progress_dot()
{
  if ((VERBOSE_LEVEL & 10) !=0)
  {
    if (PROGRESS_DOT_COUNT==0)
      cout << message_prefix(VERBOSE_LEVEL);
    ++PROGRESS_DOT_COUNT;
    cout << "." << flush;
    if (PROGRESS_DOT_COUNT>=50)
    {
      PROGRESS_DOT_COUNT=0;
      cout << endl;
    };
  };
}

void progress_dot_end()
{
  if ((VERBOSE_LEVEL & 10) !=0)
    cout << endl;
  PROGRESS_DOT_COUNT=0;
}

void message(unsigned int level, string s)
{
  if (VERBOSE_LEVEL >= level)
  {
    if (level<4000)
      cout << endl;

    string prae=message_prefix(level);
    cout << prae << s << flush << endl;
    if (level<4000)
    {
    cout << prae;
      for (unsigned int i=0;i<s.size();++i)
        cout << "-";
    cout << endl << flush;
    };
  };
}

string message_prefix(unsigned int l)
{
  string prae="";
  l=l/1000;
  while (l>1)
  {
    l=l/2;
    prae+="  ";
  };
  return prae;
}


// greatest common divisor for cost_fun_type calculations
// use gcd_assign instead
int gcd( int num1, int num2 )
{
  int remainder = num2 % num1;
  if ( remainder != 0 )
    return gcd( remainder,num1 );
  return num1;
}

string int2string(const int i)
{
  // convert integer to char, but only up to 256 digits!
  char chr[256];
  string str;
  sprintf(chr,"%i",i);
  str=chr;
  return str;
}

string double2string(const double d)
{
  // convert integer to char, but only up to 256 digits!
  char chr[256];
  string str;
  sprintf(chr,"%g",d);
  str=chr;
  return str;
}

  /*
string Integer2string(const Integer& i)
{
  // convert integer to char, but only up to 256 digits!
  char chr[256];
  string str;
//  sprintf(chr,"%i",i);
  sprintf(chr,i);
  str=chr;
  return str;
  };*/

string string_before(const string& str, const string& c)
{
	// Return all chars before encountering c.
	// Note: By definition, str is returned if c is empty or c is not found.
	//       This is so that string_before + c + string_after == str
	string out("");
	bool ret_all=false;
	
	if (c.size()>0)
	{
		size_t i=str.find(c);
		if (i!=string::npos)
		{
			if (i>0)
				out=str.substr(0,i);
		}
		else
			ret_all=true;
	}
	else
		ret_all=true;
	
	if (ret_all) 
		return str;
	else
		return out;
}

string string_after(const string& str, const string& c)
{
	// Return all chars after encountering c.
	// Note: By definition, nothing is returned if c is empty or c is not found.
	//       This is so that string_before + c + string_after == str
	string out("");
	if (c.size()>0)
	{
		size_t i=str.find(c);
		if (i!=string::npos && i+1<str.size())
			out=str.substr(i+c.size(),str.size()-i-c.size());
	};
						
	return out;
}


bool wildcmp(const string& wild, const string& str) 
// taken from http://www.codeproject.com/string/wildcmp.asp
// which is adapted from code by Jack Handy - jakkhandy@hotmail.com
{
	uint cp=0, mp=0;

	uint i=0;
	uint j=0;
	while (i < str.length() && j < wild.length() && wild[j] != '$')
	{
		if ((wild[j] != str[i]) && (wild[j] != '?')) 
		{
			return false;
		}
		i++;
		j++;
	}
	
	while (i<str.length()) 
	{
		if (j<wild.length() && wild[j] == '$') 
		{
			if ((j++)>=wild.length()) 
			{
				return true;
			}
			mp = j;
			cp = i+1;
		} 
		else if (j<wild.length() && (wild[j] == str[i] || wild[j] == '?')) 
		{
			j++;
			i++;
		} 
		else 
		{
			j = mp;
			i = cp++;
		}
	}
	
	while (j<wild.length() && wild[j] == '$')
	{
		j++;
	}
	return j>=wild.length();
}
