/***************************************************************************
 *   Copyright (C) 2004 by Goran Frehse                                    *
 *   gfrehse@localhost                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

 #include "location.h"
 
 
 //--------------------------------------------------------------------------
// Location
//--------------------------------------------------------------------------

location::location(const AUT_invariant& invar,const string& str,const Constraint_List& post_poly) : name(str),is_fully_refined(false),is_surface(true),partition_level(0),priority(-1),nr_checks(0),myinvariant(invar)
{
	if (post_poly.get_max_space_dimension()<=invar.dim) // if constant tp
	{
		mytime_post_poly=convex_clock_val_set(post_poly,invar.dim);
      mytime_post_poly.minimize_memory();
		time_post_poly_uptodate=true;
		time_pre_poly_uptodate=false;
		is_variable_time_elapse=false;
	}
	else
	{
//cout << "Linear vtef" << post_poly.space_dimension() << ":" << post_poly << endl;	
		mylinvtef=linear_vtef(post_poly,invar.dim);
		time_post_poly_uptodate=false;
		time_pre_poly_uptodate=false;	
		is_variable_time_elapse=true;
//cout << "Testing:" << flush;
//cout << time_post_poly();
	};
}

int location::get_memory() const
{
   return name.size() + out_trans.size() + in_trans.size() + 5 + myinvariant.get_memory() + mytime_post_poly.get_memory()
      + mytime_pre_poly.get_memory() + mylinvtef.get_memory() + 3;
}

void location::invariant_add_constraint(const Constraint& c)
	{
//cout << c << endl << flush;
		myinvariant.add_constraint(c);
//cout << myinvariant << endl << flush;
		assume_invariant_modification();
	}
	
  
void
location::add_space_dimensions_and_embed(dimension_type ndims)
{
  myinvariant.add_space_dimensions_and_embed(ndims);
	
	// assume that dimension embedding is commutative with the variable time elapse poly.
	mytime_post_poly.add_space_dimensions_and_embed(ndims);
	if (time_pre_poly_uptodate)
		mytime_pre_poly.add_space_dimensions_and_embed(ndims);
			
	// however, we still have to communicate the fact that dimensions have changed.
	if (is_variable_time_elapse)
	{
	  mylinvtef.add_space_dimensions_and_embed(ndims);
	};
}

void 
location::map_space_dimensions(const PFunction& pfunc)
{
//cout << pfunc << ":" << pfunc.max_in_codomain() << "," << invariant().dim << endl;
   if (is_variable_time_elapse)
   { // it's 2*dim dimensions
      if (pfunc.max_in_codomain()+1>=myinvariant.dim)
      {
         mylinvtef.map_space_dimensions(pfunc);
         if (time_post_poly_uptodate)
            mytime_post_poly.map_space_dimensions(pfunc);
         if (time_pre_poly_uptodate)
            mytime_pre_poly.map_space_dimensions(pfunc);
      }
      else
      {
         // variables are being projected away -> remove them from 
         // for now: get a static poly
         // to do: reconstruct appropriate mylinvtef
//cout << "mapping:" << pfunc.max_in_codomain() << "," << myinvariant.dim << endl;         
         mytime_post_poly=time_post_poly(myinvariant);
         mytime_post_poly.map_space_dimensions(pfunc);
         mytime_post_poly.minimize_memory();
         time_post_poly_uptodate=true;
         mytime_pre_poly=time_elapse_poly(pfunc.max_in_codomain()+1);
         time_pre_poly_uptodate=false;
         mylinvtef=linear_vtef();
         mylinvtef.static_time_post_poly_assign(mytime_post_poly);
         is_variable_time_elapse=false;         
      }
   }
   myinvariant.map_space_dimensions(pfunc);
}
   
void 
location::time_post_poly_assign(const time_elapse_poly& tp)
{
	// todo: shouldn't this account for variable tp?
	if (is_variable_time_elapse)
	{
		mylinvtef.static_time_post_poly_assign(tp);
		time_post_poly_uptodate=false;
	}
	else
	{
		mytime_post_poly=tp;
		time_post_poly_uptodate=true;
	};
	time_pre_poly_uptodate=false;
}

time_elapse_poly 
location::time_post_poly() const
{
//stopwatch sw(2048000,"time_post_poly");

  if (MEMORY_MODE<=1)
  {
	if (!time_post_poly_uptodate && is_variable_time_elapse)
	{
		location& l = const_cast<location&>(*this);
		l.mytime_post_poly=l.mylinvtef.time_post(myinvariant);
// Must not reduce TP here because static constraints would get destroyed!!!		l.mytime_post_poly.limit_constraints(TP_CONSTRAINT_LIMIT,CONSTRAINT_BITSIZE);
//cout << "New post_poly: "<< l.mytime_post_poly.space_dimension() << ":" << 		l.mytime_post_poly << endl;
		l.time_post_poly_uptodate=true;
//if (DEBUG_OUTPUT>1 && sw.value() > 0.1) 
//  cout << endl << "Exceeding time in time_post_poly, took " << sw.value() << endl << flush; 
//cout << "vs. " <<  l.mytime_post_poly << endl;
	};
//cout << mytime_post_poly << endl;	
//mytime_post_poly.print_gen_fp_raw(cout);
}
else
{
	if (!time_post_poly_uptodate && is_variable_time_elapse)
	{
		return mylinvtef.time_post(myinvariant);
	};
}

	return mytime_post_poly;
}

time_elapse_poly 
location::time_pre_poly() const
{
	if (!time_pre_poly_uptodate)
	{		
		location& l = const_cast<location&>(*this);
		// get time_post_poly and compute time_pre_poly by pointmirror_assign
		if (l.time_post_poly_uptodate)
			l.mytime_pre_poly=l.mytime_post_poly;
		else
		{
			l.mytime_pre_poly=l.time_post_poly();
		};
		l.mytime_pre_poly.pointmirror_assign();
		l.time_pre_poly_uptodate=true;
	};
	return mytime_pre_poly;
}

time_elapse_poly 
location::time_post_poly(const clock_val_set& restr) const
{
	// restrict the time_post_poly to the span of points in restr
	if (is_variable_time_elapse)
	{
		location& l = const_cast<location&>(*this);
		return l.mylinvtef.time_post(restr);
	}
	else
		return mytime_post_poly;
}

time_elapse_poly 
location::time_post_poly_starting_from( clock_val_set& start) const
{
	// restrict the time_post_poly to the span of points reachable from start by static_tp
	if (is_variable_time_elapse)
	{
		location& l = const_cast<location&>(*this);
		// let time elapse according to the static restrictions
		// todo: question if there are any static constraints that motivate this
		clock_val_set cvs(start);
		cvs.time_elapse_assign(l.mylinvtef.static_tp);
		cvs.intersection_assign(myinvariant);
		
		return l.mylinvtef.time_post(cvs);
//		return mylinvtef.time_post(restr);
	}
	else
		return mytime_post_poly;
}
	
void 
location::intersection_assign(const location& l)
{
	myinvariant.intersection_assign(l.myinvariant);
	if (is_variable_time_elapse)
	{ // if *this is variable
		if (l.is_variable_time_elapse)
			mylinvtef.intersection_assign(l.mylinvtef);
		else
			mylinvtef.static_time_post_poly_intersection_assign(l.mytime_post_poly);
	}
	else  
	{ // if *this is static
		if (l.is_variable_time_elapse) // l is variable
		{
			// make *this variable
			is_variable_time_elapse=true;
			mylinvtef=l.mylinvtef;
			// add the static component of *this
			mylinvtef.static_time_post_poly_intersection_assign(mytime_post_poly);
		}
		else 
		{ // both are static: simply intersect the tps
			mytime_post_poly.intersection_assign(l.mytime_post_poly);
		};
	};
	assume_invariant_modification();
}
	
void
location::print() const
{
  cout << "Location: " << name << endl;

  cout << "Invariant: ";
  print_constraints(myinvariant);

  cout << "In-trans: ";
  for (trans_ref_set::iterator i=in_trans.begin();i!=in_trans.end();i++)
    cout << (*i) << ",";
  cout << "." << endl;
  cout << "Out-trans: ";
  for (trans_ref_set::iterator i=out_trans.begin();i!=out_trans.end();i++)
    cout << (*i) << ",";
  cout << "." << endl;
	
	if (is_variable_time_elapse)
		mylinvtef.print();
		
	if (time_post_poly_uptodate)
		cout << "TP: ";
       mytime_post_poly.print();
		
	cout << "Partition level: " << partition_level << endl;
}




 
 
 
