#ifndef GUARD_parameters_h
#define GUARD_parameters_h 1
/***************************************************************************
                          parameters.h  -  description
                             -------------------
    begin                : Fri Feb 6 2004
    copyright            : (C) 2004 by Goran Frehse
    email                : goran.frehse@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <set>
#include "rat_linexpression.h"
 
/*
    Verbose levels:
    &1==0  no timers
    &1!=0  timers
    &10==0  no progress dots
    &10!=0  progress dots

    1000    main function calls
    2000    main function calls + results
    4000    sublevel 1 calls
    8000    sublevel 1 calls + results
    16000   sublevel 2 calls
    32000   sublevel 2 calls + results
    64000   sublevel 3 calls
    128000  sublevel 3 calls + results

    4100    is_simulation

*/
 

// global variables
int GLOBAL_ITER_COUNT = 0;

// ---------------------------------------
unsigned int VERBOSE_LEVEL = 8010;
unsigned int DEBUG_OUTPUT = 0;

int MEMORY_MODE = 4;

// -------------------------------------------------------------------------------
int BOUND_BOX_BITSIZE = 0;
int CONSTRAINT_BITSIZE = 0;
int LIMIT_CONSTRAINTS_METHOD = 1;  // 0: maxdelta, 1: angle

int TIME_POST_ITER = 0;
unsigned TIME_POST_CONE_ITER;
Rational TIME_POST_LAMBDA;

bool ELAPSE_TIME = true; // perform time elapse (can be turned off for discrete time systems)
bool INTERSECT_MINIMIZED = true;
bool ADD_CONSTRAINT_MINIMIZED =true;
bool BLOCK_OVERAPPROXIMATION = false; // this can be switched on by the search algorithm to improve convergence
// Composition
bool STOP_COMPOSE_AT_ERROR = true;
string ERROR_LOCATION_STRING = "error"; 
string TAU_LABEL_STRING = "TAU"; 
bool USE_HIOA_AUTOMATA = false; // add environment transitions to automata
// Reachability
bool CHEAP_CONTAIN_RETURN_OTHERS = true;
bool USE_CONVEX_HULL = false; // this is for all reach operations, is temporarily changed in is_simulation()
bool REACH_STOP_AT_FORB = false; // check after each iteration and stop reachability if forbidden states encountered
bool REACH_ONLY_EXPLORE = false; // do not keep visited states, explore only
bool REACH_USE_BBOX = false; // 
bool USE_CONSTRAINT_HULL = false; // can be used instead of convex hull
int REACH_MAX_ITER = 0;
int REACH_USE_BBOX_ITER = 1000000000;
int REACH_STOP_USE_CONVEX_HULL_ITER = 1000000000;
int REACH_STOP_USE_BITSIZE = 1000000000;
bool REACH_STOP_USE_CONVEX_HULL_SETTLE = false;
int REACH_CONSTRAINT_LIMIT = 0;
int REACH_CONSTRAINT_TRIGGER = 0;
int REACH_BITSIZE_TRIGGER = 0;
int TP_CONSTRAINT_LIMIT = 0;
int SEARCH_METHOD = 0; // 0: transition based, 3: depth-first, 4: breadth-first, 1: post horizon-based, 2: predecessor ratio
int SNAPSHOT_INTERVAL = 0; // output snapshot every x iterations
bool DEADLOCK_CHECKING = false;
bool CREATION_GRAPH_OUTPUT = false;
// Simulation
bool Q_IS_DETERMINISTIC = false; // this doesn't work, leave it off
bool CHECK_FOR_TAU_IN_Q = false; // if tau transitions are followed in Q
bool USE_CONVEX_HULL_FOR_PRIMING = true; // this is for priming the simulation relation
bool STOP_AT_BAD_STATES = true && Q_IS_DETERMINISTIC && !USE_CONVEX_HULL_FOR_PRIMING; // can't be used with USA_CONVEX_HULL_FOR_PRIMING
bool PRIME_R_WITH_REACH = true; // prime R with reach set of P||Q
bool PRIME_R_WITH_DISCRETE_REACH = true; // prime R with discretely reachable states of P||Q
bool SHOW_BAD_STATES = false; // output bad states where found
bool SIM_SIMPLIFY_R = true; //  simplify R after difference operation
// Minimization
bool MINIM_USE_CONVEX_HULL_FOR_PRIMING = false; // this is for priming the simulation relation in minimization
bool MINIM_PRIME_R_WITH_REACH = false; // prime R with reach set of P||Q in minimization
// Composition
bool COMPOSE_WITH_REACH_MIN = false; // delete unreachable locations after composition
bool COMPOSE_USE_CONVEX_HULL_FOR_REACH = true; // this is for priming the simulation relation in minimization
// Refinement
bool REFINE_CHECK_TIME_RELEVANCE = true; // check the time relevance of newly created transitions
bool REFINE_CHECK_TIME_RELEVANCE_DURING = false; // check the time relevance of existing transitions for cells during the refinement process
bool REFINE_CHECK_TIME_RELEVANCE_FINAL = false; // check the time relevance of existing transitions for cells that are completely refined
bool REFINE_CHECK_TRANS_DIMS = false; // not sound!
int  REFINE_DERIVATIVE_METHOD = 2; // 0 = constraint-based, 1 = bb of 0, 2 = projection-based, 3 = bb of 2
bool REFINE_PRIORITIZE_REACH_SPLIT = false;
bool REFINE_PRIORITIZE_ANGLE = false;
bool REFINE_TEST_REACH_SPLIT = true;
bool REFINE_SMALLEST_FIRST = false;
bool REFINE_USE_FP = false;
double REFINE_DERIV_MINANGLE = 1;
int  REFINE_PARTITION_LEVEL_MAX = -1; 
int  REFINE_PARTITION_LEVEL_DELTA = 1; 
bool REFINE_PARTITION_INSIDE = false;
int REACH_FB_REFINE_METHOD = 1; // 1: refine 1 constraint at a time, 0: refine all constraints at a time
int REFINE_INTERSECT_METHOD = 0;
// choosing the splitting plane
int REFINE_LOCATION_PLANE = 0; // 0: default (center) 1: Doyen,Henzinger,Raskin
bool REFINE_FORCE_SPLITTING = true;
int REFINE_MAX_CHECKS = 0;

unsigned int GENERATOR_TO_DOUBLE_PRECISION = 0;

// ---------------------------------------------
// DHR
// ---------------------------------------------
#include "DHR_Rational.h"
int DHR_output_level=0;
bool DHR_HALF_CUT_METHOD=false;
DHR_Rational DHR_THRESHOLD;
Integer DHR_THRESHOLD_num;
Integer DHR_THRESHOLD_den;

void set_TIME_POST_LAMBDA(Rational v)
{
   TIME_POST_LAMBDA=v;
};

void bogus();

/*1.4142135623730950488016887242096980785696718753769480731766797379907324784621
07038850387534327641572735013846230912297024924836055850737212644121497099935831
41322266592750559275579995050115278206057147010955997160597027453459686201472851
74186408891986095523292304843087143214508397626036279952514079896872533965463318
08829640620615258352395054745750287759961729835575220337531857011354374603408498
84716038689997069900481503054402779031645424782306849293691862158057846311159666
87130130156185689872372352885092648612494977154218334204285686060146824720771435
85487415565706967765372022648544701585880162075847492265722600208558446652145839
88939443709265918003113882464681570826301005948587040031864803421948972782906410
45072636881313739855256117322040245091227700226941127573627280495738108967504018
36986836845072579936472906076299694138047565482372899718032680247442062926912485
90521810044598421505911202494413417285314781058036033710773091828693147101711116
83916581726889419758716582152128229518488472089694633862891562882765952635140542*/

#endif
