
%{
	#include <stdio.h>
	#include <stdlib.h>
	#include <string.h>
	#include <clock_val_set.h>
	#include <automaton.h>
	
	#define YY_ALWAYS_INTERACTIVE 1
	#define YYDEBUG 1
	
	#ifdef CPLUSPLUS
	extern int yylex();
	#endif

  extern unsigned int line_number;
	void yyerror(const char *msg)
	{		
      printf("Parse error in line %d: ", line_number);
      printf("%s\n", msg);
	}
  
	void yyerror(const string s)
	{
      yyerror(s.c_str());
	}
  
  string str;

	Rational_Linear_Expression * plinexp;
	Constraint * pcon;
	clock_val_set * pcvs, *pcvs2;
  clock_val_set mycvs;
  automaton *paut;
  symb_states_type *psymb_state;
  clock_ref_set * pcrs;
  vector<string> mystringvec;
  vector<automaton> aut_vec;
  transition_ref trans_ref;

	map <string, unsigned int> varmap;
	map <string, Rational_Linear_Expression> linexmap;
  map <string, pair <symb_states_type, automaton*> > sstatesmap;
  map <string, pair <state_relation, pair <automaton*, automaton*> > > sstate_relationmap;  
	map <string, automaton*> pautmap;

//	automaton_vec aut_vec;  // automaton-vector
  symb_states_type sstates;
  unsigned int dim=1;


  string outfilename="out";
  ofstream file_out;


//  automaton myaut(0);
  clock_val_set g,gg,gc;
  time_elapse_poly univ_tp(dim),tp(dim),tp2(dim);
  clock_ref_set r,rx;
  string current_loc_name;
  
  refinement_method ref_meth;
  
%}

%union{
 char * mystring;
 Rational_Linear_Expression  *linexp;
 Constraint *	con;
 Constraint_List * con_list;
 clock_val_set * cvs;
 automaton *aut;
 bool mybool;
 symb_states_type *symb_state;
 clock_ref_set *crs;
 ConstraintRatPair *pconstraint_rat_pair;
 list <ConstraintRatPair> *pconstraint_rat_pair_list;
 list<string> *pident_list;
 prob_alt *pprob_alt;
 list<prob_alt> *pprob_alt_list;
};

%token REACH_GRAPH
%token MERGE_SPLITTED
%token ASAP
%token PRIORITY
%token par_USE_HIOA_AUTOMATA
%token par_CREATION_GRAPH_OUTPUT
%token par_TIME_POST_LAMBDA
%token par_TIME_POST_CONE_ITER
%token par_TIME_POST_ITER
%token par_ELAPSE_TIME
%token par_BOUND_BOX_BITSIZE
%token par_CONSTRAINT_BITSIZE
%token par_REACH_STOP_USE_BITSIZE
%token par_MEMORY_MODE
// Reachability
%token par_CHEAP_CONTAIN_RETURN_OTHERS
%token par_USE_CONVEX_HULL
%token par_USE_CONSTRAINT_HULL
%token par_REACH_STOP_AT_FORB
%token par_REACH_ONLY_EXPLORE
%token par_REACH_USE_BBOX
%token par_REACH_MAX_ITER
%token par_REACH_USE_BBOX_ITER
%token par_REACH_STOP_USE_CONVEX_HULL_ITER
%token par_REACH_STOP_USE_CONVEX_HULL_SETTLE
%token par_REACH_CONSTRAINT_LIMIT
%token par_LIMIT_CONSTRAINTS_METHOD
%token par_TP_CONSTRAINT_LIMIT
%token par_REACH_CONSTRAINT_TRIGGER
%token par_REACH_BITSIZE_TRIGGER
%token par_SEARCH_METHOD
%token par_SNAPSHOT_INTERVAL

// Simulation
%token par_USE_CONVEX_HULL_FOR_PRIMING
%token par_PRIME_R_WITH_REACH
%token par_SHOW_BAD_STATES
%token par_SIM_SIMPLIFY_R
%token par_PRIME_R_WITH_DISCRETE_REACH
// Minimization
%token par_MINIM_USE_CONVEX_HULL_FOR_PRIMING
%token par_MINIM_PRIME_R_WITH_REACH
// Composition
%token COMPOSE
%token par_COMPOSE_WITH_REACH_MIN
%token par_COMPOSE_USE_CONVEX_HULL_FOR_REACH
%token par_COMPOSE_STOP_AT_ERROR
// Refinement
%token par_REFINE_DERIVATIVE_METHOD
%token par_REFINE_PRIORITIZE_REACH_SPLIT;
%token par_REFINE_SMALLEST_FIRST;
%token par_REFINE_USE_FP;
%token par_REFINE_DERIV_MINANGLE;
%token par_REFINE_PRIORITIZE_ANGLE;
%token par_REFINE_CHECK_TIME_RELEVANCE; 
%token par_REFINE_CHECK_TIME_RELEVANCE_DURING;
%token par_REFINE_CHECK_TIME_RELEVANCE_FINAL; 
%token par_REFINE_CHECK_TRANS_DIMS;
%token par_REFINE_PARTITION_INSIDE;
%token par_REACH_FB_REFINE_METHOD;
%token par_REFINE_INTERSECT_METHOD;
%token par_REFINE_LOCATION_PLANE;
%token SET_DHR_VARS;
%token par_DHR_THRESHOLD;
%token IS_REACHABLE_DHR;
%token par_REFINE_MAX_CHECKS;

%token PROJECT_TO
%token DIFFERENCE_ASSIGN
%token RENAME
%token IS_REACHABLE
%token IS_REACHABLE_FB
%token INVARIANT_ASSIGN
%token REVERSE
%token SAVE_FP_SURFACE
%token REACH_FORWARD_ITER
%token UNLOCK_SURFACE_LOCS
%token UNLOCK_LOCS
%token GET_INVARIANTS
%token PRINT_GRAPH
%token PROJECT_TO_FIRST
%token INVERSE
%token CONTAINS
%token REFINE_CONSTRAINTS
%token ADD_LABEL
%token WHO
%token SAVE_FP_INVARS
%token INITIAL_STATES
%token REFINE_LOCS
%token REFINE_LOC_DERIV
%token GET_SIM
%token IS_EMPTY
%token INTERSECTION_ASSIGN
%token LOC_INTERSECTION
%token LOC_UNION
%token REMOVE
%token STRING_TEXT
%token EECHO
%token GET_PARAMETERS
%token IS_SIM
%token IS_BISIM
%token AGSIM
%token AGCSIM
%token PRINT
%token SAVE_CON_FP
%token SAVE_GEN_FP
%token REACH
%token REACH_STOP
%token DEFNE
%token AUTOMATON
%token INTERNAL_VAR
%token EXTERNAL_VAR
%token PARAMETER
%token SYNCLABS
%token INITIALLY
%token LOC
%token WHILE
%token WAIT
%token WHEN
%token DO
%token SYNC
%token GOTO
%token END
%token TRUE
%token FALSE
%token ASSIGN
%token PALT

%token <mystring> INT
%token <mystring> IDENT
%token <mystring> STARIDENT
%token <mystring> STRING_TEXT
//%nonassoc '(' ')'
%left '|' '&'
%left GE LE EQ '<' '>'
%left '+' '-'
%left '*' '/'
%left '!'
%left '(' ')'
%left PRIM


%type <cvs> val_set
%type <linexp> linearexpr
%type <con> constraint
%type <con_list> constr_list
%type <con_list> constr_list_no_and
%type <pident_list> composed_aut
%type <symb_state> state_list
%type <mybool> bool_type
%type <crs> clock_ref_list
%type <pconstraint_rat_pair> constraint_rat_pair
%type <pconstraint_rat_pair_list> constraint_rat_pair_list
%type <pident_list> ident_list
%type <pprob_alt> probabilistic_alternative
%type <pprob_alt_list> probabilistic_alternative_list

%%
	
program:
  commands
	;

commands: commands command
	| command
  ;

command:
	prelim
	| automaton
	// --------------------------------------------------------
	// General commands
	// --------------------------------------------------------
  | EECHO STRING_TEXT ';'
    { cout << $2 << endl << flush; }
  | WHO ';'
    { cout << "Automata in memory:" << endl << flush; 
			for (map <string, automaton*>::const_iterator i = pautmap.begin(); i!= pautmap.end(); ++i)
			{
				cout << i->first << " ";
				cout << "(" << (i->second)->name << "):";
				(i->second)->print_size();
//				cout << endl;
			};
     cout << endl << "Constants in memory:" << endl << flush;
     for (map <string, Rational_Linear_Expression>::const_iterator i = linexmap.begin(); i!= linexmap.end(); ++i)
         {
            cout << i->first << " := " << i->second << endl << flush;
            //cout << endl;
         };
      
/*	map <string, unsigned int> varmap;
	map <string, Rational_Linear_Expression> linexmap;
   map <string, pair <symb_states_type, automaton*> > sstatesmap;
   map <string, pair <state_relation, pair <automaton*, automaton*> > > sstate_relationmap;  
	map <string, automaton*> pautmap;*/
   
        cout << endl << "Symbolic states in memory:" << endl << flush;
     for (map <string, pair <symb_states_type, automaton*> >::const_iterator i = sstatesmap.begin(); i!= sstatesmap.end(); ++i)
         {
            cout << i->first << " : " << i->second.first.size() << " locs, " << i->second.first.get_memory() << " bytes" << endl << flush;
//            cout << endl;
         };
         cout << endl;
	}
         
	// --------------------------------------------------------
	// Copy commands
	// --------------------------------------------------------
  | IDENT '=' IDENT ';'
      { str=$3;
        if (sstatesmap.find(str)!=sstatesmap.end())
        {
          sstatesmap[$1]=sstatesmap[$3];
        }
        else if (sstate_relationmap.find(str)!=sstate_relationmap.end())
        {
          sstate_relationmap[$1]=sstate_relationmap[$3];
        }
        else if (pautmap.find(str)!=pautmap.end())
        {
					paut = new automaton(*pautmap[$3]);
					paut->name=$1;
          pautmap[$1]=paut;
        }
        else
          {yyerror("Identifier " + str + " not found.");}; 
      }
  | IDENT '.' PRINT ';'
      { 
  		  str=$1;
        if (sstatesmap.find(str)!=sstatesmap.end())
        {
            if (sstatesmap[$1].second != NULL)
            {
			 cout << str << " = " << sstatesmap[$1].second->name << "." << "{";
					sstatesmap[$1].first.print_phaver(cout);
			 cout << "};" << endl;
            }
            else
            {
					sstatesmap[$1].first.print_phaver(cout);
            }
        }
        else if (sstate_relationmap.find(str)!=sstate_relationmap.end())
        {
          sstate_relationmap[$1].first.print();
        }
        else if (pautmap.find(str)!=pautmap.end())
        {
					pautmap[$1]->print();
        }
        else
          {yyerror("Identifier " + str + " not found.");}; 
			}
  | IDENT '.' PRINT '(' STRING_TEXT ',' INT ')' ';' 
      { if (sstatesmap.find($1)!=sstatesmap.end())
				{
//cout << "#############################" << (*$7)==2 << endl;				
					file_out.open( $5 );
								// sstatesmap[$1].first.print(sstatesmap[$1].second->get_loc_names());
					file_out.precision(FP_PRECISION);
					if (atoi($7) == 1) // constraint form
						sstatesmap[$1].first.print_con_fp_raw(file_out);
					else if (atoi($7) == 2) // generator form
						sstatesmap[$1].first.print_gen_fp_raw(file_out);
					else if (atoi($7) == 3) // debug form
						sstatesmap[$1].first.print();
					else if (atoi($7) == 4) // debug form
						sstatesmap[$1].first.print(sstatesmap[$1].second->get_loc_names());
  					else
					{
			   		str=$1;
						file_out << str << " = " << sstatesmap[$1].second->name << "." << "{";
								sstatesmap[$1].first.print_phaver(file_out);
						file_out << "};";
					}
					file_out.close();
				}      
				else if (sstate_relationmap.find($1)!=sstate_relationmap.end())
				{
					file_out.open( $5 );
								//sstate_relationmap[$1].first.print();
					file_out << "error, feature not implemented yet";
					file_out.close();
					cout << "hello";
				}
            else if (pautmap.find($1)!=pautmap.end())
            {
					file_out.open( $5 );
					if (atoi($7) == 1) // dot form (graphviz)
	  				  pautmap[$1]->print_dot(file_out);
               else
	  				  pautmap[$1]->print_phaver(file_out);
					file_out.close();
            }
        else yyerror("Unknown identifier '" + (string)$1 +"'."); 
			}			
  | IDENT '.' SAVE_GEN_FP '(' STRING_TEXT ')' ';' // save sstatesmap($1) or sstate_relationmap in filename($5)
      {  throw_warning("Command save_gen_fp is deprecated. Use print(\"fname\",2) instead.");
			if (sstatesmap.find($1)!=sstatesmap.end())
				{
					file_out.open( $5 );
								// sstatesmap[$1].first.print(sstatesmap[$1].second->get_loc_names());
					file_out.precision(FP_PRECISION);
					sstatesmap[$1].first.print_gen_fp_raw(file_out);
					file_out.close();
				}      
				else if (sstate_relationmap.find($1)!=sstate_relationmap.end())
				{
					file_out.open( outfilename.c_str() );
								//sstate_relationmap[$1].first.print();
					file_out << "test";
					file_out.close();
					cout << "hello";
				}
        else yyerror("Unknown identifier '" + (string)$1 +"'."); 
			}
  | IDENT '.' SAVE_CON_FP '(' STRING_TEXT ')' ';'
      { throw_warning("Command save_con_fp is deprecated. Use print(\"fname\",1) instead.");
		  if (sstatesmap.find($1)!=sstatesmap.end())
				{
					file_out.open( $5 );
								// sstatesmap[$1].first.print(sstatesmap[$1].second->get_loc_names());
					file_out.precision(FP_PRECISION);
					sstatesmap[$1].first.print_con_fp_raw(file_out);
					file_out.close();
				}      
							else if (sstate_relationmap.find($1)!=sstate_relationmap.end())
				{
					file_out.open( outfilename.c_str() );
								//sstate_relationmap[$1].first.print();
					file_out << "test";
					file_out.close();
					cout << "hello";
				}
        else yyerror("Unknown identifier '" + (string)$1 +"'."); 
			}	
  | IDENT '.' SAVE_CON_FP '[' STRING_TEXT ']' ';'
      { if (sstatesmap.find($1)!=sstatesmap.end())
				{
					file_out.open( $5 );
					file_out.precision(FP_PRECISION);
					clock_val_set temp_cvs=sstatesmap[$1].first.union_over_locations();
					temp_cvs.print_con_fp_raw(file_out);
					file_out.close();
				}      
							else if (sstate_relationmap.find($1)!=sstate_relationmap.end())
				{
					file_out.open( outfilename.c_str() );
								//sstate_relationmap[$1].first.print();
					file_out << "test";
					file_out.close();
					cout << "hello";
				}
        else yyerror("Unknown identifier '" + (string)$1 +"'."); 
			}	
	// --------------------------------------------------------
	// symbolic_states_type commands
	// --------------------------------------------------------
  | IDENT '=' IDENT '.' { 
				if (pautmap.find($3)!=pautmap.end())
				{
               paut=pautmap[$3];
				}
            else
					{yyerror("Automaton '" + (string)$3 + "' not found.");}; 
         
            } '{' state_list '}' ';'
            { sstatesmap[$1]=make_pair(*$7,pautmap[$3]);}
  | IDENT '.' 
			{
				if (sstatesmap.find($1)!=sstatesmap.end()) 
				{
					psymb_state=&sstatesmap[$1].first;
					paut=sstatesmap[$1].second;
				}
				else 
				{
					yyerror("Unknown state identifier '" + (string)$1 +"'.");
					psymb_state=NULL;
				};
			} // needed so clock_ref_list can refer to the right variables
	  REMOVE '(' clock_ref_list ')' ';'
      { 
         if ($6!=NULL)
         {
            if (sstatesmap.find($1)!=sstatesmap.end())
               sstatesmap[$1].first.remove_space_dimensions(*$6);
            else yyerror("Unknown identifier '" + (string)$1 +"'."); 
			};
         psymb_state=NULL;
      }
  | IDENT '.' 
			{
				if (sstatesmap.find($1)!=sstatesmap.end()) 
				{
					psymb_state=&sstatesmap[$1].first;
					paut=sstatesmap[$1].second;
				}
				else 
				{
					psymb_state=NULL;
               paut=NULL;
               if (pautmap.find($1)!=pautmap.end())
               {
                  paut=pautmap[$1];
               }
               else
					 yyerror("Unknown identifier '" + (string)$1 +"'.");
				};
			} // needed so clock_ref_list can refer to the right variables
	  PROJECT_TO '(' clock_ref_list ')' ';'
      { 
         if ($6!=NULL)
         {
            if (psymb_state!=NULL)
               sstatesmap[$1].first.project_to_vars(*$6);
            else if (paut!=NULL)
               paut->project_to_vars(*$6);
            else yyerror("Unknown identifier '" + (string)$1 +"'."); 
			};
         psymb_state=NULL;
         paut=NULL;
      }      
	| GET_PARAMETERS '(' IDENT ',' bool_type ')' ';'
      { str=$3;
        if (sstatesmap.find(str)!=sstatesmap.end())
        {
          sstates=sstatesmap[str].first;
          clock_ref_set crs=sstatesmap[str].second->parameters;
          sstates.remove_space_dimensions(crs.complement(0,sstatesmap[str].second->dim));
          clock_val_set tempcvs;
          if ($5)
          {
            cout << "Parameters in any of the locations:" << endl;
            tempcvs=sstates.union_over_locations();
          }
          else
          {
            cout << "Parameters common to all locations:" << endl;
            tempcvs=sstates.intersection_over_locations();
          };
          tempcvs.print();
        }
        else
          {yyerror("Identifier " + (string)$3 + " not found.");}; }      
  | IDENT '.' LOC_UNION ';'
      { if (sstatesmap.find($1)!=sstatesmap.end())
        { mycvs=sstatesmap[$1].first.union_over_locations();
          mycvs.print(sstatesmap[$1].first.var_names);
					mycvs.print_gen_fp_raw(cout);
				}
        else yyerror("Unknown identifier '" + (string)$1 +"'."); }
  | IDENT '.' LOC_INTERSECTION ';'
      { if (sstatesmap.find($1)!=sstatesmap.end())
        { mycvs=sstatesmap[$1].first.intersection_over_locations();
          mycvs.print(sstatesmap[$1].first.var_names);
					mycvs.print_gen_fp_raw(cout);
				}
        else yyerror("Unknown identifier '" + (string)$1 +"'."); }
  | IDENT '=' IDENT '.' LOC_UNION ';'
      { if (sstatesmap.find($3)!=sstatesmap.end())
        { mycvs=sstatesmap[$3].first.union_over_locations();
//cout << mycvs;        
          psymb_state=new symb_states_type(sstatesmap[$3].first.var_names);
          psymb_state->add("$",mycvs);
          sstatesmap[$1]=make_pair(*psymb_state,sstatesmap[$3].second);
          delete psymb_state;
        }
        else yyerror("Unknown identifier '" + (string)$1 +"'."); }
  | IDENT '=' IDENT '.' LOC_INTERSECTION ';'
      { if (sstatesmap.find($3)!=sstatesmap.end())
        { mycvs=sstatesmap[$3].first.intersection_over_locations();
//cout << mycvs;        
          psymb_state=new symb_states_type(sstatesmap[$3].first.var_names);
          psymb_state->add("$",mycvs);
          sstatesmap[$1]=make_pair(*psymb_state,sstatesmap[$3].second);
          delete psymb_state;
        }
        else yyerror("Unknown identifier '" + (string)$1 +"'."); }
  | IDENT '=' IDENT '.' MERGE_SPLITTED ';'
      { if (sstatesmap.find($3)!=sstatesmap.end())
        { 
//cout << mycvs;        
//          psymb_state=new symb_states_type(sstatesmap[$3].first.var_names);
          sstates=sstatesmap[$3].first.merge_splitted();
          sstatesmap[$1]=make_pair(sstates,(automaton*)NULL);
	  //          delete psymb_state;
        }
        else yyerror("Unknown identifier '" + (string)$1 +"'."); }
  | IDENT '.' INTERSECTION_ASSIGN '(' IDENT ')' ';'

      { if (sstatesmap.find($1)!=sstatesmap.end())
        {
          if (sstatesmap.find($5)!=sstatesmap.end())
          { sstatesmap[$1].first.intersection_assign(sstatesmap[$5].first,true);
          }
          else yyerror("Unknown identifier '" + (string)$5 +"'.");
          }
        else yyerror("Unknown identifier '" + (string)$1 +"'."); 
      }
  | IDENT '.' DIFFERENCE_ASSIGN '(' IDENT ')' ';'

      { if (sstatesmap.find($1)!=sstatesmap.end())
        {
          if (sstatesmap.find($5)!=sstatesmap.end())
          { sstatesmap[$1].first.difference_assign(sstatesmap[$5].first,true);
          }
          else yyerror("Unknown identifier '" + (string)$5 +"'.");
          }
        else yyerror("Unknown identifier '" + (string)$1 +"'."); 
      }		
  | IDENT '.' CONTAINS '(' IDENT ')' ';'

      { if (sstatesmap.find($1)!=sstatesmap.end())
        {
          if (sstatesmap.find($5)!=sstatesmap.end())
          { if (sstatesmap[$1].first.contains(sstatesmap[$5].first,true))
						  cout << $1 << " contains " << $5;
						else
						  cout << $1 << " does not contain " << $5;
          }
          else yyerror("Unknown identifier '" + (string)$5 +"'.");
          }
        else yyerror("Unknown identifier '" + (string)$1 +"'."); 
      }			
  | IDENT '.' IS_EMPTY ';'
      { if (sstatesmap.find($1)!=sstatesmap.end())
        { if (sstatesmap[$1].first.is_empty())
            cout << "empty";
          else
            cout << "not empty";
          }
        else yyerror("Unknown identifier '" + (string)$1 +"'.");
      }
  | IDENT '.' RENAME '(' IDENT ',' IDENT ')' ';'
      { if (sstatesmap.find($1)!=sstatesmap.end())
        { 
		  		sstatesmap[$1].first.rename_variable((string)$5,(string)$7);
				// remove the reference to any automaton because now it's changed
				sstatesmap[$1].second=NULL;
        }
        else yyerror("Unknown identifier '" + (string)$1 +"'.");
      }		
	// --------------------------------------------------------
	// state_relation commands
	// --------------------------------------------------------
  | IDENT '=' GET_SIM '(' IDENT ',' IDENT ')' ';'
      { sstate_relationmap[$1]=make_pair(state_relation(),make_pair(pautmap[$5],pautmap[$7]));
        pautmap[$5]->is_simulation(*pautmap[$7],&(sstate_relationmap[$1].first)); }
	| IDENT '=' IDENT '.' INVERSE '(' IDENT ')' ';'
      { sstatesmap[$1]=make_pair(sstate_relationmap[$3].first.project_to_first(sstatesmap[$7].first),sstate_relationmap[$3].second.first); 
			  sstatesmap[$1].first.var_names_assign(sstate_relationmap[$3].second.first->get_var_names());
			}
	| IDENT '=' IDENT '.' PROJECT_TO_FIRST ';'
      { sstatesmap[$1]=make_pair(sstate_relationmap[$3].first.project_to_first(sstate_relationmap[$3].second.first->dim),sstate_relationmap[$3].second.first); 
			  sstatesmap[$1].first.var_names_assign(sstate_relationmap[$3].second.first->get_var_names());
			}
	// --------------------------------------------------------
	// automaton commands
	// --------------------------------------------------------
/*  | IDENT '=' composed_aut ';'
      { //paut = new automaton(*$3);
				//paut->name=(string)$1; 
				//pautmap[$1]=paut; 
				pautmap[$1]=$3}*/
  | IDENT '=' COMPOSE '(' ident_list ')' ';'
      {
         // create automaton vector
         aut_vec=vector<automaton>();
         for (list<string>::const_iterator it=$5->begin();it!=$5->end();++it)
         {
				if (pautmap.find(*it)!=pautmap.end())
				{
               aut_vec.push_back(*pautmap[*it]);
				}
            else
					{yyerror("Automaton '" + *it + "' not found.");}; 
         }
         //now compose
         paut=new automaton(); 
         compose_by_vector(*paut,aut_vec);
			pautmap[$1]=paut;       
         // delete aut_vec
         aut_vec=vector<automaton>();
      }
  | IDENT '=' composed_aut ';' // gf 06-03-22 changed composed_out to a ident_list
      {					
				if (pautmap.find(*($3->begin()))!=pautmap.end())
				{
               paut=new automaton(*pautmap[*($3->begin())]); 
               automaton* paut_result=new automaton();
               list<string>::const_iterator list_it=$3->begin();
               ++list_it; // go to second one
               while (list_it!=$3->end())
               {
      		     if (pautmap.find(*list_it)!=pautmap.end())
		      	  {
					    compose_discrete(*paut_result,*paut,*pautmap[*list_it]); 
                   swap(paut,paut_result);
                 }
                 else
   					{yyerror("Automaton '" + *list_it + "' not found.");}; 
                 ++list_it;
               }
               delete paut_result;
					pautmap[$1]=paut;       
				}
            else
					{yyerror("Automaton '" + *($3->begin()) + "' not found.");}; 
      }     
	| IDENT '.' SAVE_FP_INVARS '(' STRING_TEXT ')' ';'
			{
				if (pautmap.find($1)!=pautmap.end())
				{
					file_out.open( $5 );
					file_out.precision(FP_PRECISION);
					pautmap[$1]->print_inv_fp_raw(file_out);
					file_out.close();
				}
				else
					{yyerror("Automaton '" + (string)$1 + "' not found.");}; 
			}
	| IDENT '.' SAVE_FP_SURFACE '(' STRING_TEXT ')' ';'
			{
				if (pautmap.find($1)!=pautmap.end())
				{
					file_out.open( $5 );
					file_out.precision(FP_PRECISION);
					pautmap[$1]->print_surface_fp_raw(file_out);
					file_out.close();
				}
				else
					{yyerror("Automaton '" + (string)$1 + "' not found.");}; 
			}			
	| IDENT '.' PRINT_GRAPH '(' STRING_TEXT ',' 
			{
				psymb_state=NULL;
				if (pautmap.find($1)!=pautmap.end())
				{
					paut=pautmap[$1];
				}
				else
					{yyerror("Automaton '" + (string)$1 + "' not found.");}; 
			}
					'{' clock_ref_list '}' ',' IDENT ')' ';'
			{
				if (pautmap.find($1)!=pautmap.end())
				{
					paut=pautmap[$1];
					file_out.open( $5 );
					file_out.precision(FP_PRECISION);
					if (sstatesmap.find($12)!=sstatesmap.end())
					{ 
						paut->print_graph(file_out, *$9, sstatesmap[$12].first);
          }
					else yyerror("Unknown identifier '" + (string)$12 +"'.");					
					file_out.close();
				}
				else
					{yyerror("Automaton '" + (string)$1 + "' not found.");}; 
			}			
	| IDENT '.' REVERSE ';'
			{
				if (pautmap.find($1)!=pautmap.end())
				{
					pautmap[$1]->reverse();
				}
				else
					{yyerror("Automaton '" + (string)$1 + "' not found.");}; 
			}			
	| IDENT '.' ADD_LABEL '(' IDENT ')' ';'
			{
				if (pautmap.find($1)!=pautmap.end())
				{
					pautmap[$1]->add_label((string)$5);
				}
				else
					{yyerror("Automaton '" + (string)$1 + "' not found.");}; 
			}			
	| IDENT '=' IDENT '.' REACH_FORWARD_ITER '(' INT ')' ';'
      { 
				if (pautmap.find($3)!=pautmap.end())
				{
					sstatesmap[$1]=make_pair(pautmap[$3]->get_reach_set_forwarditer(atoi($7)),pautmap[$3]);
				}
				else
					{yyerror("Automaton '" + (string)$3 + "' not found.");}; 
			}
	| IDENT '=' IDENT '.' REACH ';'
      { 
				if (pautmap.find($3)!=pautmap.end())
				{
               sstatesmap[$1]=make_pair(pautmap[$3]->get_reach_set(),pautmap[$3]);
				}
				else
					{yyerror("Automaton '" + (string)$3 + "' not found.");}; 
			}
  | IDENT '.' INITIAL_STATES '(' IDENT ')' ';' 
			{ 
				if (pautmap.find($1)!=pautmap.end())
				{
					paut=pautmap[$1]; 
				}
				else
				{
					yyerror("Automaton '" + (string)$1 + "' not found.");
					paut = NULL;
				}; 
				if (paut!=NULL)
				{
					if (sstatesmap.find($5)!=sstatesmap.end())
					{ 
						paut->ini_states_assign(sstatesmap[$5].first); 
          }
					else yyerror("Unknown identifier '" + (string)$5 +"'.");					
				};
			}
  | IDENT '.' INVARIANT_ASSIGN '(' IDENT ')' ';' 
			{ 
				if (pautmap.find($1)!=pautmap.end())
				{
					paut=pautmap[$1]; 
				}
				else
				{
					yyerror("Automaton '" + (string)$1 + "' not found.");
					paut = NULL;
				}; 
				if (paut!=NULL)
				{
					if (sstatesmap.find($5)!=sstatesmap.end())
					{ 
						paut->invariant_assign(sstatesmap[$5].first); 
          }
					else yyerror("Unknown identifier '" + (string)$5 +"'.");					
				};
			}
  | IDENT '=' IDENT '.' REACH '(' IDENT ')' ';' 
			{ 
				if (pautmap.find($3)!=pautmap.end())
				{
					paut=pautmap[$3]; 
				}
				else
				{
					yyerror("Automaton '" + (string)$3 + "' not found.");
					paut = NULL;
				}; 
				if (paut!=NULL)
				{
					if (sstatesmap.find($7)!=sstatesmap.end())
					{ 
                  symb_states_type dummystates;
                  bool dummybool;
						sstatesmap[$1]=make_pair(paut->get_reach_set(sstatesmap[$7].first,dummystates,dummybool,dummystates),paut); 
          }
					else yyerror("Unknown identifier '" + (string)$7 +"'.");					
				};
			}
  | IDENT '=' IDENT '.' IS_REACHABLE '(' IDENT ')' ';' 
			{ 
				if (pautmap.find($3)!=pautmap.end())
				{
					paut=pautmap[$3]; 
				}
				else
				{
					yyerror("Automaton '" + (string)$3 + "' not found.");
					paut = NULL;
				}; 
				if (paut!=NULL)
				{
					if (sstatesmap.find($7)!=sstatesmap.end())
					{ 
					  sstates.clear();
						if (paut->is_reachable(sstatesmap[$7].first,sstates))
							cout << (string)$7 << " is reachable." << endl << flush;
						else
							cout << (string)$7 << " not reachable." << endl << flush;
						sstatesmap[$1]=make_pair(sstates,paut);          
}
					else yyerror("Unknown identifier '" + (string)$7 +"'.");					
				};
			}	         
  | IDENT '=' IDENT '.' IS_REACHABLE_FB '(' IDENT ')' ';' 
			{ 
				if (pautmap.find($3)!=pautmap.end())
				{
					paut=pautmap[$3]; 
				}
				else
				{
					yyerror("Automaton '" + (string)$3 + "' not found.");
					paut = NULL;
				}; 
				if (paut!=NULL)
				{
					if (sstatesmap.find($7)!=sstatesmap.end())
					{ 
					  sstates.clear();
						if (paut->is_reachable_fb(sstatesmap[$7].first,sstates))
							cout << (string)$7 << " is reachable." << endl << flush;
						else
							cout << (string)$7 << " not reachable." << endl << flush;
						sstatesmap[$1]=make_pair(sstates,paut);          
}
					else yyerror("Unknown identifier '" + (string)$7 +"'.");					
				};
			}					
  | IDENT '=' IDENT '.' IS_REACHABLE_DHR '(' IDENT ',' linearexpr ')' ';' 
			{ 
				if (pautmap.find($3)!=pautmap.end())
				{
					paut=pautmap[$3]; 
				}
				else
				{
					yyerror("Automaton '" + (string)$3 + "' not found.");
					paut = NULL;
				}; 
				if (paut!=NULL)
				{
					if (sstatesmap.find($7)!=sstatesmap.end())
					{ 
					  sstates.clear();
						if (is_reachable_DHR(*paut,sstatesmap[$7].first,$9->rat_inhomogeneous_term(),sstates))
							cout << (string)$7 << " is reachable." << endl << flush;
						else
							cout << (string)$7 << " not reachable." << endl << flush;
						sstatesmap[$1]=make_pair(sstates,paut);          
}
					else yyerror("Unknown identifier '" + (string)$7 +"'.");					
				};
			}			
  | IS_SIM '(' IDENT ',' IDENT ')' ';'
      { 
				if (pautmap.find($3)!=pautmap.end())
				{
					if (pautmap.find($5)!=pautmap.end())
					{
						pautmap[$3]->is_simulation(*pautmap[$5]); 
					}
					else
						{yyerror("Automaton '" + (string)$5 + "' not found.");}; 
				}
				else
					{yyerror("Automaton '" + (string)$3 + "' not found.");}; 
			}
  | IS_BISIM '(' IDENT ',' IDENT ')' ';'
      { 
				if (pautmap.find($3)!=pautmap.end())
				{
					if (pautmap.find($5)!=pautmap.end())
					{
						pautmap[$3]->is_simulation(*pautmap[$5],NULL,true); 
					}
					else
						{yyerror("Automaton '" + (string)$5 + "' not found.");}; 
				}
				else
					{yyerror("Automaton '" + (string)$3 + "' not found.");}; 
			}
  | AGSIM '(' IDENT ',' IDENT ',' IDENT ',' IDENT ')' ';'
      { is_ag_simulation(*pautmap[$3],*pautmap[$5],*pautmap[$7],*pautmap[$9]); }
  | AGCSIM '(' IDENT ',' IDENT ',' IDENT ',' IDENT ')' ';'
      { is_agc_simulation(*pautmap[$3],*pautmap[$5],*pautmap[$7],*pautmap[$9]); }
  | IDENT '.' REFINE_LOC_DERIV ';'
      { refine_loc_deriv(*pautmap[$1]); }
  | IDENT '.' REFINE_LOCS '(' IDENT ',' IDENT ',' INT ')' ';'
      {       
      if ((string)$7=="carth_center")
        ref_meth=carth_center;
      else if ((string)$7=="carth0_center")
        ref_meth=carth0_center;
      else if ((string)$7=="carth1_center")
        ref_meth=carth1_center;
      else if ((string)$7=="deriv_center")
        ref_meth=deriv_center;
			else if ((string)$7=="jacob_center")
        ref_meth=jacob_center;
      else if ((string)$7=="deriv_dcenter")
        ref_meth=deriv_dcenter;
			else if ((string)$7=="jacob_dcenter")
        ref_meth=jacob_dcenter;   
			paut=pautmap[$1];
			refine_locs(*paut,paut->get_label_ref((string)$5),ref_meth,atoi($9));  }
  | IDENT '.' REFINE_LOCS '(' IDENT ')' ';'
      {       
			paut=pautmap[$1];
			refine_states(*paut,sstatesmap[$5].first);  }
	| IDENT '.' REFINE_CONSTRAINTS { paut=pautmap[$1]; } '(' constraint_rat_pair_list ',' IDENT ')' ';'
			{
				REFINE_CONSTRAINTRATPAIRLIST = *$6;
				delete $6;
				REFINEMENT_LABEL = paut->get_label_ref((string)$8);
			}
	| IDENT '=' IDENT '.' INITIAL_STATES ';'
      { 
				if (pautmap.find($3)!=pautmap.end())
				{
					sstatesmap[$1]=make_pair(pautmap[$3]->get_ini_states(),pautmap[$3]);
				}
				else
					{yyerror("Automaton '" + (string)$3 + "' not found.");}; 
			}			
	| IDENT '=' IDENT '.' GET_INVARIANTS ';'
      { 
				if (pautmap.find($3)!=pautmap.end())
				{
					sstatesmap[$1]=make_pair(pautmap[$3]->get_invariants(),pautmap[$3]);
				}
				else
					{yyerror("Automaton '" + (string)$3 + "' not found.");}; 
			}				
  | IDENT '.' UNLOCK_SURFACE_LOCS '(' IDENT ')' ';' // unlock the partitioning flag of locations on the surface of IDENT
      { 
				if (pautmap.find($1)!=pautmap.end())
					if (sstatesmap.find($5)!=sstatesmap.end())
					{
						pautmap[$1]->unlock_surface_locations(sstatesmap[$5].first);
					}      
					else yyerror("Unknown identifier '" + (string)$5 +"'."); 
				else
					{yyerror("Automaton '" + (string)$1 + "' not found.");}; 
			}
  | IDENT '.' UNLOCK_LOCS ';' // unlock the partitioning flag of all locations 
      { 
				if (pautmap.find($1)!=pautmap.end())
					pautmap[$1]->unlock_locations();
				else
					{yyerror("Automaton '" + (string)$1 + "' not found.");}; 
			}			
  | IDENT '.' SET_DHR_VARS 
      { 
				psymb_state=NULL;
				if (pautmap.find($1)!=pautmap.end())
					paut=pautmap[$1];
				else
					{yyerror("Automaton '" + (string)$1 + "' not found.");}; 
			}			
		'(' clock_ref_list ';' clock_ref_list ')' ';'
			{
				set_REFINE_DHR_VARS(*$6,*$8);
				delete $6; delete $8;
			}

  | IDENT '.' REACH_GRAPH '(' STRING_TEXT ',' IDENT ')' ';' 
      { 
		if(pautmap.find($1)!=pautmap.end())
		{
			paut = pautmap[$1];
			if(sstatesmap.find($7)!=sstatesmap.end())
			{
                  		symb_states_type dummystates;
                  		bool dummybool;
				paut->get_reach_set(paut->ini_states, dummystates, dummybool, sstatesmap[$7].first, (string)$5);
			}
			else yyerror("Unknown identifier '" + (string)$7 +"'."); 
		}
		else yyerror("Automaton '" + (string)$1 +"' not found."); 
      }
  ;

clock_ref_list:
  IDENT {
			if (psymb_state!=NULL)
			{
				pcrs = new clock_ref_set;
//cout << psymb_state->var_names;
				if (psymb_state->var_names.contains_name((string)$1))
				{
					pcrs->insert(psymb_state->var_names.get_id((string)$1));
					$$=pcrs;
				}
				else
				{ 
					yyerror("Unknown state variable '" + (string)$1 +"'."); delete pcrs; $$=NULL; 
				}; 
			}
			else if (paut!=NULL)
			{
				pcrs = new clock_ref_set;
				if (paut->var_id_map.contains_name((string)$1))
				{
					pcrs->insert(paut->var_id_map.get_id((string)$1));
					$$=pcrs;
				}
				else
				{ 
					yyerror("Unknown automaton variable '" + (string)$1 +"'."); delete pcrs; $$=NULL; 
				}; 
			}
			else 
				yyerror("Don't know which set of states '" + (string)$1 +"' refers to."); 
		}
  | clock_ref_list ',' IDENT {
			if (psymb_state!=NULL)
			{
				if (psymb_state->var_names.contains_name((string)$3))
				{
					$1->insert(psymb_state->var_names.get_id((string)$3));
					$$=$1;
				}
				else
				{ 
					yyerror("Unknown state variable '" + (string)$3 +"'."); 
				}; 
			}
			else if (paut!=NULL)
			{
				if (paut->var_id_map.contains_name((string)$3))
				{
					$1->insert(paut->var_id_map.get_id((string)$3));
					$$=$1;
				}
				else
				{ 
					yyerror("Unknown automaton variable '" + (string)$3 +"'."); 
				}; 
			}
			else
				yyerror("Don't know which set of states '" + (string)$3 +"' refers to."); 
		}
	;

// gf 06-03-22 use composed_aut as a list of names, and compose when used  
// gf 07-01-12 define as >1 automaton to avoid ambiguities
composed_aut: composed_aut '&' IDENT  {$$->push_back((string)$3);}
						| IDENT '&' IDENT {$$ = new list<string>; 
						         $$->push_back((string)$1);
                           $$->push_back((string)$3); }
						;	   
/*composed_aut:
  IDENT '&' IDENT
		{ 
			if (pautmap.find($1)!=pautmap.end())
			{
				if (pautmap.find($3)!=pautmap.end())
				{
					paut=new automaton; 
					compose_discrete(*paut,*pautmap[$1],*pautmap[$3]); 
					$$=paut;
					// pautmap[paut->name]=paut;
				}
				else
				{ 
					yyerror("Unknown automaton '" + (string)$3 +"'."); 
				}; 				}
      else
      { 
				yyerror("Unknown automaton '" + (string)$1 +"'."); 
			}; 
		}
  | composed_aut '&' IDENT 
		{ 
			if (pautmap.find($3)!=pautmap.end())
			{
				paut=new automaton; 
				compose_discrete(*paut,*$1,*pautmap[$3]); 
				$$=paut; // delete $1;
				pautmap[paut->name]=paut;
			}
      else
      { 
				yyerror("Unknown automaton '" + (string)$3 +"'."); 
			}; 	
		}*/
/*  | '[' composed_aut ']' 
			{ 
				paut=new automaton(*$2); 
				paut->assign_tts(); 
				pautmap[paut->name+"_TTS"]=paut;
				$$=paut; 
			} */
  ;

prelim:
  IDENT ASSIGN linearexpr ';' { linexmap[(string)$1]=*$3; delete $3; }
  | par_DHR_THRESHOLD '=' linearexpr ';' { set_DHR_THRESHOLD_PHAVER($3->rat_inhomogeneous_term()); delete $3; }
        // Note: here macros of the form xcon:x==1 could be accepted, only that x is not a global variable and depends on the automaton
  | par_ELAPSE_TIME '=' bool_type ';'  { ELAPSE_TIME=$3; }
	| par_TIME_POST_ITER '=' INT ';' { TIME_POST_ITER=atoi($3); }
	| par_TIME_POST_CONE_ITER '=' INT ';' { TIME_POST_CONE_ITER=atoi($3); }
//  | par_TIME_POST_LAMBDA '=' linearexpr ';' { set_TIME_POST_LAMBDA($3->rat_inhomogeneous_term()); delete $3; }
  | par_TIME_POST_LAMBDA '=' linearexpr ';' { TIME_POST_LAMBDA=($3->rat_inhomogeneous_term()); delete $3; }
  | par_MEMORY_MODE '=' INT ';'  { MEMORY_MODE=atoi($3); }
  
// Reachability
  | par_CREATION_GRAPH_OUTPUT '=' bool_type ';'  { CREATION_GRAPH_OUTPUT=$3; }
  | par_CHEAP_CONTAIN_RETURN_OTHERS '=' bool_type ';'  { CHEAP_CONTAIN_RETURN_OTHERS=$3; }
  | par_USE_CONVEX_HULL '=' bool_type ';'  { USE_CONVEX_HULL=$3; }
  | par_USE_CONSTRAINT_HULL '=' bool_type ';'  { USE_CONSTRAINT_HULL=$3; }
  | par_REACH_STOP_AT_FORB '=' bool_type ';'  { REACH_STOP_AT_FORB=$3; }
  | par_REACH_ONLY_EXPLORE '=' bool_type ';'  { REACH_ONLY_EXPLORE=$3; }
  | par_REACH_USE_BBOX '=' bool_type ';'  { REACH_USE_BBOX=$3; }
  | par_REACH_MAX_ITER '=' INT ';'  { REACH_MAX_ITER=atoi($3); }
  | par_REACH_MAX_ITER '=' '-' INT ';'  { REACH_MAX_ITER=-atoi($4); }
  | par_REACH_USE_BBOX_ITER '=' INT ';'  { REACH_USE_BBOX_ITER=atoi($3); }
  | par_REACH_STOP_USE_CONVEX_HULL_ITER '=' INT ';'  { REACH_STOP_USE_CONVEX_HULL_ITER=atoi($3); }	
  | par_REACH_STOP_USE_BITSIZE '=' INT ';'  { REACH_STOP_USE_BITSIZE=atoi($3); }	
  | par_REACH_STOP_USE_CONVEX_HULL_SETTLE '=' bool_type ';'  { REACH_STOP_USE_CONVEX_HULL_SETTLE=$3; }
	| par_BOUND_BOX_BITSIZE '=' INT ';'  { BOUND_BOX_BITSIZE=atoi($3); }
	| par_CONSTRAINT_BITSIZE '=' INT ';'  { CONSTRAINT_BITSIZE=atoi($3); }
  | par_LIMIT_CONSTRAINTS_METHOD '=' bool_type ';'  { LIMIT_CONSTRAINTS_METHOD=$3; }
	| par_REFINE_DERIVATIVE_METHOD '=' INT ';'  { REFINE_DERIVATIVE_METHOD=atoi($3); }
  | par_REFINE_PRIORITIZE_REACH_SPLIT '=' bool_type ';'  { REFINE_PRIORITIZE_REACH_SPLIT=$3; }
  | par_REFINE_SMALLEST_FIRST '=' bool_type ';'  { REFINE_SMALLEST_FIRST=$3; }
  | par_REFINE_USE_FP '=' bool_type ';'  { REFINE_USE_FP=$3; }
	| par_REFINE_DERIV_MINANGLE '=' linearexpr ';'  { REFINE_DERIV_MINANGLE=$3->rat_inhomogeneous_term().get_d(); delete $3; }
  | par_REFINE_PRIORITIZE_ANGLE '=' bool_type ';'  { REFINE_PRIORITIZE_ANGLE=$3; }
	| par_REACH_CONSTRAINT_LIMIT '=' INT ';' { REACH_CONSTRAINT_LIMIT=atoi($3); }
	| par_TP_CONSTRAINT_LIMIT '=' INT ';' { TP_CONSTRAINT_LIMIT=atoi($3); }
	| par_REACH_CONSTRAINT_TRIGGER '=' INT ';' { REACH_CONSTRAINT_TRIGGER=atoi($3); }
	| par_REACH_BITSIZE_TRIGGER '=' INT ';' { REACH_BITSIZE_TRIGGER=atoi($3); }
	| par_SEARCH_METHOD '=' INT ';' { SEARCH_METHOD=atoi($3); }
	| par_SEARCH_METHOD '=' '-' INT ';' { SEARCH_METHOD=-atoi($4); }
	| par_SNAPSHOT_INTERVAL '=' INT ';' { SNAPSHOT_INTERVAL=atoi($3); }
// Refinement
	| par_REFINE_CHECK_TIME_RELEVANCE '=' bool_type ';' { REFINE_CHECK_TIME_RELEVANCE=$3; }
	| par_REFINE_CHECK_TIME_RELEVANCE_DURING '=' bool_type ';' { REFINE_CHECK_TIME_RELEVANCE_DURING=$3; }
	| par_REFINE_CHECK_TIME_RELEVANCE_FINAL '=' bool_type ';' { REFINE_CHECK_TIME_RELEVANCE_FINAL=$3; }
	| par_REFINE_CHECK_TRANS_DIMS'=' bool_type ';' { REFINE_CHECK_TRANS_DIMS=$3; }
	| par_REFINE_PARTITION_INSIDE '=' bool_type ';' { REFINE_PARTITION_INSIDE=$3; }
	| par_REACH_FB_REFINE_METHOD '=' INT ';' { REACH_FB_REFINE_METHOD=atoi($3); }	
	| par_REFINE_INTERSECT_METHOD '=' INT ';' { REFINE_INTERSECT_METHOD=atoi($3); }
	| par_REFINE_LOCATION_PLANE '=' INT ';' { REFINE_LOCATION_PLANE=atoi($3); }
	| par_REFINE_MAX_CHECKS '=' INT ';' { REFINE_MAX_CHECKS=atoi($3); }
	
// Simulation 
  | par_USE_CONVEX_HULL_FOR_PRIMING '=' bool_type ';'  { USE_CONVEX_HULL_FOR_PRIMING=$3; }
  | par_PRIME_R_WITH_REACH '=' bool_type ';'  { PRIME_R_WITH_REACH=$3; }
	| par_PRIME_R_WITH_DISCRETE_REACH '=' bool_type ';' { PRIME_R_WITH_DISCRETE_REACH=$3; }
  | par_SHOW_BAD_STATES '=' bool_type ';'  { SHOW_BAD_STATES=$3; }
	| par_SIM_SIMPLIFY_R '=' bool_type ';'  { SIM_SIMPLIFY_R=$3; }
// Minimization
  | par_MINIM_USE_CONVEX_HULL_FOR_PRIMING '=' bool_type ';'  { MINIM_USE_CONVEX_HULL_FOR_PRIMING=$3; }
  | par_MINIM_PRIME_R_WITH_REACH '=' bool_type ';'  { MINIM_PRIME_R_WITH_REACH=$3; }
// Composition
  | par_COMPOSE_WITH_REACH_MIN '=' bool_type ';'  { COMPOSE_WITH_REACH_MIN=$3; }
  | par_COMPOSE_USE_CONVEX_HULL_FOR_REACH   '=' bool_type ';'  { COMPOSE_USE_CONVEX_HULL_FOR_REACH=$3; }
  | par_USE_HIOA_AUTOMATA   '=' bool_type ';'  { USE_HIOA_AUTOMATA=$3; }
  | par_COMPOSE_STOP_AT_ERROR '=' bool_type ';'  { STOP_COMPOSE_AT_ERROR = $3; }
  ;

bool_type:
  TRUE { $$=true; }
  | FALSE { $$=false; }
  ;

automaton:
	AUTOMATON IDENT {paut=new automaton($2); pautmap[$2]=paut; } automaton_body END //{paut->print(); cout << flush;}
   {
      if (USE_HIOA_AUTOMATA)
         paut->add_environment_transitions();
   }
	;


automaton_body:
	declaration location_list initial
		;

declaration:
	// empty
   | declaration priority 
   | declaration internal_vars 
   | declaration external_vars 
   | declaration synclab
   | declaration parameters 
	;

priority:
	PRIORITY ':' linearexpr ';' 
      {
         paut->priority=($3->rat_inhomogeneous_term().get_int()); delete $3;
      }
   ;
      
synclab:
	SYNCLABS ':' ident_list ';' 
      {
         if (paut != NULL)
         {
            for (list<string>::const_iterator i=$3->begin();i!=$3->end();++i)
            {
               paut->add_label(*i);
            }
            delete $3;
         }
         else
            yyerror("synclabs: paut not defined");
      }
	;

internal_vars:
	INTERNAL_VAR ':' ivar_list ';'
	;

external_vars:
	EXTERNAL_VAR ':' evar_list ';'
	;

parameters:
	PARAMETER ':' param_list ';'
	;

ivar_list: ivar_list ',' IDENT { paut->add_variable((string)$3); }
				| IDENT { paut->add_variable((string)$1); }
				;

evar_list: evar_list ',' IDENT { paut->add_ext_variable((string)$3); }
				| IDENT { paut->add_ext_variable((string)$1); }
				;

param_list: param_list ',' IDENT { paut->add_parameter((string)$3); }
				| IDENT { paut->add_parameter((string)$1); }
				;

ident_list: ident_list ',' IDENT  
                        {
                           $$->push_back((string)$3);
                           delete $3;
                        }
						| IDENT 
                        {
                           $$ = new list<string>; 
						         $$->push_back((string)$1);
                           delete $1;
                        }
                  |  ident_list ',' IDENT '{' ident_list '}'  
                        {  
                           for (list<string>::const_iterator it=$5->begin();it!=$5->end();++it)
                           {
                              $$->push_back((string)$3 + *it);
                           }
                           delete $3;
                           delete $5;
                        }
                  |  IDENT '{' ident_list '}'  
                        {  
                           $$ = new list<string>; 
                           for (list<string>::const_iterator it=$3->begin();it!=$3->end();++it)
                           {
                              $$->push_back((string)$1 + *it);
                           }
                           delete $1;
                           delete $3;
                        }
						;						
						
initial:
//  INITIALLY ':' state_list ';' { paut->ini_states=*$3; paut->ini_states.var_names_assign(paut->get_var_names()); delete $3;}
//  | INITIALLY state_list ';' { paut->ini_states=*$2; paut->ini_states.var_names_assign(paut->get_var_names()); delete $2; }
  INITIALLY ':' state_list ';' { 
		paut->ini_states_assign(*$3); 
  		delete $3;}
  | INITIALLY state_list ';' { paut->ini_states_assign(*$2); delete $2; }
	; 

state_list:
  IDENT '&' val_set
      { 
				if (paut != NULL)
				{
					psymb_state = new symb_states_type(paut->get_var_names());
//   				if (paut->loc_name_to_loc_ref_map.find((string)$1)!=paut->loc_name_to_loc_ref_map.end())
					psymb_state->add((string)$1,*$3);
					delete $3;
					$$=psymb_state; 
				}
				else
					yyerror("Don't know which automaton to attribute states to.");
		}
  | state_list ',' IDENT '&' val_set
      { 
				if (paut != NULL)
				{
					psymb_state->add((string)$3,*$5);
					delete $5;
					$$=psymb_state; 
				}
				else
					yyerror("Don't know which automaton to attribute states to.");
		}
		
  ;

location_list:
    location_list location transition_list
  | location_list location ';' transition_list
	| location transition_list
	| location ';' transition_list
	;

	
location: LOC IDENT ':' WHILE val_set WAIT '{' constr_list '}'  
		{ 
			// gf 2006-02-15 : use primed variables as derivatives
//			paut->add_location(*$5,(string)$2,*$8; delete $5; delete $8;
			(*$8).dimension_move_assign(0,(paut->dim)-1,paut->dim);
			paut->add_location(*$5,(string)$2,*$8); 
			delete $5; delete $8;
      	current_loc_name=(string)$2; // will serve as the source location for the coming transitions
      }
	;

transition_list: transition_list transition
  |
  ;
  
transition:
    // NOTE: ident_list semantics: add a transition for each label in the ident_list;
    WHEN val_set SYNC ident_list DO '{' val_set '}' GOTO IDENT ';'
      { 
			for (list<string>::const_iterator i=$4->begin();i!=$4->end();++i)
			{
				paut->add_transition(current_loc_name,*i,*$2,*$7,(string)$10); 
			};
			delete $4;
		}
  | WHEN val_set DO '{' val_set '}' SYNC ident_list GOTO IDENT ';'
      { //paut->add_transition(current_loc_name,(string)$8,*$2,*$5,(string)$10); 
			for (list<string>::const_iterator i=$8->begin();i!=$8->end();++i)
			{
				paut->add_transition(current_loc_name,*i,*$2,*$5,(string)$10); 
			};
			delete $8;
		}
  | WHEN val_set SYNC ident_list GOTO IDENT ';'
      { 
				// paut->add_transition(current_loc_name,(string)$4,*$2,clock_ref_set(),(string)$6); // format ...,guard,mudest,... dimensions don't matter
			mycvs=clock_val_set(paut->dim*2);
				// add constraints that controlled variables remain constant
			for (clock_ref_set::const_iterator i=paut->variables.begin();i!=paut->variables.end();++i)
			{ mycvs.add_constraint(Variable(*i)==Variable(*i+paut->dim)); };
			
			for (list<string>::const_iterator i=$4->begin();i!=$4->end();++i)
			{
				paut->add_transition(current_loc_name,*i,*$2,mycvs,(string)$6); 
			};
			delete $4;			
		}
  |  WHEN val_set ASAP SYNC ident_list DO '{' val_set '}' GOTO IDENT ';'
      { 
			for (list<string>::const_iterator i=$5->begin();i!=$5->end();++i)
			{
				trans_ref=paut->add_transition(current_loc_name,*i,*$2,*$8,(string)$11); 
            if (trans_ref<paut->transitions.size())
               paut->transitions[trans_ref].set_urgent();
			};
			delete $5;
		}
  | WHEN val_set ASAP DO '{' val_set '}' SYNC ident_list GOTO IDENT ';'
      { //paut->add_transition(current_loc_name,(string)$8,*$2,*$5,(string)$10); 
			for (list<string>::const_iterator i=$9->begin();i!=$9->end();++i)
			{
				trans_ref=paut->add_transition(current_loc_name,*i,*$2,*$6,(string)$11); 
            if (trans_ref<paut->transitions.size())
               paut->transitions[trans_ref].set_urgent();
			};
			delete $9;			
		}
  | WHEN val_set ASAP SYNC ident_list GOTO IDENT ';'
      { 
				// paut->add_transition(current_loc_name,(string)$4,*$2,clock_ref_set(),(string)$6); // format ...,guard,mudest,... dimensions don't matter
			mycvs=clock_val_set(paut->dim*2);
				// add constraints that controlled variables remain constant
			for (clock_ref_set::const_iterator i=paut->variables.begin();i!=paut->variables.end();++i)
			{ mycvs.add_constraint(Variable(*i)==Variable(*i+paut->dim)); };
			
			for (list<string>::const_iterator i=$5->begin();i!=$5->end();++i)
			{
				trans_ref=paut->add_transition(current_loc_name,*i,*$2,mycvs,(string)$7); 
            if (trans_ref<paut->transitions.size())
               paut->transitions[trans_ref].set_urgent();
			};
			delete $5;			
		}
  | WHEN val_set SYNC ident_list PALT '{' probabilistic_alternative_list '}' ';'
	{
		for (list<string>::const_iterator label = $4->begin(); label != $4->end(); ++label)
		{
			paut->add_transitions_from_distribution(current_loc_name, *label, *$2, *$7);
		}
		delete $4;
		delete $7;
	}
;

probabilistic_alternative_list:
    probabilistic_alternative_list ',' probabilistic_alternative
	{
		$1->push_back(*$3);
		delete $3;
	}
  | probabilistic_alternative
	{
		$$ = new list<prob_alt>;
		$$->push_back(*$1);
		delete $1;
	}
;

probabilistic_alternative:
    INT ':' DO '{' val_set '}' GOTO IDENT
	{
		$$ = new prob_alt(atoi($1), *$5, (string)$8);
	}
  | INT ':' GOTO IDENT
	{
		mycvs = clock_val_set(paut->dim * 2);
		for(clock_ref_set::const_iterator i = paut->variables.begin(); i != paut->variables.end(); ++i)
		{ 
			mycvs.add_constraint(Variable(*i) == Variable(*i + paut->dim)); 
		}
		$$ = new prob_alt(atoi($1), mycvs, (string)$4);
	}
;

constraint_rat_pair_list:
	constraint_rat_pair_list ',' constraint_rat_pair
		{ $1->push_back(*$3); delete $3;}
	| constraint_rat_pair
		{ $$=new list<ConstraintRatPair>; $$->push_back(*$1); delete $1; }
	;
	
constraint_rat_pair: 
  '(' linearexpr ',' linearexpr ')' 
		{ 
			$$= new ConstraintRatPair(0*Variable(paut->dim-1)+(Linear_Expression)(*$2)>=0,make_pair($4->rat_inhomogeneous_term()*Rational($2->denominator),Rational(0))); 
			delete $2; 
			delete $4; 
		}
	|  '(' linearexpr ',' linearexpr ',' linearexpr ')' 
		{ 
			$$= new ConstraintRatPair(0*Variable(paut->dim-1)+(Linear_Expression)(*$2)>=0,make_pair(Rational($2->denominator)*($4->rat_inhomogeneous_term()),Rational($2->denominator)*($6->rat_inhomogeneous_term()))); 
			delete $2; 
			delete $4; 
			delete $6; 
		}
	;
	

val_set:
/*	val_set '&' val_set
		{
			$1->intersection_assign(*($3),true); 
			$$=$1; 
			delete $3;
		}
	|	constraint
		{ // cout << "con: " << endl << *$1 << endl << flush;
			pcvs = new clock_val_set(convex_clock_val_set(*$1));$$=pcvs;
			delete $1;
		}*/
      
	  val_set '|' val_set
		{$1->union_assign(*($3)); $$=$1; delete $3;}
	| val_set '&' val_set
		{$1->intersection_assign(*($3)); $$=$1; delete $3;}
      
/*
	  val_set '|' constr_list
		{$1->union_assign(clock_val_set(convex_clock_val_set(*$3,$3->space_dimension()))); $$=$1; delete $3;}
	| val_set '&' constr_list
		{$1->intersection_assign(clock_val_set(convex_clock_val_set(*$3,$3->space_dimension()))); $$=$1; delete $3;}
*/     
   | '!' val_set {$2->negate(); $$=$2;}
	| '(' val_set ')' {$$=$2;}
	| constr_list_no_and
		{ // cout << "con: " << endl << *$1 << endl << flush;
			pcvs = new clock_val_set(convex_clock_val_set(*$1,$1->space_dimension()));$$=pcvs;
			delete $1;
		}
	;


constr_list:
	constr_list '&' constr_list
	{ $1->union_assign(*$3); delete $3; $$=$1; }
   // | '(' constr_list ')' {$$=$2;}
   | constr_list_no_and;

constr_list_no_and:
   constraint
	{ $$ = new Constraint_List((dimension_type)(2*paut->dim)); $$->push_back(*$1); delete $1; }
   | linearexpr LE linearexpr LE linearexpr	{
         $$ = new Constraint_List((dimension_type)(2*paut->dim)); 
         $$->push_back(Constraint(0*Variable(paut->dim-1)+($3->denominator)*(Linear_Expression)(*($1))<=($1->denominator)*(Linear_Expression)(*($3)))); 
         $$->push_back(Constraint(0*Variable(paut->dim-1)+($5->denominator)*(Linear_Expression)(*($3))<=($3->denominator)*(Linear_Expression)(*($5)))); 
         delete $1; 
         delete $3; 
         delete $5; 
			}   
   | linearexpr '<' linearexpr LE linearexpr	{
         $$ = new Constraint_List((dimension_type)(2*paut->dim)); 
         $$->push_back(Constraint(0*Variable(paut->dim-1)+($3->denominator)*(Linear_Expression)(*($1))<($1->denominator)*(Linear_Expression)(*($3)))); 
         $$->push_back(Constraint(0*Variable(paut->dim-1)+($5->denominator)*(Linear_Expression)(*($3))<=($3->denominator)*(Linear_Expression)(*($5)))); 
         delete $1; 
         delete $3; 
         delete $5; 
			}   
   | linearexpr LE linearexpr '<' linearexpr	{
         $$ = new Constraint_List((dimension_type)(2*paut->dim)); 
         $$->push_back(Constraint(0*Variable(paut->dim-1)+($3->denominator)*(Linear_Expression)(*($1))<=($1->denominator)*(Linear_Expression)(*($3)))); 
         $$->push_back(Constraint(0*Variable(paut->dim-1)+($5->denominator)*(Linear_Expression)(*($3))<($3->denominator)*(Linear_Expression)(*($5)))); 
         delete $1; 
         delete $3; 
         delete $5; 
                        }
   | linearexpr '<' linearexpr '<' linearexpr	{
         $$ = new Constraint_List((dimension_type)(2*paut->dim)); 
         $$->push_back(Constraint(0*Variable(paut->dim-1)+($3->denominator)*(Linear_Expression)(*($1))<($1->denominator)*(Linear_Expression)(*($3)))); 
         $$->push_back(Constraint(0*Variable(paut->dim-1)+($5->denominator)*(Linear_Expression)(*($3))<($3->denominator)*(Linear_Expression)(*($5)))); 
         delete $1; 
         delete $3; 
         delete $5; 
			}            	
   ;
   
   
constraint:
	 linearexpr '<' linearexpr	{
			pcon= new Constraint(0*Variable(paut->dim-1)+($3->denominator)*(Linear_Expression)(*($1))<($1->denominator)*(Linear_Expression)(*($3))); 
			$$=pcon; delete $1; delete $3; // cout << endl << *pcon << endl << flush;
			}
	| linearexpr '>' linearexpr	{
			pcon= new Constraint(0*Variable(paut->dim-1)+($3->denominator)*(Linear_Expression)(*($1))>($1->denominator)*(Linear_Expression)(*($3))); 
			$$=pcon; delete $1; delete $3; // cout << endl << *pcon << endl << flush;
			}
	| linearexpr GE linearexpr	{
			pcon= new Constraint(0*Variable(paut->dim-1)+($3->denominator)*(Linear_Expression)(*($1))>=($1->denominator)*(Linear_Expression)(*($3))); 
			$$=pcon; delete $1; delete $3; // cout << endl << *pcon << endl << flush;
			}
	| linearexpr LE linearexpr	{
			pcon= new Constraint(0*Variable(paut->dim-1)+($3->denominator)*(Linear_Expression)(*($1))<=($1->denominator)*(Linear_Expression)(*($3))); 
			$$=pcon; delete $1; delete $3; // cout << endl << *pcon << endl << flush;
			}
	| linearexpr EQ linearexpr	{
			pcon= new Constraint(0*Variable(paut->dim-1)+($3->denominator)*(Linear_Expression)(*($1))==($1->denominator)*(Linear_Expression)(*($3))); 
			$$=pcon; delete $1; delete $3; // cout << endl << *pcon << endl << flush;
			}
	| TRUE
    {pcon= new Constraint(0*Variable(paut->dim-1)==0*Variable(paut->dim-1)); $$=pcon;}
	| FALSE
    {pcon= new Constraint(0*Variable(paut->dim-1)<=1*Variable(paut->dim-1)); $$=pcon;}
	;


linearexpr:
//	INT			{plinexp = new Rational_Linear_Expression(atoi($1));$$=plinexp;}
	INT			
			{
				plinexp = new Rational_Linear_Expression((string)$1);$$=plinexp; //cout << "INT: "<< *plinexp << endl;
			}	
	| IDENT PRIM
	 		{ 
			//plinexp = new Rational_Linear_Expression(0*Variable(paut->dim*2-1)+Variable(paut->dim+paut->clock_name_to_clock_ref_map[(string)$1]));
	   	//$$=plinexp; 
			  		if (paut->var_id_map.contains_name((string)$1))
          		{
            		plinexp = new Rational_Linear_Expression(Linear_Expression(0*Variable(paut->dim*2-1)+Variable(paut->dim+paut->var_id_map.get_id((string)$1))));
  	   	    		$$=plinexp;
          		}
          		else
          		{
            		yyerror("Either variable " + (string)$1 +" not defined in automaton " + paut->name + ", or undefined shortcut.");
          		};
			}
	| IDENT
	 		{ 
				if (linexmap.find((string)$1)==linexmap.end())
           	{ 
			  		if (paut!=NULL && paut->var_id_map.contains_name((string)$1))
          		{
            		plinexp = new Rational_Linear_Expression(Linear_Expression(0*Variable(paut->dim-1)+Variable(paut->var_id_map.get_id((string)$1))));
  	   	    		$$=plinexp;
          		}
          		else
          		{
                  if (paut!=NULL)
               		yyerror("Either variable " + (string)$1 +" not defined in automaton " + paut->name + ", or undefined shortcut.");
                  else
               		yyerror("Can't identify \"" + (string)$1 +"\".");
          		};
        		}
        		else
        		{ 
//				  plinexp = new Rational_Linear_Expression(Rational_Linear_Expression(Linear_Expression(0*Variable(paut->dim-1)))+linexmap[(string)$1]);
					plinexp = new Rational_Linear_Expression(linexmap[(string)$1]);
          		$$=plinexp;
        		};
      	}
	| linearexpr '*' linearexpr
      { if (attempt_multiply(*($1),*($3)))
          { $$=$1; delete $3;}
        else
				{
          yyerror("Can not multiply two linear expressions. ");
					cout << *($1) << " and " << *($3) << endl;
				};
      }
	| linearexpr '/' linearexpr
      { if (attempt_division(*($1),*($3)))
          { $$=$1; delete $3;}
        else
          yyerror("Can not divide two linear expressions.");
      }
	| linearexpr '+' linearexpr		{plinexp = new Rational_Linear_Expression((*($1))+(*($3)));$$=plinexp; //cout << "l+l:(" << *$1 << ")-(" << *$3 << ")=" << *plinexp << endl;
 delete $1; delete $3;}
	| linearexpr '-' linearexpr		{plinexp = new Rational_Linear_Expression((*($1))-(*($3)));$$=plinexp; //cout << "l-l:(" << *$1 << ")-(" << *$3 << ")=" << *plinexp << endl;
 delete $1; delete $3;}
	| '-' linearexpr	%prec  '*'
			{ 
				// plinexp = new Rational_Linear_Expression(Rational_Linear_Expression(Integer(0))-(*($2)));$$=plinexp; delete $2;}
				$2->Linear_Expression::operator=(-(Linear_Expression)*$2); $$=$2; //cout << "-l: " << *$$ << endl;
			}
	| '(' linearexpr ')' 
			{
				$$=$2; 
				// cout << endl << *$2 << endl;
			}
	;

%%

