/***************************************************************************
                          symb_states_type.cpp  -  description
                             -------------------
    begin                : Thu Feb 5 2004
    copyright            : (C) 2004 by Goran Frehse
    email                : goran.frehse@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "symb_states_type.h"
 
string location_name_unrefined(const string& l1)
{
  return string_before(l1,"@");
}

bool location_name_compare_wildcard(const string& l1, const string& l2) 
{
	// return true if *this == l taking account of to wildcards
	// a wildcard "$" stands for any arbitrary number of characters

	// todo!!!!!!!!!!!!!
	// for now: exact comparison
	//return l1==l2;
	
	return wildcmp(l1, l2); 
}

bool location_name_contains(const string& l1, const string& l2) 
{
  // returns whether l2 is contained semantically in l1
	// return true if l1 == l2 up to the "@" (considering wildcards)
	// and l1 + @ == l2[0...len(this) (considering the string after the first @)
	
	if (location_name_compare_wildcard(string_before(l1,"@"),string_before(l2,"@"))) // the part before @ is the same
	{
		// either they are identical
		string m1(string_after(l1,"@"));
		string m2(string_after(l2,"@"));
//cout << m1 << "," << m2 << endl;		
		if (m2.length()<m1.length())
			return false;
		else if (m2.length()==m1.length())
			if (m1==m2)
				return true;
			else
				return false;
		else if (m1=="" || m1+"@"==m2.substr(0,m1.length()+1))
			return true;
		else
			return false;
	}
	else
		return false;
}

string location_name_intersection(const string& l1, const string& l2) 
{
	// todo!!!!!!!!!!!!!!!!!
	// for now: return the one that is more restrictive, i.e., that is contained by the other
	
	// returns the empty string if the intersection is empty
	if (location_name_contains(l1,l2))
		return l2;
	else if (location_name_contains(l2,l1))
		return l1;
	else
		return "";
}

symb_states_type::symb_states_type(): var_names_uptodate(false) {}
//symb_states_type::symb_states_type() {}

symb_states_type::symb_states_type(const variable_id_map& vn_vec): var_names_uptodate(true), var_names(vn_vec) 
{
}

int 
symb_states_type::get_memory() const
{
   int res=0;
  
  symb_states_type::const_iterator i=begin();
  while (i!=end())
  {
    res+=i->second.get_memory();
    ++i;
  };   
  
  return res;
}
   

symb_states_type& 
symb_states_type::operator=(const symb_states_type& s)
{
	map<location_ref, clock_val_set>::operator=(s);
	loc_names=s.loc_names;
	var_names=s.var_names;
	var_names_uptodate=s.var_names_uptodate;
}

const string& 
symb_states_type::get_loc_name(const location_ref& loc) const
{
	loc_names_map::const_iterator loc_it(loc_names.find(loc));
	if (loc_it!=loc_names.end())
	{
		return loc_it->second;
	}
	else
	{
		throw_error("symb_states_type::get_loc_name: cannot find location name for " + int2string(loc));
		return loc_names.begin()->second;
	};
}

location_ref 
symb_states_type::get_or_add_location_ref(const string& s)
{
	// find location with name s, and add it if it does not exist
	loc_names_map::const_iterator loc_it(loc_names.begin());
	while (loc_it != loc_names.end() && loc_it->second != s)
		++loc_it;

	// if it wasn't found
	if (loc_it == loc_names.end())
	{
		// make up a new location_ref
		location_ref loc=rand();
		// test that it doesn't already exist
		while (loc_names.find(loc)!=loc_names.end())
			loc=rand();
			
		loc_names[loc]=s;
		return loc;
	};
	return loc_it->first;
}


void symb_states_type::var_names_assign(const variable_id_map& vn_vec)
{
  var_names=vn_vec;
  var_names_uptodate=true;
}

// void symb_states_type::var_names_assign(const variable_id_map vn_vec)
// {
//   var_names=vn_vec;
//   var_names_uptodate=true;
// }

void symb_states_type::loc_names_assign(const loc_names_map& l_names)
{
  loc_names=l_names;
}

void 
symb_states_type::map_locations(const loc_names_map& l_names)
{
	// for each element of *this, produce a replica for each name in l_names that matches
	// if there is no match, throw an exception
	
	symb_states_type result;
	result.loc_names_assign(l_names);
	result.var_names=var_names;
	result.var_names_uptodate=var_names_uptodate;
	string ln;
	
	symb_states_type::const_iterator it=begin();
	loc_names_map::const_iterator jt=l_names.begin();
	bool matched(false);
	while (it!=end())
	{
		ln = get_loc_name(it->first);
		
		matched=false;
		jt=l_names.begin();
		while (jt!=l_names.end())
		{
			// if ln contains jt->second or vice versa, add it
			if (location_name_contains(ln,jt->second) || location_name_contains(jt->second,ln))
         {
				result.add(jt->first,it->second);
            matched=true;
         }
			++jt;
		};
      if (!matched)
         throw_error("symb_states_type::map_locations: could not find match for location \""+ln+"\".");
		++it;
	};
	
	*this=result;
}

void 
symb_states_type::map_variables(const variable_id_map& v_names)
{

	if (var_names_uptodate)
	{
      if (var_names != v_names) // otherwise it's superfluous
      {
         bool remap_necessary=false;
         variable_id_map new_var_names;
         PFunction pfunc,pfunc1;
         dimension_type newdim;
            // build variable maps		
            get_common_var_names(v_names, var_names, new_var_names, pfunc1, pfunc, newdim);	
      
            var_names=new_var_names;	
            
         symb_states_type::iterator it=begin();
         while (it!=end()) 
         {   
            it->second.add_space_dimensions_and_embed(newdim-it->second.dim);
            it->second.map_space_dimensions(pfunc);
            ++it;
         }
     }
	}
   else
   {
      throw_error("symb_states_type::map_variables : var_names not up to date");
   };
}

clock_val_set
symb_states_type::add(const location_ref& loc, const clock_val_set& cvs)
{
  // add cvs to reach set and process only the new bits
  // must use if case since otherwise reach_set[loc] is initialized with the default constructor,
  // which is a) universal and b) of dimension 1. Both are wrong in this case.
	
	// assumes the location_ref already exists
  if (find(loc)!=end())
  {
//          cvs=(*this)[loc].disj_union_assign(cvs);
      return (*this)[loc].append(cvs); // new gf
//      (*this)[loc].union_assign_nocheck(cvs); // new gf
  }
  else
    (*this)[loc]=cvs;
  return cvs;
}

clock_val_set 
symb_states_type::add(const string& loc_name, const location_ref& loc, const clock_val_set& cvs) // creates a new location_ref
{
	// find name in loc_names
	//loc_names_map::const_iterator it(loc_names.find(loc_name));
	
	// find location with name loc_name, and check if it refers to location_ref loc
	loc_names_map::const_iterator loc_it(loc_names.begin());
	while (loc_it != loc_names.end() && loc_it->second != loc_name)
		++loc_it;

	// if it wasn't found
	if (loc_it == loc_names.end() || loc_it->first==loc)
	{
		// check if loc references to a different name
		// test that it doesn't already exist
		if (loc_names.find(loc)==loc_names.end() || loc_names.find(loc)->second==loc_name)
		{
			loc_names[loc]=loc_name;
			add(loc,cvs);
		};
		return cvs;
	};
	
	throw_error("symb_states_type::add: inconsistency between loc_name " + loc_name + " and location_ref " + int2string(loc));
	
	return cvs;
}

clock_val_set 
symb_states_type::add(const string& loc_name, const clock_val_set& cvs) // creates a new location_ref
{
	// find name in loc_names
	//loc_names_map::const_iterator it(loc_names.find(loc_name));
	
	add(get_or_add_location_ref(loc_name),cvs);
	
	return cvs;
}

void
symb_states_type::remove_empty()
{
  // remove the empty ones
  symb_states_type::iterator i=begin();
  while (i!=end())
  {
    i->second.remove_empty_ccvs();
    if (i->second.is_empty())
    {
      erase(i);
      i=begin(); // no other choice
    }
    else
      ++i;
  };
}

void symb_states_type::intersection_assign(const clock_val_set& cvs)
{
  symb_states_type::iterator i=begin();
  while (i!=end())
  {
    i->second.intersection_assign(cvs);
    ++i;
  };

  remove_empty();
}

void
symb_states_type::difference_assign(const symb_states_type& s, bool use_names)
{
	if (!use_names)
	{
		location_ref loc;
		symb_states_type::iterator i=begin();
		symb_states_type::const_iterator j=s.begin();
		while (i!=end())
		{
			loc=i->first;
			j=s.find(loc);
			if (j!=s.end())
			{
				i->second.difference_assign(j->second);
			};
			++i;
		};
	}
	else
	{
		string s1;
		string s2;
		symb_states_type::iterator i=begin();
		symb_states_type::const_iterator j=s.begin();
		while (i!=end())
		{
			s1=get_loc_name(i->first);
			// compare each string for containment
			j=s.begin(); // for each location in the loc->cvs map
			while (j!=s.end())
			{
				s2=s.get_loc_name(j->first);
				if (location_name_contains(s2,s1))
				{
					i->second.difference_assign(j->second);
				};
				++j;
			};
			++i;
		};		
	};
  remove_empty();
}

bool 
symb_states_type::contains(const symb_states_type& s, bool use_names) const
{
	if (!use_names)
	{
		location_ref loc;
		symb_states_type::const_iterator it=begin();
		symb_states_type::const_iterator i=s.begin();
		while (i!=s.end())
		{
			loc=i->first;
			it=find(loc);
			if (it!=end())
			{
				if (!it->second.contains(i->second))
					return false;
			}
			else
				if (!i->second.is_empty())
					return false; // if loc is not found in *this, it's empty and therefore no containment
			++i;
		};
	
		return true;
	}
	else
	{
		// the only way to check this properly for wildcard names is by checking for emptyness of the difference
		symb_states_type s2(s);
		s2.difference_assign(*this,use_names);
		if (s2.is_empty())
			return true;
		else
			return false;
	};
}

   bool 
   symb_states_type::is_intersecting(const string& loc_name, const clock_val_set& cvs) const
   {
   // check whether there is a location referring to loc_name that has a nonzero intersection with cvs
		symb_states_type::const_iterator it=begin();
      clock_val_set test_cvs;
      string lname;
      while (it!=end())
      {
         lname=get_loc_name(it->first);
         if (location_name_contains(lname,loc_name) || location_name_contains(loc_name,lname))
         {
            test_cvs=it->second;
            test_cvs.intersection_assign(cvs);
            if (!test_cvs.is_empty())
            {
               return true;
            }
         }
         ++it;
      }
      return false;      
   }


void
symb_states_type::intersection_assign(const symb_states_type& s, bool use_names)
{
	// Intersect the states. If use_names, then use the location names and check
  // if variables must be remapped. Otherwise just pretend everything fits.

	// unify the variable names

	bool remap_necessary=false;
	variable_id_map new_var_names;
	PFunction pfunc,pfunc1;
	dimension_type newdim;
	
//cout <<"up "<< var_names_uptodate << s.var_names_uptodate;

	if (var_names_uptodate && s.var_names_uptodate && var_names != s.var_names)
	{
		remap_necessary=true;

		// build variable maps		
		get_common_var_names(var_names, s.var_names, new_var_names, pfunc1, pfunc, newdim);	

		var_names=new_var_names;	
	};

	if (!use_names)
	{
		location_ref loc;
		symb_states_type::const_iterator i=s.begin();
		symb_states_type::iterator j;
	
		while (i!=s.end())
		{
			loc=i->first;
			j=find(loc);
			if (j!=end())
			{
				j->second.intersection_assign(i->second);
			};
			++i;
		};
		// delete those not in s
		j=begin();
		while (j!=end())
		{
			if (s.find(j->first)==s.end())
			{
				erase(j);
				j=begin();
			}
			else
				++j;
		};
	}
	else
	{
		string loc_name;
		string l1,l2;
		

		// rebuild symb_states_type
		symb_states_type result(var_names);
		symb_states_type::const_iterator i=begin();
		symb_states_type::const_iterator j=s.begin();
		clock_val_set cvs,cvs2;
		
		remove_empty();
		while (i!=end())
		{
//cout << "l1:" << i->first << endl << flush;		
			l1=get_loc_name(i->first);
			j=s.begin();
			while (j!=s.end())
			{
				if (!j->second.is_empty())
				{
//	cout << l1 << "," << s.get_loc_name(j->first) << ":" << flush;
					loc_name=location_name_intersection(l1,s.get_loc_name(j->first));
//	cout << loc_name << endl << flush;				
					if (loc_name.length()>0)
					{
						// the names agree
						cvs=i->second;
						if (remap_necessary)
						{
							cvs.add_space_dimensions_and_embed(newdim-cvs.dim);
							cvs2=j->second;
							cvs2.add_space_dimensions_and_embed(newdim-cvs2.dim);
							cvs2.map_space_dimensions(pfunc);
							cvs.intersection_assign(cvs2);
						}
						else
						{
							cvs.intersection_assign(j->second);
						};
						result.add(loc_name,cvs);
					};
				};
				++j;
			};
			++i;
		};
		
//		swap(*this,result);
		*this=result;
	};

	var_names_uptodate=var_names_uptodate && s.var_names_uptodate;

  remove_empty();
}

bool
symb_states_type::is_empty() const
{
  bool isempty=true;

  symb_states_type::const_iterator i=begin();
  while ((i!=end()) & (isempty==true))
  {
    if (!(i->second.is_empty()))
      isempty=false;

    ++i;
  };
  return isempty;
}

void symb_states_type::add_space_dimensions_and_embed(dimension_type ndims)
{
  for (symb_states_type::iterator i=begin();i != end(); ++i)
  {
    i->second.add_space_dimensions_and_embed(ndims);
  };
  var_names_uptodate=false;
}

void
symb_states_type::remove_space_dimensions(const clock_ref_set& crs)
{
  for (symb_states_type::iterator i=begin();i != end(); ++i)
  {
    i->second.remove_space_dimensions(crs);
  };
  // delete var_names
  if (var_names_uptodate)
  {
    unsigned int z;
    for (clock_ref_set::const_reverse_iterator i = crs.rbegin(); i!=crs.rend();++i)
    {
      z=*i;
      var_names.erase_id(z);
    };
  };
}

void
symb_states_type::project_to_vars(const clock_ref_set& crs)
{
	// remove all variables except those in crs
	
	if (size()>0 && crs.size()>0)
	{
		clock_ref_set rem;
		for (uint i=0;i<begin()->second.dim;++i)
			if (!crs.contains(i))
				rem.insert(i);
		remove_space_dimensions(rem);
	};
   
}

void 
symb_states_type::rename_variable(const string& var1, const string& var2)
{
	var_names.rename_variable(var1,var2);
}

void
symb_states_type::remove_space_dimensions(const dimension_type& x1, const dimension_type& x2)
{
  for (symb_states_type::iterator i=begin();i != end(); ++i)
  {
    i->second.remove_space_dimensions(x1,x2);
  };
  
	if (var_names_uptodate)
	{
		// delete the variables from the vector
		assert(x2>=x1);
		for (dimension_type i=x2;i>=0;--i)
		{
			var_names.erase_id(i);
		};
	};
//cout << var_names; // gf 051208
}

/*
template<typename PartialFunction> void
symb_states_type::map_space_dimensions(const PartialFunction& pfunc)
{
  for (symb_states_type::iterator i=begin();i != end(); ++i)
  {
    i->second.map_space_dimensions(pfunc);
  };
};
*/

clock_val_set
symb_states_type::union_over_locations()
{
  dimension_type dim(0);
  if (!empty()) dim=begin()->second.dim;
  clock_val_set cvs(dim,EMPTY);

  for (symb_states_type::iterator i=begin();i != end(); ++i)
  {
    cvs.union_assign(i->second);
    cvs.simplify();
  };
  return cvs;
}

clock_val_set
symb_states_type::intersection_over_locations()
{
  dimension_type dim(0);
  if (!empty()) dim=begin()->second.dim;
  clock_val_set cvs(dim);

  for (symb_states_type::iterator i=begin();i != end(); ++i)
  {
    cvs.intersection_assign(i->second);
  };
  cvs.simplify();
  return cvs;
}

symb_states_type
symb_states_type::merge_splitted()
{
  symb_states_type result(var_names);
  for (symb_states_type::iterator i=begin();i != end(); ++i)
  {
    result.add(location_name_unrefined(loc_names[i->first]),i->second);
  };
  result.simplify();
  return result;
}


void
symb_states_type::simplify()
{
  // remove the empty ones
  symb_states_type::iterator i=begin();
  while (i!=end())
  {
    i->second.simplify();
    ++i;
  };
}

bool
symb_states_type::limit_constraints_or_bits(int n, int bits)
{
  // 
  bool changed=false;
  bool nowchanged=false;
  symb_states_type::iterator i=begin();
  while (i!=end())
  {
    nowchanged=i->second.limit_constraints_or_bits(n,bits);
    changed=changed||nowchanged;
    ++i;
  };
  return changed;
}

void
symb_states_type::split(location_ref& loc,location_ref& new_loc,Constraint con)
{
	if (this->find(loc)!=this->end())
	{
		if (con.is_equality()) // simply convert it into a non-strict inequality
			con=constraint_to_nonstrict_inequality(con);
		clock_val_set cvs((*this)[loc]);
		(*this)[loc].add_constraint(con);
		con=closed_inequality_complement(con);
		cvs.add_constraint(con);
		add(new_loc,cvs);
	};
};

void
symb_states_type::split(location_ref& loc,location_ref& new_loc,clock_val_set& inv1, clock_val_set& inv2)
{
	if (this->find(loc)!=this->end())
	{
		clock_val_set cvs((*this)[loc]);
		(*this)[loc].intersection_assign(inv1);
		cvs.intersection_assign(inv2);
		add(new_loc,cvs);
	};
};

void
symb_states_type::print() const
{
  location_ref loc;
  clock_val_set cvs;
  symb_states_type::const_iterator i;

  i=this->begin();
  while (i!=this->end())
  {
    loc=i->first;
    cvs=i->second;

//      cout << "Location " << locations[loc].name <<" (" << loc << "):" << endl;
		if (loc_names.find(loc)==loc_names.end())
			cout << "[" << loc << "]" << endl;
		else
			cout << loc_names.find(loc)->second << "[" << loc << "]"  << endl;
    if (var_names_uptodate)
      cvs.print(var_names);
    else
      cvs.print();
    ++i;
  };

  if (this->empty())
    cout << "empty";
}

void
symb_states_type::print_phaver(ostream& s) const
{
  // Produce output as parseable by PHAVer
  location_ref loc;
  clock_val_set cvs;
  symb_states_type::const_iterator i;

  i=this->begin();
  while (i!=this->end())
  {
    loc=i->first;
    cvs=i->second;

//      cout << "Location " << locations[loc].name <<" (" << loc << "):" << endl;
if (loc_names.find(loc)==loc_names.end())
   throw_error("symb_states_type::print_phaver couldn't find location " + int2string(loc));
   
    s << loc_names.find(loc)->second << " & " << endl;
    if (var_names_uptodate)
      cvs.print_phaver(s,var_names);
    else
      cvs.print();
    ++i;
	 if (i!=this->end())
	 	s << "," << endl;
  };

//  if (this->empty())
//    cout << "empty";
}

void
symb_states_type::print(vector <string> loc_names) const
{
  location_ref loc;
  clock_val_set cvs;
  symb_states_type::const_iterator i;

  i=this->begin();
  while (i!=this->end())
  {
    loc=i->first;
    cvs=i->second;
    if (!cvs.is_empty())
      {

//      cout << "Location " << locations[loc].name <<" (" << loc << "):" << endl;
    cout << "[" << loc_names[loc] << "]" << endl;
    if (var_names_uptodate)
      cvs.print(var_names);
    else
      cvs.print();
      };
    ++i;
  };

  if (this->empty())
    cout << "empty";
}

void
symb_states_type::print_gen_fp_raw(ostream& s) const
{
  stopwatch sw(2100,"print_gen_fp_raw");
	message(2100,"Printing symb. states in " + int2string(size()) + " locations in generator floating point raw format.");
	  
	location_ref loc;
  clock_val_set cvs;
  symb_states_type::const_iterator i;

  i=this->begin();
  while (i!=this->end())
  {
    loc=i->first;
    cvs=i->second;

//    cout << "[" << loc_names[loc] << "]" << endl;
    cvs.print_gen_fp_raw(s);
    ++i;
  };

//  if (this->empty())
//    cout << "empty";
}

void 
symb_states_type::save_gen_fp_raw(string filename) const
{
	ofstream file_out_a;
	file_out_a.open( (filename).c_str() );
	print_gen_fp_raw(file_out_a);
	file_out_a.close();
}

void
symb_states_type::print_con_fp_raw(ostream& s) const
{
  stopwatch sw(2100,"print_gen_fp_raw");
	message(2100,"Printing symb. states in " + int2string(size()) + " locations in constraint floating point raw format.");
	  
	location_ref loc;
  clock_val_set cvs;
  symb_states_type::const_iterator i;

  i=this->begin();
  while (i!=this->end())
  {
    loc=i->first;
    cvs=i->second;

//    cout << "[" << loc_names[loc] << "]" << endl;
    cvs.print_con_fp_raw(s);
    ++i;
  };

  if (this->empty())
    cout << "empty";
}

