/***************************************************************************
 *   Copyright (C) 2004 by Goran Frehse                                    *
 *   gfrehse@localhost                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

 #include "transition.h"
 
 //--------------------------------------------------------------------------
// Transition
//--------------------------------------------------------------------------

int transition::get_memory() const
{
   return 1 + mymu.get_memory() + myexit_set.get_memory() + myentry_set.get_memory() + 9;
}

clock_val_set
transition::exit_set(const clock_val_set& s_inv, const clock_val_set& t_inv) const
{
  if (MEMORY_MODE<=0)
  {
  if (exit_set_uptodate)
    return myexit_set;
	else if (myis_ident && entry_set_uptodate)
    return myentry_set;
  else
  {
    transition& t = const_cast<transition&>(*this);
    
    t.myexit_set=mu(s_inv, t_inv);
    t.myexit_set.remove_space_dimensions(mymu.dim/2,mymu.dim-1); // drop u'

    t.exit_set_uptodate=true;
    return t.myexit_set;
  }
  }
  else
  {
   clock_val_set cvs(mu(s_inv, t_inv));
   cvs.remove_space_dimensions(mymu.dim/2,mymu.dim-1); // drop u'
   return cvs;
  }
}

clock_val_set
transition::entry_set(const clock_val_set& s_inv, const clock_val_set& t_inv) const
{
  if (MEMORY_MODE<=0)
  {
  if (entry_set_uptodate)
    return myentry_set;
	else if (myis_ident  && exit_set_uptodate)
    return myexit_set;
  else
  {
    transition& t = const_cast<transition&>(*this);

    t.myentry_set=mu(s_inv, t_inv);
    t.myentry_set.remove_space_dimensions(0,mymu.dim/2-1); // drop u

    t.entry_set_uptodate=true;
    return t.myentry_set;
  }
  }
  else
  {
   clock_val_set cvs(mu(s_inv, t_inv));
   cvs.remove_space_dimensions(0,mymu.dim/2-1); // drop u
   return cvs;
  }  
}

const clock_val_set& 
transition::unrestricted_mu() const
{ 
	return mymu;
}

clock_val_set 
transition::mu(const clock_val_set& s_inv,const clock_val_set& t_inv) const
{ 
/*
	if (!mu_uptodate)
	{
		mu_update_source(s_inv);
		mu_update_target(t_inv);
	};
	return mymu;
*/  
   clock_val_set cvs(s_inv); // is u
   clock_val_set res(mymu);
   if (2*s_inv.dim!=mymu.dim)
   {
      cout << cvs << " dimension " << cvs.dim;
      cout << mymu << " dimension " << mymu.dim;
      throw_error("Incompatible dimensions at mu_update_source!");
   };
   cvs.add_space_dimensions_and_embed(s_inv.dim); // add room for u'
   res.intersection_assign(cvs);
   cvs=t_inv; // is u'
   cvs.add_space_dimensions_and_embed(t_inv.dim); // add room for u
   cvs.dimension_move_assign(0,t_inv.dim-1,t_inv.dim); // move u' up, is u,u'
   res.intersection_assign(cvs);
   return res;
}

void 
transition::mu_update_source(const clock_val_set& s_inv) const
{ 
	if (!mu_uptodate)
	{
		if (!mu_source_uptodate)
		{
			transition& t = const_cast<transition&>(*this);
			clock_val_set cvs=s_inv; // is u
			if (2*s_inv.dim!=t.mymu.dim)
			{
				cout << cvs << " dimension " << cvs.dim;
				cout << t.mymu << " dimension " << t.mymu.dim;
				throw_error("Incompatible dimensions at mu_update_source!");
			};
			cvs.add_space_dimensions_and_embed(s_inv.dim); // add room for u'
			t.mymu.intersection_assign(cvs);
			t.mu_source_uptodate=true;
			if (t.mu_target_uptodate)
			{
				t.mu_uptodate=true;
			};
		};
	};
}

void 
transition::mu_update_target(const clock_val_set& t_inv) const
{ 
	if (!mu_uptodate)
	{
		if (!mu_target_uptodate)
		{
			transition& t = const_cast<transition&>(*this);
			clock_val_set cvs=t_inv; // is u'
			cvs.add_space_dimensions_and_embed(t_inv.dim); // add room for u
			cvs.dimension_move_assign(0,t_inv.dim-1,t_inv.dim); // move u' up, is u,u'
			t.mymu.intersection_assign(cvs);
			t.mu_target_uptodate=true;
			if (t.mu_source_uptodate)
			{
				t.mu_uptodate=true;
			};
		};
	};
}

void 
transition::check_ident()
{
  // Build equalities
	clock_val_set cvs(mymu.dim);
  for (dimension_type i=0;i<mymu.dim/2;++i)
  { cvs.add_constraint(Variable(i)==Variable((i)+mymu.dim/2));
	};	
	myis_ident=cvs.contains(mymu);
}

void
transition::add_space_dimensions_and_embed(dimension_type ndims)
{
  mymu.add_space_dimensions_and_embed_double(ndims);
  if (exit_set_uptodate)
    myexit_set.add_space_dimensions_and_embed(ndims);
  if (entry_set_uptodate)
    myentry_set.add_space_dimensions_and_embed(ndims);
	myis_ident=false;
}

void 
transition::map_space_dimensions(PFunction pfunc)
{
   if (exit_set_uptodate)
      myexit_set.map_space_dimensions(pfunc);
   if (entry_set_uptodate)
      myentry_set.map_space_dimensions(pfunc);
   // add the shifted targets to pfunc for mu
   dimension_type tdim=mymu.dim/2;
      PartialFunction_Double(pfunc,tdim);
   mymu.map_space_dimensions(pfunc);
}
 
void 
transition::reverse()
{
   // reverse causality
   if (mymu.dim>1)
      mymu.dimension_swap_assign(0,mymu.dim/2-1,mymu.dim/2);
   clock_val_set buffer=myexit_set;
   myexit_set=myentry_set;
   myentry_set=buffer;
   
   swap(mysource_loc,mytarget_loc);
   swap(exit_set_uptodate,entry_set_uptodate);
   swap(mu_source_uptodate,mu_target_uptodate);
}

void 
transition::clear() 
{ // free memory, keep source and target locs
   mymu=clock_val_set(mymu.dim); 
   myexit_set=clock_val_set(myexit_set.dim);
   myentry_set=clock_val_set(myentry_set.dim); 
   exit_set_uptodate=false; 
   entry_set_uptodate=false;
   mu_uptodate=false;
   mu_source_uptodate=false;
   mu_target_uptodate=false;
   is_separable=false;
   myis_ident=false;
}


 
