/***************************************************************************
                        AUT.cpp  -  description
                           -------------------
  begin                : Thu Nov 21 2002
  copyright            : (C) 2002 by Goran Frehse
  email                : goran@s.cs.auc.dk
***************************************************************************/

/***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

//#include <stdio.h>
//#include <iostream>
//#include <vector>
//#include <list>
//#include <set>
//#include <algorithm>
//#include <stdexcept>
//
//#include "ppl.hh"
//#include "cvs_class.h"
//#include "symb_states.h"
//#include "stopwatch.h"
#include "automaton.h"

using namespace Parma_Polyhedra_Library;
using namespace Parma_Polyhedra_Library::IO_Operators;
using namespace std;



//--------------------------------------------------------------------------
// Automaton
//--------------------------------------------------------------------------

automaton::automaton():dim(0),reversed(false),priority(INT_MAX)
{
  // initialize labels: label 0 (tau) always in alphabet
  add_label(TAU_LABEL_STRING);
  add_distribution(distribution(1, 1.0));
}

automaton::automaton(string nme):dim(0),name(nme),reversed(false),priority(INT_MAX)
{
  // initialize labels: label 0 (tau) always in alphabet
  add_label(TAU_LABEL_STRING);
  add_distribution(distribution(1, 1.0));
}

automaton::automaton(clock_dim_type d):dim(d),reversed(false),priority(INT_MAX)
{
  // initialize labels: label 0 (tau) always in alphabet
  add_label(TAU_LABEL_STRING);
  add_distribution(distribution(1, 1.0));
}

// Methods
void
automaton::clear()
{
   /*
  name="";
  dim=0;
  var_id_map.clear();
  variables.clear();
  

  labels.clear();
  label_name_to_label_ref_map.clear();
  add_label(TAU_LABEL_STRING); // label 0 (tau) always in alphabet

  locations.clear();
  loc_name_to_loc_ref_map.clear();
  
  transitions.clear();

  ini_states.clear();
  */
  *this=automaton();
}

variable_id_map
automaton::get_var_names() const
{
  return var_id_map;
}


variable_id_map
automaton::get_var_names_mu() const
{
  variable_id_map vn(var_id_map);
  vn.shifted_union_assign(var_id_map,"'");
  return vn;
}

vector <string>
automaton::get_loc_names() const
{
  vector <string> lnames(locations.size());
  for (unsigned int i=0;i<locations.size();++i)
  {
    lnames[i]=locations[i].name;
  };
  return lnames;
}

loc_names_map
automaton::get_loc_names_map() const
{
  loc_names_map lnames;
  for (unsigned int i=0;i<locations.size();++i)
  {
    lnames[i]=locations[i].name;
  };
  return lnames;
}

map<label_ref, string> automaton::get_label_names_map() const
{
	map<label_ref, string> label_names;
	for(label_ref_set::iterator i = labels.begin(); i != labels.end(); i++)
	{
		label_names[*i] = get_label_name(*i);
	}
	return label_names;
}

string
automaton::get_label_name(label_ref l) const
{
    // get label name
  string lname = "missing label!";
  for (map <string,label_ref>::const_iterator ii=label_name_to_label_ref_map.begin();ii!=label_name_to_label_ref_map.end();++ii)
  {
    if (ii->second==l)
      lname = ii->first;
  };
  return lname;
}

label_ref
automaton::get_label_ref(string label_name) 
{
  label_ref lab(0);
  if (label_name_to_label_ref_map.find(label_name)!=label_name_to_label_ref_map.end())
    lab=label_name_to_label_ref_map[label_name];
  else
    throw_error("Unknown label " + label_name + " when adding transition.");
  return lab;
}

symb_states_type 
automaton::get_ini_states() const
{
	symb_states_type states(ini_states);
	states.loc_names_assign(get_loc_names_map());
	states.var_names_assign(get_var_names());
	return states;
}

symb_states_type 
automaton::get_invariants() const
{
	symb_states_type states;
	states.loc_names_assign(get_loc_names_map());
	states.var_names_assign(get_var_names());
	for (uint i=0; i<locations.size();++i)
	{
		states[i]=locations[i].invariant();
	};
	return states;
}

int 
automaton::get_memory() const
{
   int loc_mem(0),trans_mem(0);
   
	for (uint i=0; i<locations.size();++i)
	{
		loc_mem+=locations[i].get_memory();
	};
   
	for (uint i=0; i<transitions.size();++i)
	{
		trans_mem+=transitions[i].get_memory();
	};
   
cout << "Mem locs: "<< loc_mem << ", trans: " << trans_mem << ", total: " << loc_mem+trans_mem << endl<< flush; 
     
   return loc_mem+trans_mem;   
}

location_ref
automaton::add_location(AUT_invariant invar, string sname, Constraint_List post_poly)
{
  location_ref loc;
  // check for sanity
//  if (post_poly.is_empty())
//    throw_warning("Location added with empty time elapse!");
   if (invar.is_empty())
   {
      return locations.size();
   }  

	// add constraints for parameters
	for (clock_ref_set::const_iterator i=parameters.begin();i!=parameters.end();++i)
	{ post_poly.push_back(Variable(*i)==0); };
   
   if (MEMORY_MODE>=3)
      invar.minimize_memory();
	
	location l(invar,sname,post_poly);

	// check if location already exists
	// if yes, overwrite
  if (loc_name_to_loc_ref_map.find(sname)!=loc_name_to_loc_ref_map.end())
  {
    loc=loc_name_to_loc_ref_map[sname];
		locations[loc].overwrite(l);
  }
  else
  {
    locations.push_back(l);
    loc = (locations.size()-1);
    loc_name_to_loc_ref_map.insert(make_pair(sname,loc));
  };
  return loc;
}

location_ref
automaton::add_location(string sname, location l)
{
	// retain everything from l except:
	// - name
	// - transition information (incoming, outgoing)
   
   if (l.invariant().is_empty())
   {
      return locations.size();
   } 
      
  location_ref loc;
	l.name=sname;
	l.in_trans.clear();
	l.out_trans.clear();
	// check if location already exists
	// if yes, overwrite
  if (loc_name_to_loc_ref_map.find(sname)!=loc_name_to_loc_ref_map.end())
  {
    loc=loc_name_to_loc_ref_map[sname];
		locations[loc].overwrite(l);
  }
  else
  {
    locations.push_back(l);
    loc = (locations.size()-1);
    loc_name_to_loc_ref_map.insert(make_pair(sname,loc));
  };

	return loc;
}

/*
location_ref
automaton::copy_location(location_ref loc)
{
// ATTENTION: this is WRONG, something doesn't work here!


  // create a new copy of loc
  // add it to aut.locations
  locations.push_back(locations[loc]);
  location_ref nloc = (locations.size()-1);  
  // clear information on in- and outgoing transitions
  locations[nloc].in_trans.clear();
  locations[nloc].out_trans.clear();
  
  // copy all transitions from loc to nloc
  transition_ref t;
  // incoming transitions
  for (trans_ref_set::const_iterator i=locations[loc].in_trans.begin();i!=locations[loc].in_trans.end();++i)
  {
    transitions.push_back(transitions[*i]); // make a copy of transition
    t = (transitions.size()-1); // get reference
    transitions[t].target_assign(nloc);
    locations[nloc].in_trans.insert(t);
  };
  // outgoing transitions
  for (trans_ref_set::const_iterator i=locations[loc].out_trans.begin();i!=locations[loc].out_trans.end();++i)
  {
    transitions.push_back(transitions[*i]); // make a copy of transition
    t = (transitions.size()-1); // get reference
    transitions[t].source_assign(nloc);
    locations[nloc].out_trans.insert(t);
  };
  
  return nloc;
}; 
*/

void 
automaton::assume_loc_modification(location_ref loc)
// change uptodate status of 
// exit- and entry-sets of in- and outgoing transitions
// after a modification
{
	trans_ref_set trs;
	
  // incoming transitions
  for (trans_ref_set::const_iterator i=locations[loc].in_trans.begin();i!=locations[loc].in_trans.end();++i)
  {
    transitions[*i].assume_target_modification();
		
		// if it's empty, remove it from incoming and outgoing transitions
		if (get_restricted_mu(*i).is_empty())
		{
			trs.insert(*i);
		};
  };
  // outgoing transitions
  for (trans_ref_set::const_iterator i=locations[loc].out_trans.begin();i!=locations[loc].out_trans.end();++i)
  {
    transitions[*i].assume_source_modification();
  
		// if it's empty, remove it from incoming and outgoing transitions
		// if it's empty, remove it from incoming and outgoing transitions
		if (get_restricted_mu(*i).is_empty())
		{
			trs.insert(*i);
		};
	};
	
  for (trans_ref_set::const_iterator i=trs.begin();i!=trs.end();++i)
  {
	transition_remove_refs(*i);
	};
}

void
automaton::location_remove_nonface_silents(location_ref loc,label_ref splitting_silent_label)
{
	trans_ref_set trs;
	clock_val_set cvs(dim);
	
  // incoming transitions
  for (trans_ref_set::const_iterator i=locations[loc].in_trans.begin();i!=locations[loc].in_trans.end();++i)
  {
		if (transitions[*i].label==splitting_silent_label)
		{
		
			cvs.intersection_assign_from(locations[loc].invariant(),locations[transitions[*i].source_loc()].invariant());
			// if it's a silent transition, only copy it if it's at least a hyperplane (otherwise it's redundant with one of the hyperplanes)
			if (cvs.is_empty() || (!cvs.is_empty() && cvs.get_real_dimension()<cvs.dim-1))
				trs.insert(*i);
				
//			if (get_restricted_entry_set(*i).get_real_dimension()<dim-1)
//				trs.insert(*i);
		};
  };
  // outgoing transitions
  for (trans_ref_set::const_iterator i=locations[loc].out_trans.begin();i!=locations[loc].out_trans.end();++i)
  {
		if (transitions[*i].label==splitting_silent_label)
		{
			cvs.intersection_assign_from(locations[loc].invariant(),locations[transitions[*i].target_loc()].invariant());
//			// if it's a silent transition, only copy it if it's at least a hyperplane (otherwise it's redundant with one of the hyperplanes)
			if (cvs.is_empty() || (!cvs.is_empty() && cvs.get_real_dimension()<cvs.dim-1))
				trs.insert(*i);
		
//			if (get_restricted_exit_set(*i).get_real_dimension()<dim-1)
//				trs.insert(*i);
		};
	};
	// remove them now
  for (trans_ref_set::const_iterator i=trs.begin();i!=trs.end();++i)
  {
		transition_remove_refs(*i);
	};
}

void
automaton::location_remove_nontimerel_silents(location_ref loc,label_ref splitting_silent_label)
{
	// remove silent transitions that are no longer time relevant
  // outgoing transitions
	trans_ref_set trs;
	// 1. get time relevant constraints of invariant
	Constraint_List cl,cl2;
	clock_val_set cvs=locations[loc].invariant();	
	for (list<convex_clock_val_set>::const_iterator i=cvs.ccvs_list.begin();i!=cvs.ccvs_list.end();++i)
	{
		cl2=Constraint_System_convert_equalities(i->minimized_constraints());
		cl.splice(cl.begin(),cl2,cl2.begin(),cl2.end());
	};
	Constraint_List ncl; // for the negatives
	Constraint_List::iterator it=cl.begin();
	Constraint_List::iterator nit=ncl.begin();
	// delete not time relevant constraints
	while (it != cl.end())
	{
		if (!is_time_relevant(*it,locations[loc].time_post_poly()))
			it=cl.erase(it);
		else
		{
			ncl.push_back(closed_inequality_complement(*it));
			if (it->is_strict_inequality())
				*it=constraint_closure(*it);
			++it;
		};
	};
	// remove transitions for which there doesn't exist a time relevant face inside the exit set
	
	bool found=false;
	location_ref tloc;
	clock_val_set cvs2;
	uint min_dim=locations[loc].invariant().get_real_dimension()-1;
  for (trans_ref_set::const_iterator i=locations[loc].out_trans.begin();i!=locations[loc].out_trans.end();++i)
  {
		if (transitions[*i].label==splitting_silent_label)
		{
			tloc=transitions[*i].target_loc();
			found = false;
			it=cl.begin();
			nit=ncl.begin();
			while (!found && it != cl.end())
			{
// cout << endl << *it << flush << " vs ";			
// cout << *nit << flush << endl;			
				// test if exit set intersets with face (face, not constraint)
				cvs=clock_val_set(locations[loc].invariant().dim);
				cvs.add_constraint(*nit);
//cout << cvs << endl;				
/*cout << cvs << endl;				
cout << transitions[*i].exit_set(locations[loc].invariant(),locations[tloc].invariant()) << ":" << transitions[*i].exit_set(locations[loc].invariant(),locations[tloc].invariant()).is_disjoint_from(cvs) << endl;*/		
				
				//if (!transitions[*i].exit_set(locations[loc].invariant(),locations[tloc].invariant()).is_disjoint_from(cvs))
				cvs2.intersection_assign_from(transitions[*i].exit_set(locations[loc].invariant(),locations[tloc].invariant()),cvs);
				if (!cvs2.is_empty() && cvs2.get_real_dimension()>=min_dim)
				{
					// test if the entry set is time relevant with the complement
					if (is_time_relevant(*it,locations[tloc].time_post_poly()))
						found=true;
				};
				++it;
				++nit;
			};
			
			if (!found)
				trs.insert(*i);
		};
	};
	// remove them now
  for (trans_ref_set::const_iterator i=trs.begin();i!=trs.end();++i)
  {
// cout << "removed " << *i << endl;	
		transition_remove_refs(*i);
	};
	
}

void
automaton::transition_remove_refs(transition_ref t)
{
// if (false)
	if (!DONT_REMOVE_TRANS.contains(t))
	{
//cout << "Erasing refs to " << t << endl << flush;
		locations[transitions[t].source_loc()].out_trans.erase(t);
		locations[transitions[t].target_loc()].in_trans.erase(t);
		
		transitions[t].clear(); // free memory by clearing the clock_val_sets
	};
}

transition_ref
automaton::add_transition(location_ref sl, label_ref a, clock_val_set mu, location_ref tl, bool is_urgent, distribution_ref distr, unsigned int distr_entry)
{
  clock_val_set cvs;

  transition_ref i=transitions.size();
  transition t; //(sl,a,g,r,tl);
  t.source_assign(sl);
  t.target_assign(tl);
  t.label=a;
  t.set_urgent(is_urgent);
  t.distribution = distr;
  t.distribution_entry = distr_entry;
	
	// Get mu to the right dimensions
  mu.add_space_dimensions_and_embed(2*dim-mu.dim);

  // Add constraints to mu so that parameters remain equal
  for (clock_ref_set::const_iterator ii=parameters.begin();ii!=parameters.end();++ii)
  { mu.add_constraint(Variable(*ii)==Variable((*ii)+dim)); };
  
   if (MEMORY_MODE>=3)
      mu.minimize_memory();
      
	t.mu_assign(mu);
   
   // check for empty transitions
//cout << t.unrestricted_mu();   
	mu=t.mu(locations[sl].invariant(),locations[tl].invariant());
//cout << mu;   
  if (!mu.is_empty())
  {
    transitions.push_back(t);  // the direct assign doesn't work (why?)

    // add reference information linked locations
    locations[sl].out_trans.insert(i);
    locations[tl].in_trans.insert(i);
    
//if (get_restricted_mu(i).is_empty()) cout << endl << "Empty transition added" << endl;
		return i;
  }
  else
    return transitions.size();
}

transition_ref
automaton::add_transition(string source_name, string label_name, clock_val_set mu, string target_name, distribution_ref distr, unsigned int distr_entry)
{
  location_ref sl(0),tl(0);
  if (loc_name_to_loc_ref_map.find(source_name)!=loc_name_to_loc_ref_map.end())
    sl=loc_name_to_loc_ref_map[source_name];
  else
    throw_error("Unknown source location " + source_name + " when adding transition.");

  if (loc_name_to_loc_ref_map.find(target_name)!=loc_name_to_loc_ref_map.end())
    tl=loc_name_to_loc_ref_map[target_name];
  else
    tl=add_location(clock_val_set(dim),target_name,Constraint_List(dim));
    
  if (tl!=locations.size()) // location added successfully
  {
   label_ref lab(0);
   if (label_name_to_label_ref_map.find(label_name)!=label_name_to_label_ref_map.end())
      lab=label_name_to_label_ref_map[label_name];
   else
      throw_error("Unknown label " + label_name + " when adding transition.");
   
   //cout << "Transition " << sl << ":" << &locations[sl].invariant << " -> " << tl << ":" << &locations[tl].invariant << endl;
   return add_transition(sl,lab,mu,tl,false, distr, distr_entry);
  }
  else
   return transitions.size();
}

transition_ref
automaton::add_transition(string source_name, string label_name, clock_val_set guard, clock_val_set mudest, string target_name, distribution_ref distr, unsigned int distr_entry)
{
  clock_val_set mu=guard;
  mu.add_space_dimensions_and_embed(dim);
  if (mudest.dim<2*dim) // not enough dimensions, so add them
    mudest.add_space_dimensions_and_embed(2*dim-mudest.dim);
  mu.intersection_assign(mudest);
  //mu.simplify();

  return add_transition(source_name,label_name,mu,target_name, distr, distr_entry);
}

transition_ref
automaton::add_transition(const location_ref& sl, const label_ref& a, const AUT_guard& g, const clock_ref_set& r, const location_ref& tl)
{
  // turn clock reset and guard into mu
  clock_val_set mu(dim);

  mu=g;
  mu.add_space_dimensions_and_embed(dim);
  mu.intersection_assign(clock_ref_set_to_clock_val_set(r,dim,variables));

  return add_transition(sl,a,mu,tl);
}

transition_ref
automaton::add_transition(string source_name, string label_name, const AUT_guard& g, const clock_ref_set& r, string target_name)
{
  // turn clock reset and guard into mu
  clock_val_set mu(dim);   
  mu=g;
  mu.add_space_dimensions_and_embed(dim);
  mu.intersection_assign(clock_ref_set_to_clock_val_set(r,dim,variables));

  return add_transition(source_name,label_name,mu,target_name);
}

clock_val_set 
automaton::get_restricted_mu(transition_ref t) const
{
	return transitions[t].mu(locations[transitions[t].source_loc()].invariant(),locations[transitions[t].target_loc()].invariant());
}

clock_val_set 
automaton::get_restricted_entry_set(transition_ref t) const
{
	return transitions[t].entry_set(locations[transitions[t].source_loc()].invariant(),locations[transitions[t].target_loc()].invariant());
}

clock_val_set 
automaton::get_restricted_exit_set(transition_ref t) const
{
	return transitions[t].exit_set(locations[transitions[t].source_loc()].invariant(),locations[transitions[t].target_loc()].invariant());
}

transition_ref automaton::copy_transition_with_source(transition_ref t, location_ref source, clock_val_set mu)
{
	return add_transition(source, transitions[t].label, mu, transitions[t].target_loc(), false, transitions[t].distribution, transitions[t].distribution_entry);
}

transition_ref automaton::copy_transition_with_target(transition_ref t, location_ref target, clock_val_set mu)
{
	return add_transition(transitions[t].source_loc(), transitions[t].label, mu, target, false, transitions[t].distribution, transitions[t].distribution_entry);
}

void automaton::copy_transition_with_self_loop(transition_ref t, location_ref new_loc, location_ref loc, clock_val_set mu)
{
	add_transition(new_loc, transitions[t].label, mu, new_loc, false, transitions[t].distribution, transitions[t].distribution_entry);
	add_transition(loc, transitions[t].label, mu, new_loc, false, transitions[t].distribution, transitions[t].distribution_entry);
	add_transition(new_loc, transitions[t].label, mu, loc, false, transitions[t].distribution, transitions[t].distribution_entry);
}

// ------------------------------------------------------------------------------------------------------------

void automaton::add_space_dimensions_and_embed(dimension_type ndims)
{
  // add dimensions to invariants, transitions, ini_states
  for (unsigned int i=0;i<locations.size();++i)
  {
    locations[i].add_space_dimensions_and_embed(ndims);
  }
  for (unsigned int i=0;i<transitions.size();++i)
  {
    transitions[i].add_space_dimensions_and_embed(ndims);
  }
  ini_states.add_space_dimensions_and_embed(ndims);
  
  // finally: change the official dimension of *this
  dim=dim+ndims;
  
  // Variables and parameter sets stay the same.
  // Add dimensions to variable_id_map
  var_id_map.add_space_dimensions(ndims);
}

void automaton::map_space_dimensions(const PFunction& pfunc)
{
  // map dimensions in invariants, time-elapse, mus, ini_states
  for (unsigned int i=0;i<locations.size();++i)
  {
    locations[i].map_space_dimensions(pfunc);
  }
  for (unsigned int i=0;i<transitions.size();++i)
  {
    transitions[i].map_space_dimensions(pfunc);
  }
  //
  dim=pfunc.max_in_codomain()+1;

  ini_states.map_space_dimensions(pfunc);
  variables=remap(variables,pfunc);
  input_variables=remap(input_variables,pfunc);
  parameters=remap(parameters,pfunc);
  var_id_map.map_space_dimensions(pfunc);
}

void automaton::project_to_vars(const clock_ref_set& crs)
{
   // construct PFunction
   PFunction pf;
   dimension_t count=0;
   for (clock_ref_set::const_iterator it=crs.begin();it!=crs.end();++it)
   {
      pf.insert(*it,count);
      ++count;
   }
   map_space_dimensions(pf);
}

void
automaton::invariant_assign(const symb_states_type& states, bool map_locs)
{
  // replaces the invariant by the symbolic states in states.
  // by assigning the reach set to the invariant, the cost calc
  // can be limited to the reachable states

  // this is the wrapper, which creates a new symb_states_type is the locations
  // need to be remapped
  	
  if (map_locs)
  {
    symb_states_type map_states(states);
    map_states.map_locations(get_loc_names_map());
    invariant_assign_exec(map_states);
  }
  else
    {
      invariant_assign_exec(states);
    };
}

void
automaton::invariant_assign_exec(const symb_states_type& states)
{
  // replaces the invariant by the symbolic states in states.
  // by assigning the reach set to the invariant, the cost calc
  // can be limited to the reachable states
  
	location_ref loc;
  clock_val_set cvs;

  symb_states_type::const_iterator i=states.begin();

  while (i!=states.end())
  {
    loc=i->first;
		if (REFINE_INTERSECT_METHOD==0)
		{
			cvs=i->second;
			cvs.intersection_assign(locations[loc].invariant());
			locations[loc].invariant_assign(cvs);
		}
		else if (REFINE_INTERSECT_METHOD==1)
		{
			cvs=i->second;
			bool changed=cvs.limit_constraints(REACH_CONSTRAINT_LIMIT,CONSTRAINT_BITSIZE);
			if (!changed)
				cvs.limit_significant_bits(CONSTRAINT_BITSIZE);
			cvs.intersection_assign(locations[loc].invariant());
			locations[loc].invariant_assign(cvs);
		}		
		else if (REFINE_INTERSECT_METHOD==2)
		{
			cvs=i->second;
			cvs.intersection_assign(locations[loc].invariant());
			bool changed=cvs.limit_constraints(REACH_CONSTRAINT_LIMIT,CONSTRAINT_BITSIZE);
			if (!changed)
				cvs.limit_significant_bits(CONSTRAINT_BITSIZE);
			locations[loc].invariant_assign(cvs);
		}		
		else
		{
			if (i->second.is_empty())
			{
				cvs=clock_val_set(dim,EMPTY);
				locations[loc].invariant_assign(cvs);
			};
		};
		++i;
  };

	// empty the invariants that aren't in states!
	cvs=clock_val_set(dim,EMPTY);
	for (uint i=0; i<locations.size(); ++i)
	{
		if (states.find(i)==states.end()) // this location isn't in states
		{
			locations[i].invariant_assign(cvs);
		};
	};
	
	// remove empty transitions
	trans_ref_set trs;
  // to do: re-assign entry and exit-sets, too
	for (loc=0;loc<locations.size();++loc)
	{
		assume_loc_modification(loc);
	
	
  // incoming transitions
  for (trans_ref_set::const_iterator i=locations[loc].in_trans.begin();i!=locations[loc].in_trans.end();++i)
  {
			if (transitions[*i].exit_set(locations[transitions[*i].source_loc()].invariant(),locations[transitions[*i].target_loc()].invariant()).is_empty())
				trs.insert(*i);
  };
  // outgoing transitions
  for (trans_ref_set::const_iterator i=locations[loc].out_trans.begin();i!=locations[loc].out_trans.end();++i)
  {
			if (transitions[*i].exit_set(locations[transitions[*i].source_loc()].invariant(),locations[transitions[*i].target_loc()].invariant()).is_empty())
				trs.insert(*i);
	};
	// remove them now
  for (trans_ref_set::const_iterator i=trs.begin();i!=trs.end();++i)
  {
		transition_remove_refs(*i);
	};	
	
	};
	
}

clock_ref

automaton::add_variable(string var_name)
{
  clock_ref clk;
  if (var_id_map.contains_name(var_name))
    clk=var_id_map.get_id(var_name);
  else
  {
    // create a new variable id
    clk=dim;
    variables.insert(clk); 
    var_id_map.insert(clk,var_name);
    // fix the dimension of the automaton
    add_space_dimensions_and_embed(1);
  };
  return clk;
}



clock_ref
automaton::add_ext_variable(string var_name)
{
  // Adds a variable without adding it to *this.variables
  clock_ref clk;
  if (var_id_map.contains_name(var_name))
    clk=var_id_map.get_id(var_name);
  else
  {
    // create a new variable id
    clk=dim;
    input_variables.insert(clk);
    var_id_map.insert(clk,var_name);
    // fix the dimension of the automaton
    add_space_dimensions_and_embed(1);
  };
  return clk;
}

clock_ref
automaton::add_parameter(string var_name)
{
  // Adds a variable without adding it to *this.variables, and adding it to *this.parameters
  clock_ref clk;
  if (var_id_map.contains_name(var_name))
    clk=var_id_map.get_id(var_name);
  else
  {
    // create a new variable id
      clk=dim;
    parameters.insert(clk);
    var_id_map.insert(clk,var_name);
    // fix the dimension of the automaton
    add_space_dimensions_and_embed(1);
  };
  return clk;
}

label_ref
automaton::add_label(string label_name)
{
  label_ref lab;
  
  if (label_name_to_label_ref_map.find(label_name)!=label_name_to_label_ref_map.end())
    lab=label_name_to_label_ref_map[label_name];
  else
  {
    // create a new label id
    if (label_name!="" && label_name!=TAU_LABEL_STRING)
    {
      lab=0; // assign a new number
      while (labels.contains(lab))
        ++lab;
    }
    else
      lab=0;
    labels.insert(lab);
    label_name_to_label_ref_map.insert(make_pair(label_name,lab));
  };
  return lab;
}

void
automaton::ini_states_assign(symb_states_type& states)
{
  ini_states=states;
  ini_states.map_locations(get_loc_names_map());
  ini_states.var_names_assign(get_var_names());
  // restrict ini_states to invariants
  restrict_to_invariant(ini_states);
}

void
automaton::expand_labels(label_ref_set labs, map <string,label_ref> lmap)
{
  // add self-loops for labels that aren't in alphabet of *this
//cout << labs;
  labs.difference_assign(labels);
//cout << labs;
  
  clock_val_set cvs(2*dim); // the label can occur as long as they don't change any variable
  for (unsigned int i=0; i<dim; ++i) // variable x_i ranges from 0 to n-1
  // leave parameters and state variables constant
    if (variables.contains(i) || parameters.contains(i))
      cvs.add_constraint(Variable(i)==Variable(dim+i)); // let u1==v1

  for (label_ref_set::iterator i=labs.begin();i!=labs.end();++i)
  {
    labels.insert(*i);
    label_name_to_label_ref_map.insert(make_pair(find(lmap,lmap.begin(),lmap.end(),*i)->first,*i));

message(512000,"Adding self-loops for label " + int2string(*i));
    // add a self-loop to each location
    for (unsigned int j=0;j<locations.size();++j)
    {
      add_transition(j,*i,cvs,j);
    };
  };
}

void
automaton::replace_labels(label_ref_set labs, label_ref l)
{
  // Replace labels in labs with l
  // Attention: Only to replace a single label!
  //            Ambiguities if applied more than once!
  if (!labs.empty())
  {
//cout << "Replacing labels " << labs << " with " << l << endl;

    // replace labels in labs by label l
    for (unsigned int i=0; i<transitions.size();++i)
    {
      if (labs.contains(transitions[i].label))
        transitions[i].label=l;
    };

    // take labs out of this->labels
    label_ref_set labs2;
    labs2.insert(l);
    labs.difference_assign(labs2); // just in case l was part of labs, then it should stay in labels.
    labels.difference_assign(labs);

    // make sure l is in this->labels
    labels.union_assign(l);
  };
}

void
automaton::replace_labels(map<label_ref,label_ref> label_map)
{
  // Replace label_map.first with label_map.second
  if (!label_map.empty())
  {
    // todo: check if all labels are in label_map
    
    for (unsigned int i=0; i<transitions.size();++i)
    {
      transitions[i].label=label_map[transitions[i].label];
    };

    // new labels are the set of labels in label_map.second

    label_ref_set labs2;
    for (map<label_ref,label_ref>::const_iterator i=label_map.begin();i!=label_map.end();++i)
    {
      labs2.insert(i->second);
    };
    labels=labs2;

    // fix label_name_to_label_ref_map
    for (map<string,label_ref>::iterator i=label_name_to_label_ref_map.begin();i!=label_name_to_label_ref_map.end();++i)
    {
      i->second=label_map[i->second];
    };
  };

}

void
automaton::reverse()
{
	// reverse causality: time and direction of transitions
  for (location_ref i = 0; i != locations.size(); ++i)
  {
		locations[i].reverse();
  };	
  for (transition_ref i = 0; i != transitions.size(); ++i)
  {
    transitions[i].reverse();
	};
  reversed=!reversed;
}

bool
automaton::transition_is_active(transition_ref& tr) const
{
	// return if the transition is active, i.e., if it is in the out_trans of the source location
	return locations[transitions[tr].source_loc()].out_trans.contains(tr);
}

int
automaton::active_transitions_size() const
{
	// a transition is active if it is listed as outgoing in its source location
	int count=0;
	for (uint i=0;i!=transitions.size();++i)
	{
		if (transition_is_active(i))
			++count;
	};
	return count;
}


bool 
automaton::location_is_surface(location_ref k, const symb_states_type& ss)
{
	// find out if the location is part of the surface ss (interpretation depends on the method)
	
	symb_states_type::const_iterator it(ss.find(k));
	if (it!=ss.end() && !it->second.is_empty())
	{ 
		if (0 && !it->second.contains(locations[k].invariant())) // simple method: containment
		{
			locations[k].is_surface=true;
			return true;
		};
		if (1 && it->second.contains(locations[k].invariant())) // test predecessors, must have states not in inv, otherwise k is surface
		{
			// cycle through predecessors
			// if no predecessors or successors -> surface
			if (locations[k].in_trans.size()<=0 || locations[k].out_trans.size()<=0)
			{
				locations[k].is_surface=true;
				return true;
			};
				
			clock_val_set cvs;
			symb_states_type::const_iterator jt;
			for (trans_ref_set::const_iterator i=locations[k].in_trans.begin();i!=locations[k].in_trans.end();++i)
			{
				jt=ss.find(transitions[*i].source_loc());
				if (jt!=ss.end())
				{
					cvs=jt->second;
					cvs.difference_assign(locations[k].invariant());
					if (cvs.is_empty())
					{
						locations[k].is_surface=true;
						return true;
					};
				}
				else // it doesn't find it, therefore it's empty, so one of the predecessors is not reachable
				{
					locations[k].is_surface=true;
					return true;
				};
			};
			locations[k].is_surface=false;
			return false;
		}
		else
		{			
			locations[k].is_surface=true;
			return true;
		};
	};
		
  locations[k].is_surface=false;
	return false;
}

bool 
automaton::location_is_surface(location_ref k, const symb_state_maplist& ss)
{
	// find out if the location is part of the surface ss (interpretation depends on the method)
	
	// get the states in location k
	clock_val_set cvs(ss.get_clock_val_set(k));
	
	if (!cvs.is_empty())
	{ 
		if (true && cvs.contains(locations[k].invariant())) // test predecessors, must have states not in inv, otherwise k is surface
		{
			// cycle through predecessors
			// if no predecessors or successors -> surface
			if (locations[k].in_trans.size()<=0 || locations[k].out_trans.size()<=0)
			{
				locations[k].is_surface=true;
				return true;
			};
				
			for (trans_ref_set::const_iterator i=locations[k].in_trans.begin();i!=locations[k].in_trans.end();++i)
			{
				cvs=ss.get_clock_val_set(transitions[*i].source_loc());
				if (!cvs.is_empty())
				{
					cvs.difference_assign(locations[k].invariant());
					if (cvs.is_empty())
					{
						locations[k].is_surface=true;
						return true;
					};
				}
				else // it doesn't find it, therefore it's empty, so one of the predecessors is not reachable
				{
					locations[k].is_surface=true;
					return true;
				};
			};
			locations[k].is_surface=false;
			return false;
		}
		else
		{			
			locations[k].is_surface=true;
			return true;
		};
	};
		
  locations[k].is_surface=false;
	return false;
}

int
automaton::add_surface_locations(const  symb_states_type& ss, loc_ref_set& lrs)
{
  // add surface locations in ss to lrs 
	// and return the min partitioning-level of the not fully refined locations
	
	int min_level=-1;
  for (location_ref i = 0; i != locations.size(); ++i)
  {
		if (location_is_surface(i,ss))
		{
			lrs.insert(i);
			if (!locations[i].is_fully_refined)
			{
				if (min_level<0 || locations[i].partition_level<min_level)
					min_level=locations[i].partition_level;
			};
		};
  };  
	return min_level;
}

bool
automaton::is_fully_refined(const loc_ref_set& lrs)
{
	// return if all locations in lrs are fully refined
	for (loc_ref_set::const_iterator i=lrs.begin();i!=lrs.end();++i)
	{
		if (!locations[*i].is_fully_refined)
			return false;
	};
	return true;
}

	
int 
automaton::unlock_locations()
{
	// remove the is_fully_refined lock from locations with states in ss on the surface off ss
	// and return the min partitioning-level 
	
	int min_level=-1;
  for (location_ref i = 0; i != locations.size(); ++i)
  {
//		if (locations[i].is_fully_refined && location_is_surface(i,ss))
		if (true) //(locations[i].is_fully_refined)
		{
			locations[i].is_fully_refined=false;
			locations[i].is_surface=true;
			if (min_level<0 || locations[i].partition_level<min_level)
				min_level=locations[i].partition_level;
		};
  };  
	return min_level;
}

int 
automaton::set_surface_flag(bool val)
{
	// set is_surface flag of all locations to val
	// and return the min partitioning-level 
	
	int min_level=-1;
  for (location_ref i = 0; i != locations.size(); ++i)
  {
//		if (locations[i].is_fully_refined && location_is_surface(i,ss))
		if (locations[i].is_surface!=val) //(locations[i].is_fully_refined)
		{
			locations[i].is_surface=val;
			if (min_level<0 || locations[i].partition_level<min_level)
				min_level=locations[i].partition_level;
		};
  };  
	return min_level;
}
	
int 
automaton::unlock_surface_locations(const symb_states_type& ss)
{
	// remove the is_fully_refined lock from locations with states in ss on the surface off ss
	// and return the min partitioning-level of the unlocked locations
	
	int min_level=-1;
  for (location_ref i = 0; i != locations.size(); ++i)
  {
//		if (locations[i].is_fully_refined && location_is_surface(i,ss))
		if (locations[i].is_fully_refined && location_is_surface(i,ss))
		{
			locations[i].is_fully_refined=false;
			if (min_level<0 || locations[i].partition_level<min_level)
				min_level=locations[i].partition_level;
		};
  };  
	return min_level;
}


void
automaton::print_labels() const
{
  cout << "Labels: ";
//  for (set < label_ref>::iterator ii = labels.begin();ii!=labels.end();ii++)
//    cout << *ii << ",";
//  cout << "." << endl;
  for (map <string,label_ref>::const_iterator ii=label_name_to_label_ref_map.begin();ii!=label_name_to_label_ref_map.end();++ii)
    if (ii==label_name_to_label_ref_map.begin())
      cout << ii->first << "(" << ii->second << ")";
    else
    cout << "," << ii->first << "(" << ii->second << ")";
  cout << "." << endl;
}

void
automaton::print_size() const
{
  cout << locations.size() << " loc., " << active_transitions_size() << " (" << transitions.size() << ")" << " trans., " << dim << " dim.";
  get_memory();
}
  
void
automaton::print() const
{
  cout << "Automaton " << name << endl;
	print_size();
	cout << endl << endl;

  variable_id_map muvnvec=get_var_names_mu();
		
  // Print variables in order
  cout << "Variables: ";
  for (unsigned int i=0;i<dim;++i)
  {
    for (variable_id_map::const_iterator ii=var_id_map.begin();ii!=var_id_map.end();++ii)
      if (ii->first==i)
      {
        if (variables.contains(i))
          cout << ii->second;                 // internal variable
        else
          if (!parameters.contains(i))
            cout << "(" << ii->second << ")"; // external variable
          else
            cout << "[" << ii->second << "]"; // parameter

        if (i+1<dim)
          cout << ",";
      };
  };
  cout << "." << endl;
//  cout << variables;

  print_labels();
  variable_id_map vnvec=get_var_names();
  clock_val_set mycvs;

  for (location_ref i = 0; i != locations.size(); ++i)
  {
    cout << "Location " << i << ": " << locations[i].name << endl;
/*    cout << "Time post poly:" << endl;
    cout << locations[i].time_post_poly() << endl;
locations[i].time_post_poly().print_gen_fp_raw(cout);
    
//    mycvs=clock_val_set((NNC_Polyhedron)locations[i].time_post_poly);
//    mycvs.print(vnvec);
//        if (locations[i].time_pre_poly==stop_time_pre_poly(locations[i].time_pre_poly.space_dimension())) cout << "- no time elapse - ";
    cout << "Invariant:" << endl;
//    locations[i].invariant.print(vnvec);
locations[i].invariant().print_gen_fp_raw(cout);*/
locations[i].print();
    cout << endl;
  };


  string lname;
  for (transition_ref i = 0; i != transitions.size(); ++i)
  {
    // get label name
    lname=get_label_name(transitions[i].label);
    
    cout << "Transition " << i << " from ";
		if (locations[transitions[i].source_loc()].out_trans.find(i)!=locations[transitions[i].source_loc()].out_trans.end())
			cout << transitions[i].source_loc();
		else
			cout << "(" << transitions[i].source_loc() << ")";
		cout << " to ";
		if (locations[transitions[i].target_loc()].in_trans.find(i)!=locations[transitions[i].target_loc()].in_trans.end())
			cout << transitions[i].target_loc();
		else
			cout << "(" << transitions[i].target_loc() << ")";
		cout << " label " << lname << endl;
//        cout << "Guard:" << endl;
//        transitions[i].guard.print();
////        if (locations[i].time_pre_poly==stop_time_pre_poly(locations[i].time_pre_poly.space_dimension())) cout << "- no time elapse - ";
//        cout << "Resets:" << endl;
//        cout << transitions[i].resets << endl;
    cout << "Mu:" << endl;
    mycvs=get_restricted_mu(i);
    mycvs.print(muvnvec);
//    cout << "Exit-Set:" << endl;
//    transitions[i].exit_set.print();
//    cout << "Entry-Set:" << endl;
//    transitions[i].entry_set.print();
    cout << endl;
  };

  cout << "Initial states: " << endl;
  ini_states.print(get_loc_names());
}

void
automaton::print_phaver(ostream& o) const
{
  o << "automaton " << name << endl << endl;

  variable_id_map muvnvec=get_var_names_mu();
  clock_ref_set crs_contr,crs_input,crs_par;
   	
  // Print variables in order
  for (unsigned int i=0;i<dim;++i)
  {
    for (variable_id_map::const_iterator ii=var_id_map.begin();ii!=var_id_map.end();++ii)
      if (ii->first==i)
      {
        if (variables.contains(i))
//          cout << ii->first;                 // internal variable
crs_contr.insert(ii->first);
        else
          if (!parameters.contains(i))
//            cout << "(" << ii->first << ")"; // external variable
crs_input.insert(ii->first);
          else
//            cout << "[" << ii->first << "]"; // parameter
crs_par.insert(ii->first);

      };
  };
  
  if (crs_contr.begin()!=crs_contr.end())
  {
      o << "contr_var: ";
      for (clock_ref_set::const_iterator it=crs_contr.begin();it!=crs_contr.end();++it)
      {
         if (it!=crs_contr.begin())
         {
            o << ",";
         }
         o << muvnvec.get_name(*it);
      }
      o << ";" << endl;
  }
  
  if (crs_input.begin()!=crs_input.end())
  {
      o << "input_var: ";
      for (clock_ref_set::const_iterator it=crs_input.begin();it!=crs_input.end();++it)
      {
         if (it!=crs_input.begin())
         {
            o << ",";
         }
         o << muvnvec.get_name(*it);
      }
      o << ";" << endl;
  }
    
  if (crs_par.begin()!=crs_par.end())
  {
      o << "parameter: ";
      for (clock_ref_set::const_iterator it=crs_par.begin();it!=crs_par.end();++it)
      {
         if (it!=crs_par.begin())
         {
            o << ",";
         }
         o << muvnvec.get_name(*it);
      }
      o << ";" << endl;
  }    
  
  
  o << endl;
  o << "synclabs: ";
  bool is_first=true;
  for (map <string,label_ref>::const_iterator ii=label_name_to_label_ref_map.begin();ii!=label_name_to_label_ref_map.end();++ii)
  {
    if (ii->second!=0) // note: label 0 is by definition included and not declared
    {
      if (!is_first) 
         o << ",";
       o << ii->first;
      is_first=false;
    }
  }
  o << ";" << endl;
  o << endl;
    
  variable_id_map vnvec=get_var_names();
  clock_val_set mycvs,cvs;
  convex_clock_val_set ccvs;
  Constraint_List cl;
  
  for (location_ref i = 0; i != locations.size(); ++i)
  {
    o << "loc " << locations[i].name << ":" << endl;
    o << "while "; 
    locations[i].invariant().print_phaver(o,vnvec);
    o << " wait { ";
    if (!locations[i].get_mylinvtef_tp().is_empty() || locations[i].get_mystatic_tp().is_universe())
    {
      //locations[i].get_mylinvtef_tp().print_phaver(o,vnvec);
      // swap the dimensions
      cl=locations[i].get_mylinvtef_tp();
      cl.add_space_dimensions_and_embed(dim);
      cl.dimension_move_assign(0,dim-1,dim);
      cl.print_phaver(o,vnvec);
    }
    if (!locations[i].get_mystatic_tp().is_universe())
    {
      if (!locations[i].get_mylinvtef_tp().is_empty())
         o << " & ";
      ccvs=locations[i].get_mystatic_tp();
      // move the dimensions up
      ccvs.add_space_dimensions_and_embed(dim);
      ccvs.dimension_move_assign(0,dim-1,dim);
      ccvs.print_phaver(o,vnvec);
//      locations[i].get_mystatic_tp().print_phaver(o,vnvec);
    }
    o << " };" << endl;
    
    // transitions
    for (trans_ref_set::iterator ti=locations[i].out_trans.begin();ti!=locations[i].out_trans.end();ti++)
    {
      o << "when ";
      mycvs=transitions[*ti].unrestricted_mu();
      cvs=mycvs;
      if (cvs.dim>1)
         cvs.remove_space_dimensions(cvs.dim/2,cvs.dim-1);
      cvs.print_phaver(o,vnvec);
      o << " sync ";
      o << get_label_name(transitions[*ti].label);     
      o << " do {";
      mycvs.print_phaver(o,vnvec);
      o << "} goto ";
      o << locations[transitions[*ti].target_loc()].name;
      o << ";" << endl;
    }
    
    o << endl;
  };

  o << "initially: " << endl;
  ini_states.print_phaver(o);
  o << ";" << endl << endl;
  o << "end" << endl;
  o << endl;
}

void
automaton::print_dot(ostream& os) const
{
ostringstream o;

   o << "digraph comm {" << endl;
   o << "rankdir=LR;orientation=landscape" << endl;
   o << "size=\"10,7.5\";" << endl;

  o << "// automaton " << name << endl << endl;

  variable_id_map muvnvec=get_var_names_mu();
  clock_ref_set crs_contr,crs_input,crs_par;
   	
  // Print variables in order
  for (unsigned int i=0;i<dim;++i)
  {
    for (variable_id_map::const_iterator ii=var_id_map.begin();ii!=var_id_map.end();++ii)
      if (ii->first==i)
      {
        if (variables.contains(i))
//          cout << ii->first;                 // internal variable
crs_contr.insert(ii->first);
        else
          if (!parameters.contains(i))
//            cout << "(" << ii->first << ")"; // external variable
crs_input.insert(ii->first);
          else
//            cout << "[" << ii->first << "]"; // parameter
crs_par.insert(ii->first);

      };
  };
  
  if (crs_contr.begin()!=crs_contr.end())
  {
      o << "// contr_var: ";
      for (clock_ref_set::const_iterator it=crs_contr.begin();it!=crs_contr.end();++it)
      {
         if (it!=crs_contr.begin())
         {
            o << ",";
         }
         o << muvnvec.get_name(*it);
      }
      o << ";" << endl;
  }
  
  if (crs_input.begin()!=crs_input.end())
  {
      o << "// input_var: ";
      for (clock_ref_set::const_iterator it=crs_input.begin();it!=crs_input.end();++it)
      {
         if (it!=crs_input.begin())
         {
            o << ",";
         }
         o << muvnvec.get_name(*it);
      }
      o << ";" << endl;
  }
    
  if (crs_par.begin()!=crs_par.end())
  {
      o << "// parameter: ";
      for (clock_ref_set::const_iterator it=crs_par.begin();it!=crs_par.end();++it)
      {
         if (it!=crs_par.begin())
         {
            o << ",";
         }
         o << muvnvec.get_name(*it);
      }
      o << ";" << endl;
  }    
  
  
  o << endl;
  o << "// synclabs: ";
  bool is_first=true;
  for (map <string,label_ref>::const_iterator ii=label_name_to_label_ref_map.begin();ii!=label_name_to_label_ref_map.end();++ii)
  {
    if (ii->second!=0) // note: label 0 is by definition included and not declared
    {
      if (!is_first) 
         o << ",";
       o << ii->first;
      is_first=false;
    }
  }
  o << ";" << endl;
  o << endl;
    
  variable_id_map vnvec=get_var_names();
  clock_val_set mycvs,cvs;
  convex_clock_val_set ccvs;
  Constraint_List cl;
  
  for (location_ref i = 0; i != locations.size(); ++i)
  {
      o << i << " [ shape=circle, ";
      // mark initial locations
      if (ini_states.is_intersecting(locations[i].name,clock_val_set(dim)))
      {
         o << "peripheries=2, ";
      }
         
      o << "label=\"" << locations[i].name << "\\n";
    locations[i].invariant().print_phaver(o,vnvec);
    o << "\\n"; 
    if (!locations[i].get_mylinvtef_tp().is_empty() || locations[i].get_mystatic_tp().is_universe())
    {
      //locations[i].get_mylinvtef_tp().print_phaver(o,vnvec);
      // swap the dimensions
      cl=locations[i].get_mylinvtef_tp();
      cl.add_space_dimensions_and_embed(dim);
      cl.dimension_move_assign(0,dim-1,dim);
      cl.print_phaver(o,vnvec);
    }
    if (!locations[i].get_mystatic_tp().is_universe())
    {
      if (!locations[i].get_mylinvtef_tp().is_empty())
         o << " & ";
      ccvs=locations[i].get_mystatic_tp();
      // move the dimensions up
      ccvs.add_space_dimensions_and_embed(dim);
      ccvs.dimension_move_assign(0,dim-1,dim);
      ccvs.print_phaver(o,vnvec);
//      locations[i].get_mystatic_tp().print_phaver(o,vnvec);
    }
      o << "\" ]" << endl;
  }
    
  clock_val_set const_mu(2*dim);
  // Add constraints to mu so that controlled vars remain equal
  for (clock_ref_set::const_iterator ii=variables.begin();ii!=variables.end();++ii)
  { const_mu.add_constraint(Variable(*ii)==Variable((*ii)+dim)); };
  // Add constraints to mu so that parameters remain equal
  for (clock_ref_set::const_iterator ii=parameters.begin();ii!=parameters.end();++ii)
  { const_mu.add_constraint(Variable(*ii)==Variable((*ii)+dim)); };
  
  clock_val_set mycvs2;
  // get input variables
  clock_ref_set crs_tmp=variables,notfree_vars;
  crs_tmp.union_assign(parameters);
  // double it because it's a relation
  for (clock_ref_set::const_iterator ii=crs_tmp.begin();ii!=crs_tmp.end();++ii)
  { 
   notfree_vars.insert(*ii);
   notfree_vars.insert(*ii+dim);
  };
  clock_val_set free_mu(2*dim-notfree_vars.size());
    
  for (location_ref i = 0; i != locations.size(); ++i)
  {
    // transitions
    for (trans_ref_set::iterator ti=locations[i].out_trans.begin();ti!=locations[i].out_trans.end();ti++)
    {
      mycvs=transitions[*ti].unrestricted_mu();
      mycvs2=mycvs;
      mycvs2.remove_space_dimensions(notfree_vars);
      // if variables remain constant, don't show transitions
      if (const_mu.contains(mycvs) && mycvs2.contains(free_mu))
      {
         // if the guard is the invariant, don't show anything
         mycvs2=mycvs;
         mycvs2.remove_space_dimensions(0,dim-1); // it's now the guard
         if (mycvs2.contains(locations[transitions[*ti].source_loc()].invariant()))
         {
            // if it's a tau-transition, don't show anything
            if (transitions[*ti].label==0 && transitions[*ti].target_loc()==transitions[*ti].source_loc() )
            {
            }
            else
            {
               // show the label guard
               o << i << " -> " << transitions[*ti].target_loc() << "[ label=\"";
               o << get_label_name(transitions[*ti].label);            
               o << "\" ]" << endl;
            }
         }
         else
         {
            // show the guard
            o << i << " -> " << transitions[*ti].target_loc() << "[ label=\"";
            o << get_label_name(transitions[*ti].label);
            o << "\\n";     
            mycvs2.print_phaver(o,vnvec);
            o << "\" ]" << endl;
         }
      }
      else
      {
         // show complete transition
         o << i << " -> " << transitions[*ti].target_loc() << "[ label=\"";
         o << get_label_name(transitions[*ti].label);
         o << "\\n";     
         //mycvs.print_phaver(o,vnvec);
         // show only nonconstant constraints
         Constraint_List cl;
         clock_ref_set cc;
         for (list<convex_clock_val_set>::const_iterator it=mycvs.ccvs_list.begin();it!=mycvs.ccvs_list.end();++it)
         {
            if (it!=mycvs.ccvs_list.begin())
               o << "| \\n";     
            cl=get_nonconsts_in_rel(convex_clock_val_set_to_Constraint_List(*it));
            if (cl.size()>0)
               cl.print_phaver(o,vnvec);
            // show which variables are free
            cc=get_free_vars_in_relation(*it);
//cout << *it;           
//cout << " => " << cc << endl;       
            if (!cc.empty())
            {    
               for (clock_ref_set::const_iterator ii=cc.begin();ii!=cc.end();++ii)
               {
                  if (ii!=cc.begin())
                     o << ",";     
                  o << muvnvec.get_name(*ii+dim);
               }
               o << " in Reals";
            }
         }
         o << "\" ]" << endl;
      }
    }
    
    o << endl;
  };
  
   // postamble
   o << "}" << endl;   

  o << "/* initially: " << endl;
  ini_states.print_phaver(o);
  o << ";" << endl << endl;
  o << "end */" << endl;
  o << endl;
  
  
  // replace stuff in string and the send it to stream
  string s=o.str();
  string s_find="&";
  string s_repl="&\\n";
  // replace & with &\n
  size_t i=0;
  size_t j=s.find(s_find,i);
  while (j!=string::npos)
  {
  //string& replace( size_type index1, size_type num1, const string& str, size_type index2, size_type num2 );
   s.replace(j,s_find.length(),s_repl,0,s_repl.length());
   j=s.find(s_find,j+1);
  }
  
  os << s;
}

void
automaton::print_inv_fp_raw(ostream& o) const
{
  stopwatch sw(2100,"print_inv_fp_raw");
	message(2100,"Saving all locations of " + name +" in raw floating point format.");	

	for (location_ref i = 0; i != locations.size(); ++i)
	{
		locations[i].invariant().print_gen_fp_raw(o);
		o << endl;
	};
}

void
automaton::print_snapshot_fp_raw(const symb_state_maplist& states, string filename) const
{
  stopwatch sw(2100,"print_snapshot_fp_raw");
	//message(2100,"Saving all surface locations of " + name +" in raw floating point format.");	

	ofstream file_out_a,file_out_b,file_out_c;
	file_out_a.open( (filename+".a").c_str() );
	file_out_b.open( (filename+".b").c_str() );
	file_out_c.open( (filename+".c").c_str() );
	//file_out_a.precision(FP_PRECISION);
	//file_out_b.precision(FP_PRECISION);
	
clock_val_set cvs;
	for (symb_state_maplist::const_iterator it=states.begin();it!=states.end();++it)
	{
		it->print_gen_fp_raw(file_out_a);
		file_out_a << endl;
		if (locations[it->loc].is_surface)
		{
			it->print_gen_fp_raw(file_out_b);
			file_out_b << endl;
		};
cvs=(*it);
if (cvs.dim>2)
	cvs.remove_space_dimensions(2,cvs.dim-1);
cvs.print_gen_fp_raw(file_out_c);
	};
	file_out_a.close();
	file_out_b.close();
	file_out_c.close();
}

void
automaton::print_surface_fp_raw(ostream& o) const
{
  stopwatch sw(2100,"print_surface_fp_raw");
	message(2100,"Saving all surface locations of " + name +" in raw floating point format.");	

	for (location_ref i = 0; i != locations.size(); ++i)
	{
		if (locations[i].is_surface)
			locations[i].invariant().print_gen_fp_raw(o);
		o << endl;
	};
}

void 
automaton::print_graph(ostream& o, clock_ref_set& pvars, symb_states_type& reach) const
{
  stopwatch sw(2100,"print_graph");
	message(2100,"Saving graph " + name +" in GasTeX format.");	
	
	o.precision(12);
	int hor_connected=10;
//	const double node_width=0.5;
	double scale_factor = 0.75*1e2/sqrt((double)locations.size());
	double node_width=0.5*scale_factor;
	double node_height=node_width;
	double node_radius=node_width/2;
  double fontsize = node_width;
	//Nw=27.66,Nh=16.93,Nmr=4
		
	if (pvars.size()>2)
		throw_error("print_graph: too many variables, maximal 2!");
	if (pvars.size()<=0)
		throw_error("print_graph: no variables, need minimum of 1!");

	symb_state_plist dummylist;
	symb_state_maplist constates(reach,dummylist);
			
	o << "\\documentclass{article}" << endl;
	o << "\\usepackage{times,mathptmx} \\usepackage[T1]{fontenc}" << endl;
	o << "\\usepackage{gastex}" << endl;
	o << "\\begin{document}" << endl;
	o << "\\centering" << endl;	

	// find the min and max value of the variables
	// put the invariants into a state set
	symb_states_type states=get_invariants();
	// project states onto pvars
	states.project_to_vars(pvars);
	clock_val_set global_space(states.union_over_locations());
	
	// for each variable, find min. and max.
	double_point v_mina(2);
	double_point v_maxa(2);
	// initialize with zeroes
	for (uint i=0;i<2;++i)
	{
		v_mina[i]=0;
		v_maxa[i]=0;		
	};
	Integer n,d;
	bool dummy;
	bool bounded;
	for (dimension_type i=0; i<pvars.size(); ++i)
	{
		bounded=global_space.minimize(Linear_Expression(Variable(i)),n,d,dummy);
		if (bounded)
		{
			v_mina[i]=Rational(n,d).get_d();
		}
		else
			throw_error("print_graph: Variable not bounded!");
		bounded=global_space.maximize(Linear_Expression(Variable(i)),n,d,dummy);
		if (bounded)
		{
			v_maxa[i]=Rational(n,d).get_d();
		}
		else
			throw_error("print_graph: Variable not bounded!");
	};
	
	const double max_size_x=150; // mm width
	const double max_size_y=150; // mm height
	
	// fix the scale to the maximum value possible
	double xscale(1e10); // something really big
	double yscale(1e10); // something really big
	if (v_maxa[0]-v_mina[0]>0)
		xscale=min(xscale,max_size_x/(v_maxa[0]-v_mina[0]));
	if (v_maxa[1]-v_mina[1]>0)
		yscale=min(yscale,max_size_y/(v_maxa[1]-v_mina[1]));
		
	o << "\\unitlength 0.7mm" << endl;		
	o << "\\fontsize{"<<fontsize<<"}{"<<fontsize<<"} \\selectfont" << endl;		
	// specify width and height, and origin
	o << "\\begin{picture}(";
	o << xscale*(v_maxa[0]-v_mina[0]) << "," << yscale*(v_maxa[1]-v_mina[1]) << ")";
//	o << "(0," << yscale*(v_maxa[1]-v_mina[1]) << ")" << endl;
	o << "(0,0)" << endl;

//	o << "\\gasset{linewidth=0.01,AHLength=0.5,AHlength=0.5" << "," << "Nw=" << node_width << ",Nh=" << node_height << ",Nmr=" << node_radius << "}" << endl;
	o << "\\gasset{linewidth="<<0.05*scale_factor<<",AHLength="<<0.25*scale_factor<<",AHlength="<<0.25*scale_factor << "," << "Nw=" << node_width << ",Nh=" << node_height << ",Nmr=" << node_radius << "}" << endl;
	// output nodes=locations
	vector <double_point> loc_pos(locations.size());
	double_point_list dpl;
	double_point ctr_point(pvars.size());
	for (uint i=0; i<locations.size(); ++i)
	{
		// get the postition of the location = center of the invariant
		dpl.clear();
		add_cvs_to_double_point_list(states[i],dpl);
		get_double_point_list_center(dpl,ctr_point);
		
		// output node parameters and id
//		o << "\\node[" << "Nw=" << node_width << ",Nh=" << node_height << ",Nmr=" << node_radius << "](n" << i << ")";
		o << "\\node[";
		if (!constates.is_empty(i))
//			o << "Nfill=y";
					o << "linegray=0";
		else
//			o << "Nfill=n";
					o << "linegray=0.5";
		o << "](n" << i << ")";
		// output position
		o << "(" << (ctr_point[0]-v_mina[0])*xscale << ",";
		if (pvars.size()>1)
			o << (ctr_point[1]-v_mina[1])*yscale;
		else
			o << 0;
		o << "){${" << locations[i].priority << "}$}" << endl;
	};
	
	loc_ref_set lrs;
	location_ref tloc;
	automaton& myself=const_cast<automaton&>(*this);
	// output edges=transitions
	for (uint i=0; i<transitions.size(); ++i)
	{
		if (transition_is_active(i))
		{
			o << "\\drawedge[";
			// draw edge light if it is strongly connected
			tloc=transitions[i].target_loc();
			if (constates.is_empty(transitions[i].source_loc()) || constates.is_empty(tloc))
			{ // if the target is not reachable, make it really light
				o << "linegray=0.7";
			}
			else
			{
				lrs.clear();
				myself.get_post_locs(constates,tloc,hor_connected,lrs,true);
				if (lrs.find(transitions[i].source_loc())!=lrs.end())
					o << "linegray=0.5";
				else
					o << "linegray=0";
			};
			o << "](n" << transitions[i].source_loc() <<",n" << transitions[i].target_loc() << "){}" << endl;
		};
	};
	
	o << "\\end{picture}";
	o << "\\end{document}";
	o << endl;
}
// ---------------------------------------------------------------------------

// Post and pre operations

void
automaton::print(symb_state_maplist& m, automaton& aut)
{
  for (map<location_ref, symb_state_plist >::const_iterator i=m.iter_map.begin();i!=m.iter_map.end();++i)
  {
    cout << "Location " << i->first << ":" << aut.locations[i->first].name << endl;
    for (list< list<symb_state>::iterator >::const_iterator j=i->second.begin();j!=i->second.end();++j)
    {
      (*j)->print();
    };
  };
}

// helper function to prettify transition labels
clock_ref_set get_free_vars_in_relation(const convex_clock_val_set& c)
{
   // assuming c is a relation, find the variables for which
   // all pairs of (p,p') are in c
   assert(c.space_dimension()%2==0);
   
   clock_ref_set crs,crs2;
   dimension_type dim=c.space_dimension()/2;
   
   if (dim>0)
   {
      convex_clock_val_set s;
      for (dimension_type i=0;i<dim;++i)
      {
         s=c;
         crs2.clear();
         crs2.insert(i);
         crs2.insert(i+dim);
         s.remove_space_dimensions(crs2.complement(0,dim-1));
         if (s.is_universe())
            crs.insert(i);
      }
   }
   return crs;
}

clock_ref_set get_constant_vars_in_relation(const convex_clock_val_set& c)
{
   // assuming c is a relation, find the variables for which
   // all pairs of (p,p') are in c
   assert(c.space_dimension()%2==0);
   
   clock_ref_set crs,crs2;
   dimension_type dim=c.space_dimension()/2;
   
   if (dim>0)
   {
      convex_clock_val_set s;
      for (dimension_type i=0;i<dim;++i)
      {
         s=convex_clock_val_set(c.space_dimension());
         s.add_constraint(Variable(i)==Variable(i+dim));
         if (s.contains(c))
            crs.insert(i);
      }
   }
   return crs;
}
