/***************************************************************************
 *   Copyright (C) 2004 by Goran Frehse                                    *
 *   gfrehse@localhost                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef GUARD_location_h
#define GUARD_location_h

#include <stdio.h>
#include <iostream>
#include <vector>
#include <list>
#include <set>
#include <map>
#include <algorithm>
#include <stdexcept>

//#include "parameters.h"
#include "general.h"
#include "clock_val_set.h"
#include "symb_states.h"
#include "stopwatch.h"
#include "variable_time_elapse_func.h"

using namespace Parma_Polyhedra_Library;
using namespace Parma_Polyhedra_Library::IO_Operators;
using namespace std;

// -------------------------------------------------------------------------
// Automaton-specific classes
// -------------------------------------------------------------------------

typedef clock_val_set AUT_invariant;
typedef clock_val_set AUT_guard;
//typedef convex_clock_val_set time_elapse_poly;
typedef convex_clock_val_set time_elapse_poly;

extern bool REFINE_USE_FP;
extern int TP_CONSTRAINT_LIMIT;
extern int CONSTRAINT_BITSIZE;

extern int MEMORY_MODE;

//--------------------------------------------------------------------------
// Location
// -------------------------------------------------------------------------

class location
{
	// ATTENTION: must pay attention to pmyvtef pointer
  public:
//  location(const AUT_invariant& invar,const string& str,const time_elapse_poly& post_poly); 
  location(const AUT_invariant& invar,const string& str,const Constraint_List& post_poly); 

	const clock_val_set& invariant() const
	{
		return myinvariant;
	};
   
   int get_memory() const;
	
	time_elapse_poly time_post_poly() const; 
	time_elapse_poly time_pre_poly() const;
	
	time_elapse_poly time_post_poly(const clock_val_set& restr) const; 
	time_elapse_poly time_post_poly_starting_from( clock_val_set& start) const;
	
	bool is_variable_time() const { return is_variable_time_elapse; };
	bool is_time_post_poly_uptodate() const { return time_post_poly_uptodate; };
	bool is_time_pre_poly_uptodate() const { return time_pre_poly_uptodate; };
	
   // Manipulation Methods
   void add_space_dimensions_and_embed(dimension_type ndims);
   void map_space_dimensions(const PFunction& pfunc);	
	
   void time_post_poly_assign(const time_elapse_poly& tp);	
	void time_post_poly_intersection_assign(const time_elapse_poly& tp)
	{
		if (is_variable_time_elapse)
		{
			mylinvtef.static_time_post_poly_intersection_assign(tp);
			time_post_poly_uptodate=false;
			time_pre_poly_uptodate=false;
		}
		else
		{
			mytime_post_poly.intersection_assign(tp);
			time_pre_poly_uptodate=false;
		};
	};
	
	void invariant_add_constraint(const Constraint& c);
	
	void invariant_assign(const clock_val_set& cvs)
	{
		myinvariant=clock_val_set(cvs.get_convex_hull()); // time elapse can only handle convex invariants, so enforce it here. 
      // To do: Maybe not the right place to do this?
		assume_invariant_modification();
	};
		
	void invariant_intersection_assign(const clock_val_set& cvs)
	{
		myinvariant.intersection_assign(cvs);
		assume_invariant_modification();
	};
	
	void assume_invariant_modification()
	{
		is_fully_refined=false;
		if (is_variable_time_elapse || REFINE_USE_FP)
		{
			assume_time_poly_modification();
		};
	};

	void assume_time_poly_modification()
	{
		time_post_poly_uptodate=false;
		time_pre_poly_uptodate=false;
	};
	
	void overwrite(location& l)
	{
		// replace *this with l, but keep the incoming and outgoing transitions
		l.out_trans.union_assign(out_trans);
		l.in_trans.union_assign(in_trans);
		(*this)=l;
	};
	
	void intersection_assign(const location& l);
	
	void reverse()
	{
		// reverse the causality:
		// incoming transitions turn to outgoing,
		// mytime_post_poly etc. are mirrored at zero (so they become negative)
		trans_ref_set buffer(out_trans);
		out_trans=in_trans;
		in_trans=buffer;
		
		mytime_post_poly.pointmirror_assign();
		mytime_pre_poly.pointmirror_assign();
		mylinvtef.reverse();
	};
	
	Constraint_List get_mylinvtef_tp() const
	{
		return mylinvtef.get_mytp();
	};

	convex_clock_val_set get_mystatic_tp() const
	{
		return mylinvtef.static_tp;
	};   
   
	void get_linear_system_matrices(TNT::Array2D<Integer>& A, TNT::Array1D<Integer>& b, TNT::Array1D<Integer>& den) const
   {
     mylinvtef.get_linear_system_matrices(A, b, den);
   };

   
   	
  // Utility Methods
  void print() const;
  
  // Properties
  string            name;
  trans_ref_set     out_trans;
  trans_ref_set     in_trans;
	bool              is_fully_refined;
	bool              is_surface;
	int               partition_level;
	int               priority;
        int               nr_checks;
	
	private:
  AUT_invariant     myinvariant;
  time_elapse_poly  mytime_post_poly;
  time_elapse_poly  mytime_pre_poly;
	linear_vtef       mylinvtef;
	bool time_pre_poly_uptodate;
	bool time_post_poly_uptodate;
	bool is_variable_time_elapse;
};


#endif
