#ifndef GUARD_optimal_split_h
#define GUARD_optimal_split_h
/***************************************************************************
 *   Copyright (C) 2004 by Goran Frehse                                    *
 *   gfrehse@localhost                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <stdio.h>
#include <iostream>
#include <fstream>
#include <vector>
#include <list>
#include <set>
#include <map>
#include <algorithm>
#include <stdexcept>

//#include "parameters.h"
#include "general.h"
#include "clock_val_set.h"
#include "symb_states.h"
#include "stopwatch.h"
#include "location.h"
#include "transition.h"
#include "deriv_ops.h" // for refinement
#include "rat_linexpression.h"
#include "automaton.h"

#include "DHR_Rational.h"
#include "DHR_PolyhedronSet.h"
#include "DHR_split.h"

extern int DHR_output_level;
extern bool DHR_HALF_CUT_METHOD;
extern Rational DHR_THRESHOLD_PHAVER;
extern DHR_Rational DHR_THRESHOLD;
extern Integer DHR_THRESHOLD_num;
extern Integer DHR_THRESHOLD_den;
extern clock_ref_set REFINE_DHR_VARS;
extern clock_ref_set REFINE_DHR_FCTS;

using namespace Parma_Polyhedra_Library;
using namespace Parma_Polyhedra_Library::IO_Operators;
using namespace std;

//extern unsigned int VERBOSE_LEVEL;
extern unsigned int DEBUG_OUTPUT;

extern int REFINE_LOCATION_PLANE;

bool get_optimal_split_plane(automaton& aut,location_ref loc,clock_val_set inv,const clock_val_set& reached, Constraint& con, bool& failure);
	// compute the optimal plane con
	// returns true if it was successful in finding a useful split

void set_REFINE_DHR_VARS(clock_ref_set& crs, clock_ref_set& crs2);
void set_DHR_THRESHOLD_PHAVER(Rational r);

bool is_reachable_DHR(automaton& aut,const symb_states_type& orig_target,Rational split_ratio,symb_states_type& reach_set);

#endif
