/***************************************************************************
                          stopwatch.cpp  -  description
                             -------------------
    begin                : Thu Feb 5 2004
    copyright            : (C) 2004 by Goran Frehse
    email                : goran.frehse@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//#include <stdlib.h>
 
//#include <stdio.h>
//#include <iostream>
//#include <time.h>

#include "stopwatch.h"

 stopwatch::stopwatch() : start(clock()),report_time(clock()),name(""){} //start counting time
 stopwatch::stopwatch(string s) : start(clock()),report_time(clock()),name(s){} //start counting time
 stopwatch::stopwatch(unsigned int level, string s) : start(clock()),report_time(clock()),name(s),verbose_level(level){} //start counting time
 stopwatch::~stopwatch()
 {
  if ((VERBOSE_LEVEL & 1) != 0)
//    cout <<"Time in " << name << ": "<< (long double)(total)/(long double)(CLOCKS_PER_SEC) <<"s"<<endl;
//    long double tt;
//    tt=(long double)(total)/(long double)(CLOCKS_PER_SEC);
//
    message(verbose_level,"Time in " + name + ": " + double2string(value()) + "s");
//if (verbose_level<128000)
//cout << clock() << "-" << start << endl;
 }
 
 double
 stopwatch::value()
 {
	// returns the time since the start
  clock_t total = clock()-start; //get elapsed time
  return (long double)(total)/(long double)(CLOCKS_PER_SEC);
 }
 
double
 stopwatch::delta()
 {
	// returns the time since the last report or delta call
  clock_t total = clock()-report_time; //get elapsed time
  report_time=clock();
//if (verbose_level<128000)
//cout << clock() << "-" << start << endl;
  return (long double)(total)/(long double)(CLOCKS_PER_SEC);
 }
 
 void
 stopwatch::report()
 {
	// output the clock time and remember the report time
  report_time=clock();
  cout <<"Current time in " << name << ": "<< value() <<"s"<<endl << flush;
 }

 void
 stopwatch::report_delta()
 {
	// output the time since last report and remember the report time
  cout <<"Delta-Time in " << name << ": "<< delta() <<"s"<<endl << flush;
 }

 void
 stopwatch::report_delta(string s)
 {
	// output the time since last report and remember the report time
  cout <<"Delta-Time in " << name << " after " << s << ": "<< delta() <<"s"<<endl << flush;
 }
