#include <stdexcept>
#include <limits>
#include <boost/dynamic_bitset.hpp>
#include "IterationVectorsMDP.h"
#include "MDPExporter.h"

namespace prohver {
  using namespace std;
  using namespace boost;

  void MDPExporter::setOutput(const string &outFn__) {
    outFn = outFn__;
  }

  void MDPExporter::setIterationVectors(const IterationVectorsMDP &iters__) {
    iters = &iters__;
  }

  void MDPExporter::setPrintMarkovChain(bool printMarkovChain__) {
    printMarkovChain = printMarkovChain__;
  }

  string MDPExporter::nodeColor(bool init, bool unsafe) {
    if (!init && !unsafe) {
      return "white";
    } else if (init && !unsafe) {
      return "green";
    } else if (!init && unsafe) {
      return "red";
    } else if (init && unsafe) {
      return "yellow";
    } else {
      throw runtime_error("No idea how we get here.");
    }
  }

  void MDPExporter::computeReach
  (unsigned state, vector<unsigned> &reach) {
    const SparseNonDet &mdp(iters->getModel());
    const unsigned numStates(mdp.getNumStates());
    const vector<unsigned> &scheduler(iters->scheduler);
    dynamic_bitset<> foundStates(numStates);
    foundStates[state] = true;
    reach.push_back(state);
    vector<unsigned> next;
    next.push_back(state);

    while (0 != next.size()) {
      vector<unsigned> nextP;
      for (unsigned stateNr(0); stateNr < next.size(); stateNr++) {
	const unsigned state = next[stateNr];
	const unsigned choice(scheduler[state]);
	if (!iters->targets[state] && numeric_limits<unsigned>::max() != choice) {
	  unsigned choiceBegin(mdp.getChoiceBegin(choice));
	  unsigned choiceEnd(mdp.getChoiceEnd(choice));
	  for (unsigned succNr(choiceBegin); succNr < choiceEnd; succNr++) {
	    const unsigned succState(mdp.getSuccState(succNr));
	    if (!foundStates[succState]) {
	      foundStates[succState] = true;
	      nextP.push_back(succState);
	      reach.push_back(succState);
	    }
	  }
	}
      }
      nextP.swap(next);
    }
  }

  void MDPExporter::computeIncludeStates(dynamic_bitset<> &includeStates) {
    const SparseNonDet &mdp(iters->getModel());
    const unsigned numStates(mdp.getNumStates());
    const double precision(iters->precision);
    
    double maxProb(0.0);

    for (unsigned initNr(0); initNr < mdp.getInit().size(); initNr++) {
      unsigned state(mdp.getInit()[initNr]);
      maxProb = max(maxProb, iters->result[state]);
    }

    vector<unsigned> candidates;

    for (unsigned initNr(0); initNr < mdp.getInit().size(); initNr++) {
      unsigned state(mdp.getInit()[initNr]);
      if (abs(maxProb - iters->result[state]) < precision) {
	candidates.push_back(state);
      }
    }

    vector<unsigned> minReach;
    for (unsigned candNr(0); candNr < candidates.size(); candNr++) {
      unsigned state(candidates[candNr]);
      vector<unsigned> reach;
      computeReach(state, reach);
      if ((0 == minReach.size()) || (reach.size() < minReach.size())) {
	minReach.swap(reach);
      }
    }

    includeStates.resize(numStates, false);
    for (unsigned stateNr(0); stateNr < minReach.size(); stateNr++) {
      const unsigned state(minReach[stateNr]);
      includeStates[state] = true;
    }
  }

}
